/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.gestcomm;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openconcerto.erp.generationDoc.AbstractJOOReportsSheet;
import org.openconcerto.erp.generationDoc.AbstractSheetXml;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.utils.Tuple2;

public class CourrierClientSheet
extends AbstractJOOReportsSheet {
    private SQLRow rowCourrier;
    private static final Tuple2<String, String> tuple = Tuple2.create("LocationCourrier", "Courrier");

    public static Tuple2<String, String> getTuple2Location() {
        return tuple;
    }

    public CourrierClientSheet(SQLRow row) {
        this.rowCourrier = row;
        Date d = (Date)this.rowCourrier.getObject("DATE");
        String year = yearFormat.format(d);
        this.init(year, "Courrier.odt", "CourrierPrinter", tuple);
    }

    @Override
    protected Map createMap() {
        HashMap<String, String> m = new HashMap<String, String>();
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("MODELE_COURRIER_CLIENT");
        SQLRow rowModele = elt.getTable().getRow(this.rowCourrier.getInt("ID_MODELE_COURRIER_CLIENT"));
        String contenu = rowModele.getString("CONTENU");
        m.put("Objet", this.rowCourrier.getString("NOM"));
        m.put("Date", dateFormat.format(this.rowCourrier.getDate("DATE").getTime()));
        int idAdresse = this.rowCourrier.getInt("ID_ADRESSE");
        if (idAdresse > 1) {
            SQLRow rowAdresseClient = this.rowCourrier.getForeignRow("ID_ADRESSE");
            m.put("clientNom", rowAdresseClient.getString("DEST"));
            m.put("clientAdresse", rowAdresseClient.getString("RUE"));
            m.put("codePostal", CourrierClientSheet.getVilleCP(rowAdresseClient.getString("VILLE")));
            String villeCli = CourrierClientSheet.getVille(rowAdresseClient.getString("VILLE"));
            Object cedexCli = rowAdresseClient.getObject("CEDEX");
            boolean hasCedexCli = rowAdresseClient.getBoolean("HAS_CEDEX");
            if (hasCedexCli) {
                villeCli = String.valueOf(villeCli) + " CEDEX";
                if (cedexCli != null && cedexCli.toString().trim().length() > 0) {
                    villeCli = String.valueOf(villeCli) + " " + cedexCli.toString().trim();
                }
            }
            m.put("ville", villeCli);
        }
        return m;
    }

    @Override
    public String getFileName() {
        String fileName = "Courrier_" + AbstractSheetXml.getValidFileName(this.rowCourrier.getString("NUMERO"));
        return fileName;
    }
}

