/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.gestcomm;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import org.openconcerto.erp.generationDoc.AbstractSheetXml;
import org.openconcerto.erp.generationDoc.SheetXml;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.utils.Tuple2;

public class CommandeXmlSheet
extends AbstractSheetXml {
    private static final Tuple2<String, String> tuple = Tuple2.create("LocationCmd", "Commande fournisseur");

    public static Tuple2<String, String> getTuple2Location() {
        return tuple;
    }

    @Override
    public SQLRow getRowLanguage() {
        SQLRow rowFournisseur = this.row.getForeignRow("ID_FOURNISSEUR");
        if (rowFournisseur.getTable().contains("ID_LANGUE")) {
            return rowFournisseur.getForeignRow("ID_LANGUE");
        }
        return super.getRowLanguage();
    }

    public CommandeXmlSheet(SQLRow row) {
        super(row);
        this.printer = PrinterNXProps.getInstance().getStringProperty("CmdPrinter");
        this.elt = Configuration.getInstance().getDirectory().getElement("COMMANDE");
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)row.getObject("DATE"));
        this.locationOO = String.valueOf(SheetXml.getLocationForTuple(tuple, false)) + File.separator + cal.get(1);
        this.locationPDF = String.valueOf(SheetXml.getLocationForTuple(tuple, false)) + File.separator + cal.get(1);
        this.modele = "Commande";
    }

    @Override
    public String getFileName() {
        return CommandeXmlSheet.getValidFileName("Commande_" + this.row.getString("NUMERO"));
    }
}

