/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.jopendocument.link.Component;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.print.DefaultDocumentPrinter;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.FastPrintAskFrame;
import org.openconcerto.erp.core.common.ui.PreviewFrame;
import org.openconcerto.erp.generationDoc.DefaultNXDocumentPrinter;
import org.openconcerto.erp.generationDoc.SheetUtils;
import org.openconcerto.erp.preferences.TemplateNXProps;
import org.openconcerto.openoffice.OOUtils;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.Tuple2;

public abstract class SheetXml {
    protected SQLElement elt;
    protected String printer;
    protected SQLRow row;
    protected SQLRow rowLanguage;
    protected String locationOO;
    protected String locationPDF;
    protected String modele;
    protected File f;
    public static final Tuple2<String, String> tupleDefault = Tuple2.create("Default", "Autres");
    protected static final SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
    protected static final ExecutorService runnableQueue = new ThreadPoolExecutor(0, 1, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    protected static Thread.UncaughtExceptionHandler DEFAULT_HANDLER = new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            ExceptionHandler.handle("Erreur de generation", e);
        }
    };

    public void useOO(File f, boolean visu, boolean impression, String fileName) {
        this.useOO(f, visu, impression, fileName, true);
    }

    public void useOO(final File f, boolean visu, boolean impression, final String fileName, boolean exportPDF) {
        if (f == null || fileName.trim().length() == 0) {
            ExceptionHandler.handle("Erreur lors de la g\u00e9n\u00e9ration du fichier " + fileName);
            return;
        }
        try {
            if (!Boolean.getBoolean("org.openconcerto.oo.useODSViewer")) {
                Component doc = ComptaPropsConfiguration.getOOConnexion().loadDocument(f, !visu);
                if (exportPDF) {
                    doc.saveToPDF(this.getFilePDF()).get();
                }
                if (impression) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("Name", this.printer);
                    doc.printDocument(map);
                }
                doc.close();
            } else {
                final OpenDocument doc = new OpenDocument(f);
                if (exportPDF) {
                    Thread t = new Thread("PDF Export: " + fileName){

                        @Override
                        public void run() {
                            try {
                                SheetUtils.getInstance().convert2PDF(doc, f, fileName);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    };
                    t.setPriority(1);
                    t.start();
                }
                if (visu) {
                    this.showPreviewDocument();
                }
                if (impression) {
                    DefaultDocumentPrinter printer = new DefaultDocumentPrinter();
                    printer.print(doc);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ExceptionHandler.handle("Impossible de charger le document OpenOffice", e);
        }
    }

    public abstract Future<File> genere(boolean var1, boolean var2);

    public abstract String getFileName();

    private String getOOName() {
        return String.valueOf(SheetXml.getValidFileName(this.getFileName())) + ".ods";
    }

    private String getPDFName() {
        return String.valueOf(SheetXml.getValidFileName(this.getFileName())) + ".pdf";
    }

    private String getOO1Name() {
        return String.valueOf(SheetXml.getValidFileName(this.getFileName())) + ".sxc";
    }

    public SQLRow getRowLanguage() {
        return this.rowLanguage;
    }

    public String getReference() {
        return "";
    }

    public static String getLocationForTuple(Tuple2<String, String> t, boolean pdf) {
        String stringProperty = TemplateNXProps.getInstance().getStringProperty(String.valueOf(t.get0()) + (pdf ? "PDF" : "OO"));
        if (stringProperty.equalsIgnoreCase(TemplateNXProps.getInstance().getDefaultStringValue())) {
            return String.valueOf(stringProperty) + File.separator + t.get1();
        }
        return stringProperty;
    }

    private File getFile() {
        if (this.f != null) {
            return this.f;
        }
        File f = new File(String.valueOf(this.locationOO) + File.separator + this.getOOName());
        if (!f.exists()) {
            File f2 = new File(String.valueOf(this.locationOO) + File.separator + this.getOO1Name());
            if (f2.exists()) {
                return f2;
            }
            return f;
        }
        return f;
    }

    public File getFilePDF() {
        File f = new File(String.valueOf(this.locationPDF) + File.separator + this.getPDFName());
        return f;
    }

    public File getFileWithoutExt() {
        File f = new File(String.valueOf(this.locationPDF) + File.separator + SheetXml.getValidFileName(this.getFileName()));
        return f;
    }

    public File getFileODS() {
        File f = new File(String.valueOf(this.locationOO) + File.separator + this.getOOName());
        return f;
    }

    public void showDocument() {
        File f = this.getFile();
        try {
            OOUtils.open(f);
        }
        catch (IOException e) {
            ExceptionHandler.handle("Impossible d'ouvrir " + f.getAbsolutePath(), e);
        }
    }

    public void showPreviewDocument() {
        File f = this.getFile();
        PreviewFrame.show(f);
    }

    public void fastPrintDocument() {
        FastPrintAskFrame f = new FastPrintAskFrame(this);
        f.display();
    }

    public void fastPrintDocument(short copies) {
        File f = this.getFile();
        try {
            if (!Boolean.getBoolean("org.openconcerto.oo.useODSViewer")) {
                Component doc = ComptaPropsConfiguration.getOOConnexion().loadDocument(f, true);
                HashMap<String, String> map = new HashMap<String, String>();
                if (this.printer == null || this.printer.trim().length() == 0) {
                    PrintService printer = PrintServiceLookup.lookupDefaultPrintService();
                    this.printer = printer.getName();
                }
                map.put("Name", this.printer);
                HashMap<String, Comparable<Short>> map2 = new HashMap<String, Comparable<Short>>();
                map2.put("CopyCount", Short.valueOf(copies));
                map2.put("Collate", Boolean.TRUE);
                doc.printDocument(map, map2);
                doc.close();
            } else {
                OpenDocument doc = new OpenDocument(f);
                DefaultNXDocumentPrinter printer = new DefaultNXDocumentPrinter(this.printer, copies);
                printer.print(doc);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle("Impossible de charger le document OpentOffice", e);
            e.printStackTrace();
        }
    }

    public void printDocument() {
        File f = this.getFile();
        try {
            if (!Boolean.getBoolean("org.openconcerto.oo.useODSViewer")) {
                Component doc = ComptaPropsConfiguration.getOOConnexion().loadDocument(f, true);
                doc.printDocument();
                doc.close();
            } else {
                OpenDocument doc = new OpenDocument(f);
                DefaultNXDocumentPrinter printer = new DefaultNXDocumentPrinter();
                printer.print(doc);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle("Impossible de charger le document OpentOffice", e);
            e.printStackTrace();
        }
    }

    public boolean isFileOOExist() {
        File f = this.getFile();
        return f.exists();
    }

    public SQLRow getSQLRow() {
        return this.row;
    }

    public boolean isFileODSExist() {
        File f = this.getFileODS();
        return f.exists();
    }

    public static String getValidFileName(String fileName) {
        StringBuffer result = new StringBuffer(fileName.length());
        int i = 0;
        while (i < fileName.length()) {
            char c = fileName.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_' || c == ' ') {
                result.append(c);
            } else {
                result.append('-');
            }
            ++i;
        }
        return result.toString();
    }

    public String getPrinter() {
        return this.printer;
    }
}

