/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import com.lowagie.text.Document;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.renderer.ODTRenderer;

public class SheetUtils {
    static SheetUtils instance;

    public static SheetUtils getInstance() {
        if (instance == null) {
            instance = new SheetUtils();
        }
        return instance;
    }

    public File convertToOldFile(String fileName, File pathDest, File fDest) {
        return this.convertToOldFile(fileName, pathDest, fDest, ".ods");
    }

    public File convertToOldFile(String fileName, File pathDest, File fDest, String extension) {
        if (fDest.exists()) {
            int i = 0;
            String destName = fileName;
            File pathOld = new File(pathDest, "Historique");
            pathOld.mkdirs();
            while (fDest.exists()) {
                destName = String.valueOf(fileName) + "_" + i;
                fDest = new File(pathOld, String.valueOf(destName) + extension);
                ++i;
            }
            File fTmp = new File(pathDest, String.valueOf(fileName) + extension);
            if (!fTmp.renameTo(fDest)) {
                final File finalFile = fDest;
                System.err.println("Unable to rename:" + fTmp.getAbsolutePath());
                System.err.println("To:" + fDest.getAbsolutePath());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JOptionPane.showMessageDialog(null, "Le fichier " + finalFile.getCanonicalPath() + " n'a pu \u00eatre cr\u00e9\u00e9. \n Impossible de d\u00e9placer le fichier existant dans l'historique.\n V\u00e9rifier que le document n'est pas d\u00e9j\u00e0 ouvert.");
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
                return fTmp;
            }
            fDest = new File(pathDest, String.valueOf(fileName) + extension);
        }
        return fDest;
    }

    public List<File> getHistorique(final String fileName, File pathDest) {
        File pathOld = new File(pathDest, "Historique");
        File[] files = pathOld.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(fileName);
            }
        });
        ArrayList<File> result = new ArrayList<File>();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                result.add(files[i]);
                ++i;
            }
        }
        Collections.sort(result, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return result;
    }

    public void convert2PDF(final OpenDocument doc, final File f, final String fileName) throws Exception {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Document document = new Document(PageSize.A4);
                File outFile = new File(f.getParent(), String.valueOf(fileName) + ".pdf");
                PdfDocument pdf = new PdfDocument();
                document.addDocListener(pdf);
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(outFile);
                    PdfWriter writer = PdfWriter.getInstance(pdf, fileOutputStream);
                    pdf.addWriter(writer);
                    document.open();
                    Rectangle pageSize = document.getPageSize();
                    int w = (int)((double)pageSize.getWidth() * 0.9);
                    int h = (int)((double)pageSize.getHeight() * 0.95);
                    PdfContentByte cb = writer.getDirectContent();
                    PdfTemplate tp = cb.createTemplate(w, h);
                    Graphics2D g2 = tp.createPrinterGraphics(w, h, null);
                    tp.setWidth(w);
                    tp.setHeight(h);
                    ODTRenderer renderer = new ODTRenderer(doc);
                    renderer.setIgnoreMargins(true);
                    renderer.setPaintMaxResolution(true);
                    renderer.setResizeFactor(renderer.getPrintWidth() / (double)w);
                    renderer.paintComponent(g2);
                    g2.dispose();
                    float offsetX = (pageSize.getWidth() - (float)w) / 2.0f;
                    float offsetY = (pageSize.getHeight() - (float)h) / 2.0f;
                    cb.addTemplate(tp, offsetX, offsetY);
                    document.close();
                    writer.close();
                    fileOutputStream.close();
                }
                catch (Exception exn) {
                    exn.printStackTrace();
                }
            }
        });
    }
}

