/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.openconcerto.erp.generationDoc.OOXMLCache;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;

public class OOXMLTableElement {
    private SQLRow row;
    private int firstLine;
    private int endPageLine;
    private int endLine;
    private int filterId;
    private List<String> listBlankLineStyle;
    private boolean typeStyleWhere;
    private SQLElement elt;
    private String foreignTableWhere;
    private String typeWhere;
    private String fieldWhere;
    private Element tableau;

    public OOXMLTableElement(Element tableau, SQLRow row) {
        String fieldAttribute;
        this.tableau = tableau;
        this.foreignTableWhere = tableau.getAttributeValue("tableForeignWhere");
        this.fieldWhere = tableau.getAttributeValue("fieldWhere");
        if (this.fieldWhere != null) {
            this.filterId = row.getInt(this.fieldWhere);
        }
        if ((fieldAttribute = tableau.getAttributeValue("field")) != null) {
            row = row.getForeignRow(fieldAttribute);
        }
        this.row = row;
        this.firstLine = Integer.valueOf(tableau.getAttributeValue("firstLine"));
        this.endPageLine = Integer.valueOf(tableau.getAttributeValue("endPageLine"));
        this.endLine = Integer.valueOf(tableau.getAttributeValue("endLine"));
        this.elt = Configuration.getInstance().getDirectory().getElement(tableau.getAttributeValue("table"));
        this.typeWhere = tableau.getAttributeValue("typeWhere");
        String blankLineBeforeStyle = tableau.getAttributeValue("blankLineBeforeStyle");
        this.listBlankLineStyle = new ArrayList<String>();
        if (blankLineBeforeStyle != null) {
            this.listBlankLineStyle = SQLRow.toList(blankLineBeforeStyle.trim());
        }
        this.typeStyleWhere = this.typeWhere == null ? false : this.typeWhere.equalsIgnoreCase("Style");
    }

    public List<? extends SQLRowAccessor> getRows() {
        SQLTable tableElt = Configuration.getInstance().getRoot().findTable(this.tableau.getAttributeValue("table"));
        if (tableElt != null) {
            return OOXMLCache.getReferentRows(this.row, tableElt, this.tableau.getAttributeValue("groupBy"));
        }
        System.err.println("OOXMLTableElement.getRows() Table " + tableElt + " is null!");
        return new ArrayList();
    }

    public int getFirstLine() {
        return this.firstLine;
    }

    public int getFilterId() {
        return this.filterId;
    }

    public int getEndPageLine() {
        return this.endPageLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public List<String> getListBlankLineStyle() {
        return this.listBlankLineStyle;
    }

    public SQLElement getSQLElement() {
        return this.elt;
    }

    public String getForeignTableWhere() {
        return this.foreignTableWhere;
    }

    public SQLRow getRow() {
        return this.row;
    }

    public Element getTableau() {
        return this.tableau;
    }

    public String getTypeWhere() {
        return this.typeWhere;
    }

    public boolean getTypeStyleWhere() {
        return this.typeStyleWhere;
    }

    public String getFieldWhere() {
        return this.fieldWhere;
    }
}

