/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.print.ODTPrinterXML;
import org.jopendocument.renderer.ODTRenderer;

public class ODTPrinterNX
extends ODTPrinterXML {
    protected ODTRenderer renderer;

    public ODTPrinterNX(OpenDocument doc) {
        super(doc);
        this.renderer = new ODTRenderer(doc);
        this.renderer.setPaintMaxResolution(true);
    }

    public void print(String printerName, int copies) {
        final PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this);
        PrintService myService = null;
        if (printerName != null && printerName.trim().length() != 0) {
            PrintService[] services = PrinterJob.lookupPrintServices();
            int i = 0;
            while (i < services.length) {
                if (services[i].getName().equals(printerName)) {
                    myService = services[i];
                    break;
                }
                ++i;
            }
            if (myService != null) {
                try {
                    printJob.setPrintService(myService);
                }
                catch (PrinterException e) {
                    e.printStackTrace();
                }
            }
        }
        Thread t = myService == null ? new Thread(new Runnable(){

            @Override
            public void run() {
                if (printJob.printDialog()) {
                    try {
                        printJob.print();
                    }
                    catch (PrinterException e) {
                        e.printStackTrace();
                    }
                }
            }
        }) : new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    printJob.print();
                }
                catch (PrinterException e) {
                    e.printStackTrace();
                }
            }
        });
        t.setName("ODTDPrinter Thread");
        t.setDaemon(true);
        t.start();
    }
}

