/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.supplier.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.GestionDevise;

public class HistoriqueFournBilanPanel
extends JPanel {
    private static String asterisque = "* ";
    private static String Cheque = " ch\u00e8que pour un total de ";
    private static String Cheques = " ch\u00e8ques pour un total de ";
    private static String nonDecaisse = " non d\u00e9caiss\u00e9";
    private static String nonDecaisses = " non d\u00e9caiss\u00e9s";
    private static String Achat = " achat pour un total de ";
    private static String Achats = " achats pour un total de ";
    private JLabel labelCheque;
    private JLabel labelNonDecaisse;
    private JLabel labelAchat;
    private JTextField textNbCheque;
    private JTextField textChequeTotal;
    private JTextField textChequeNonDecaisse;
    private JTextField textNbAchat;
    private JTextField textAchatTotal;

    public HistoriqueFournBilanPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.initGridBagConstraints(c);
        JPanel panelAchat = new JPanel(new GridBagLayout());
        this.textNbAchat = new JTextField(asterisque);
        this.textNbAchat.setBorder(null);
        this.textNbAchat.setEditable(false);
        GridBagConstraints cc = new GridBagConstraints();
        this.initGridBagConstraints(cc);
        cc.gridx = -1;
        cc.weightx = 1.0;
        panelAchat.add((Component)this.textNbAchat, cc);
        this.labelAchat = new JLabel(Achat);
        cc.weightx = 0.0;
        panelAchat.add((Component)this.labelAchat, cc);
        this.textAchatTotal = new JTextField();
        this.textAchatTotal.setBorder(null);
        this.textAchatTotal.setEditable(false);
        cc.weightx = 1.0;
        panelAchat.add((Component)this.textAchatTotal, cc);
        JPanel panelCheque = new JPanel(new GridBagLayout());
        this.textNbCheque = new JTextField(asterisque);
        this.textNbCheque.setBorder(null);
        this.textNbCheque.setEditable(false);
        GridBagConstraints cc2 = new GridBagConstraints();
        this.initGridBagConstraints(cc2);
        cc2.gridx = -1;
        cc2.weightx = 1.0;
        panelCheque.add((Component)this.textNbCheque, cc2);
        this.labelCheque = new JLabel(Cheque);
        cc2.weightx = 0.0;
        panelCheque.add((Component)this.labelCheque, cc2);
        this.textChequeTotal = new JTextField();
        this.textChequeTotal.setBorder(null);
        this.textChequeTotal.setEditable(false);
        cc2.weightx = 1.0;
        panelCheque.add((Component)this.textChequeTotal, cc2);
        cc2.weightx = 0.0;
        panelCheque.add(new JLabel(" dont "));
        this.textChequeNonDecaisse = new JTextField();
        this.textChequeNonDecaisse.setBorder(null);
        this.textChequeNonDecaisse.setEditable(false);
        cc2.weightx = 1.0;
        panelCheque.add((Component)this.textChequeNonDecaisse, cc2);
        this.labelNonDecaisse = new JLabel(nonDecaisse);
        cc2.weightx = 0.0;
        panelCheque.add((Component)this.labelNonDecaisse, cc2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.fill = 0;
        this.add((Component)panelAchat, c);
        ++c.gridy;
        this.add((Component)panelCheque, c);
        this.updateData(-1);
    }

    public void updateData(final int idFournisseur) {
        new Thread(){

            @Override
            public void run() {
                HistoriqueFournBilanPanel.this.updateChequeData(idFournisseur);
                HistoriqueFournBilanPanel.this.updateAchatData(idFournisseur);
            }
        }.start();
    }

    private void updateChequeData(int idFournisseur) {
        List lnb;
        SQLBase base = ((ComptaPropsConfiguration)ComptaPropsConfiguration.getInstance()).getSQLBaseSociete();
        SQLTable tableC = base.getTable("CHEQUE_FOURNISSEUR");
        final long valueTotal = this.getSumForField(tableC.getField("MONTANT"), idFournisseur);
        SQLSelect selNb = new SQLSelect(base);
        selNb.addSelectStar(tableC);
        if (idFournisseur > 1) {
            selNb.setWhere(String.valueOf(tableC.getName()) + ".ID_FOURNISSEUR", "=", idFournisseur);
        }
        final int nombreCheque = (lnb = (List)base.getDataSource().execute(selNb.asString(), new ArrayListHandler())) == null ? 0 : lnb.size();
        SQLSelect sel = new SQLSelect(base);
        sel.addSelectStar(tableC);
        Where w = new Where((FieldRef)tableC.getField("DECAISSE"), "=", (Object)Boolean.FALSE);
        if (idFournisseur > 1) {
            w = w.and(new Where((FieldRef)tableC.getField("ID_FOURNISSEUR"), "=", idFournisseur));
        }
        sel.setWhere(w);
        List l = (List)base.getDataSource().execute(sel.asString(), new ArrayListHandler());
        final int valueNonEncaisse = l == null ? 0 : l.size();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HistoriqueFournBilanPanel.this.textChequeTotal.setText(GestionDevise.currencyToString(valueTotal, true));
                HistoriqueFournBilanPanel.this.textChequeNonDecaisse.setText(String.valueOf(valueNonEncaisse));
                HistoriqueFournBilanPanel.this.textNbCheque.setText(String.valueOf(asterisque) + nombreCheque);
                if (nombreCheque > 1) {
                    HistoriqueFournBilanPanel.this.labelCheque.setText(Cheques);
                } else {
                    HistoriqueFournBilanPanel.this.labelCheque.setText(Cheque);
                }
                if (valueNonEncaisse > 1) {
                    HistoriqueFournBilanPanel.this.labelNonDecaisse.setText(nonDecaisses);
                } else {
                    HistoriqueFournBilanPanel.this.labelNonDecaisse.setText(nonDecaisse);
                }
            }
        });
    }

    private void updateAchatData(int idFournisseur) {
        List lnb;
        SQLBase base = ((ComptaPropsConfiguration)ComptaPropsConfiguration.getInstance()).getSQLBaseSociete();
        SQLTable tableC = base.getTable("SAISIE_ACHAT");
        final long valueTotal = this.getSumForField(tableC.getField("MONTANT_TTC"), idFournisseur);
        SQLSelect selNb = new SQLSelect(base);
        selNb.addSelectStar(tableC);
        if (idFournisseur > 1) {
            selNb.setWhere(String.valueOf(tableC.getName()) + ".ID_FOURNISSEUR", "=", idFournisseur);
        }
        final int nombreAchat = (lnb = (List)base.getDataSource().execute(selNb.asString(), new ArrayListHandler())) == null ? 0 : lnb.size();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HistoriqueFournBilanPanel.this.textAchatTotal.setText(GestionDevise.currencyToString(valueTotal, true));
                HistoriqueFournBilanPanel.this.textNbAchat.setText(String.valueOf(asterisque) + nombreAchat);
                if (nombreAchat > 1) {
                    HistoriqueFournBilanPanel.this.labelAchat.setText(Achats);
                } else {
                    HistoriqueFournBilanPanel.this.labelAchat.setText(Achat);
                }
            }
        });
    }

    private long getSumForField(SQLField f, int idFourn) {
        SQLSelect sel = new SQLSelect(f.getTable().getBase());
        sel.addSelect(f, "SUM");
        if (idFourn > 1) {
            sel.setWhere(String.valueOf(f.getTable().getName()) + ".ID_FOURNISSEUR", "=", idFourn);
        }
        List l = (List)f.getTable().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
        int i = 0;
        while (i < l.size()) {
            Object[] tmp = (Object[])l.get(i);
            if (tmp != null && tmp[0] != null) {
                return new Double(tmp[0].toString()).longValue();
            }
            ++i;
        }
        return 0L;
    }

    private void initGridBagConstraints(GridBagConstraints g) {
        g.anchor = 17;
        g.fill = 2;
        g.insets = new Insets(2, 2, 1, 2);
        g.gridwidth = 1;
        g.gridheight = 1;
        g.gridx = 0;
        g.gridy = 0;
        g.weightx = 0.0;
        g.weighty = 0.0;
    }
}

