/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.supplier.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.model.ISQLCompteSelector;
import org.openconcerto.erp.preferences.ModeReglementDefautPrefPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.component.ITextArea;

public class FournisseurSQLElement
extends ComptaSQLConfElement {
    public FournisseurSQLElement() {
        super("FOURNISSEUR", "un fournisseur", "fournisseurs");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        l.add("NOM");
        l.add("TYPE");
        l.add("TEL");
        l.add("FAX");
        l.add("ID_MODE_REGLEMENT");
        l.add("ID_COMPTE_PCE");
        l.add("ID_ADRESSE");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        l.add("CODE");
        return l;
    }

    @Override
    public synchronized ListSQLRequest createListRequest() {
        return new ListSQLRequest(this.getTable(), this.getListFields()){

            @Override
            protected void customizeToFetch(SQLRowValues graphToFetch) {
                super.customizeToFetch(graphToFetch);
                graphToFetch.grow("ID_MODE_REGLEMENT").put("AJOURS", null).put("LENJOUR", null);
            }
        };
    }

    @Override
    protected List<String> getPrivateFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_ADRESSE");
        l.add("ID_ADRESSE_E");
        l.add("ID_MODE_REGLEMENT");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            JCheckBox checkEnlevement;
            ElementSQLObject comp2;
            TitledSeparator sep2;

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                JLabel labelCode = new JLabel("Code");
                JTextField textCode = new JTextField();
                c.gridx = 0;
                ++c.gridy;
                c.weightx = 0.0;
                c.weighty = 0.0;
                c.gridwidth = 1;
                this.add((Component)labelCode, c);
                ++c.gridx;
                c.gridwidth = 1;
                c.weightx = 0.5;
                this.add((Component)textCode, c);
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                JLabel labelRS = new JLabel("Forme juridique");
                SQLTextCombo textType = new SQLTextCombo();
                JTextField textNom = new JTextField();
                this.add((Component)labelRS, c);
                ++c.gridx;
                c.weightx = 0.5;
                this.add((Component)textType, c);
                JLabel labelTel = new JLabel(this.getLabelFor("TEL"));
                JTextField textTel = new JTextField();
                ++c.gridx;
                c.weightx = 0.0;
                c.weighty = 0.0;
                c.gridwidth = 1;
                this.add((Component)labelTel, c);
                ++c.gridx;
                c.gridwidth = 1;
                c.weightx = 0.5;
                this.add((Component)textTel, c);
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                this.add((Component)new JLabel(this.getLabelFor("NOM")), c);
                ++c.gridx;
                c.gridwidth = 1;
                c.weightx = 0.5;
                this.add((Component)textNom, c);
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)new JLabel(this.getLabelFor("FAX")), c);
                ++c.gridx;
                c.gridwidth = 0;
                c.weightx = 0.5;
                JTextField textFax = new JTextField();
                this.add((Component)textFax, c);
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                this.add((Component)new JLabel(this.getLabelFor("MAIL")), c);
                ++c.gridx;
                c.gridwidth = 1;
                c.weightx = 0.5;
                JTextField textMail = new JTextField();
                this.add((Component)textMail, c);
                this.addView(textMail, "MAIL");
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)new JLabel(this.getLabelFor("TEL_P")), c);
                ++c.gridx;
                c.gridwidth = 0;
                c.weightx = 0.5;
                JTextField textTelP = new JTextField();
                this.add((Component)textTelP, c);
                this.addView(textTelP, "TEL_P");
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                this.add((Component)new JLabel(this.getLabelFor("ID_LANGUE")), c);
                ++c.gridx;
                c.gridwidth = 1;
                c.weightx = 0.5;
                ElementComboBox langue = new ElementComboBox(true, 35);
                this.add((Component)langue, c);
                this.addView(langue, "ID_LANGUE");
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)new JLabel(this.getLabelFor("RESPONSABLE")), c);
                ++c.gridx;
                c.gridwidth = 0;
                c.weightx = 0.5;
                JTextField textResp = new JTextField();
                this.add((Component)textResp, c);
                this.addView(textResp, "RESPONSABLE");
                c.gridx = 0;
                ++c.gridy;
                c.gridwidth = 0;
                JCheckBox boxUE = new JCheckBox(this.getLabelFor("UE"));
                this.add((Component)boxUE, c);
                JPanel panelAdresse = new JPanel(new GridBagLayout());
                DefaultGridBagConstraints cAdr = new DefaultGridBagConstraints();
                TitledSeparator sep = new TitledSeparator("Adresse");
                panelAdresse.add((Component)sep, cAdr);
                this.sep2 = new TitledSeparator("Adresse d'enl\u00e9vement");
                cAdr.gridx = -1;
                panelAdresse.add((Component)this.sep2, cAdr);
                this.addView("ID_ADRESSE", "required;notdecorated;noseparator");
                ++cAdr.gridy;
                panelAdresse.add((Component)((ElementSQLObject)this.getView("ID_ADRESSE")), cAdr);
                this.addView("ID_ADRESSE_E", "notdecorated");
                cAdr.gridx = -1;
                this.comp2 = (ElementSQLObject)this.getView("ID_ADRESSE_E");
                this.comp2.setCreated(true);
                panelAdresse.add((Component)this.comp2, cAdr);
                c.gridx = 0;
                ++c.gridy;
                c.gridwidth = 0;
                c.weightx = 0.0;
                c.fill = 0;
                this.add((Component)panelAdresse, c);
                c.gridx = 0;
                ++c.gridy;
                c.weightx = 0.0;
                c.gridwidth = 0;
                c.fill = 0;
                this.checkEnlevement = new JCheckBox("Adresse d'enl\u00e8vement identique");
                this.add((Component)this.checkEnlevement, c);
                c.fill = 2;
                this.checkEnlevement.setSelected(true);
                this.sep2.setVisible(false);
                this.checkEnlevement.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.out.println("Click");
                        if (checkEnlevement.isSelected()) {
                            System.out.println("Mode 1");
                            comp2.setEditable(false);
                            comp2.setCreated(false);
                            sep2.setVisible(false);
                        } else {
                            System.out.println("Mode 2");
                            comp2.setEditable(true);
                            comp2.setCreated(true);
                            sep2.setVisible(true);
                        }
                    }
                });
                TitledSeparator reglSep = new TitledSeparator(this.getLabelFor("ID_MODE_REGLEMENT"));
                c.gridwidth = 0;
                ++c.gridy;
                c.gridx = 0;
                this.add((Component)reglSep, c);
                ++c.gridy;
                c.gridx = 0;
                this.addView("ID_MODE_REGLEMENT", "required;notdecorated;noseparator");
                ElementSQLObject eltModeRegl = (ElementSQLObject)this.getView("ID_MODE_REGLEMENT");
                this.add((Component)eltModeRegl, c);
                c.gridx = 0;
                ++c.gridy;
                c.weightx = 1.0;
                c.weighty = 0.0;
                c.gridwidth = 0;
                TitledSeparator sepCompte = new TitledSeparator("Compte associ\u00e9");
                this.add((Component)sepCompte, c);
                JPanel panel = new JPanel(new GridBagLayout());
                DefaultGridBagConstraints c2 = new DefaultGridBagConstraints();
                panel.add((Component)new JLabel(this.getLabelFor("ID_COMPTE_PCE")), c2);
                ISQLCompteSelector compteSel = new ISQLCompteSelector(true);
                ++c2.gridx;
                c2.weightx = 1.0;
                panel.add((Component)compteSel, c2);
                c.gridwidth = 0;
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.anchor = 18;
                this.add((Component)panel, c);
                c.gridx = 0;
                ++c.gridy;
                c.gridheight = 1;
                c.weighty = 0.0;
                c.weightx = 1.0;
                c.anchor = 17;
                c.gridwidth = 0;
                this.add((Component)new TitledSeparator(this.getLabelFor("INFOS")), c);
                ++c.gridy;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.fill = 1;
                ITextArea infos = new ITextArea();
                JScrollPane scrollPane = new JScrollPane(infos);
                scrollPane.setBorder(null);
                this.add((Component)scrollPane, c);
                this.addView(infos, "INFOS");
                this.addSQLObject(textType, "TYPE");
                this.addRequiredSQLObject(textNom, "NOM");
                this.addSQLObject(textCode, "CODE");
                this.addSQLObject(textTel, "TEL");
                this.addSQLObject(textFax, "FAX");
                this.addSQLObject(boxUE, "UE");
                this.addRequiredSQLObject(compteSel, "ID_COMPTE_PCE");
                SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
                SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
                SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);
                int idCompteFourn = rowPrefsCompte.getInt("ID_COMPTE_PCE_FOURNISSEUR");
                if (idCompteFourn <= 1) {
                    try {
                        idCompteFourn = ComptePCESQLElement.getIdComptePceDefault("Fournisseurs");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                compteSel.setValue(idCompteFourn);
            }

            @Override
            public void select(SQLRowAccessor r) {
                if (r != null && r.isForeignEmpty("ID_ADRESSE_E")) {
                    this.checkEnlevement.setSelected(true);
                    this.comp2.setEditable(false);
                    this.comp2.setCreated(false);
                    this.sep2.setVisible(false);
                } else {
                    this.checkEnlevement.setSelected(false);
                    this.comp2.setEditable(true);
                    this.comp2.setCreated(true);
                    this.sep2.setVisible(true);
                }
                super.select(r);
            }

            @Override
            protected SQLRowValues createDefaults() {
                SQLRowValues vals = new SQLRowValues(this.getTable());
                this.checkEnlevement.setSelected(true);
                this.sep2.setVisible(false);
                try {
                    SQLRow r = ModeReglementDefautPrefPanel.getDefaultRow(false);
                    SQLElement eltModeReglement = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
                    if (((SQLRowAccessor)r).getID() > 1) {
                        SQLRowValues rowVals = eltModeReglement.createCopy(((SQLRowAccessor)r).getID());
                        System.err.println(rowVals.getInt("ID_TYPE_REGLEMENT"));
                        vals.put("ID_MODE_REGLEMENT", rowVals);
                    }
                }
                catch (SQLException e) {
                    System.err.println("Impossible de s\u00e9lectionner le mode de r\u00e8glement par d\u00e9faut du client.");
                    e.printStackTrace();
                }
                return vals;
            }
        };
    }
}

