/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.supplychain.order.component.CommandeSQLComponent;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.preferences.DefaultProps;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.ExceptionHandler;

public class MouvementStockSQLElement
extends ComptaSQLConfElement {
    public MouvementStockSQLElement() {
        super("MOUVEMENT_STOCK", "un mouvement de stock", "mouvements de stock");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("NOM");
        l.add("ID_ARTICLE");
        l.add("QTE");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        l.add("QTE");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            private SQLTextCombo textLib;
            private JTextField textQte;
            private JDate date;

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                JLabel labelLib = new JLabel(this.getLabelFor("NOM"), 4);
                this.add((Component)labelLib, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.textLib = new SQLTextCombo();
                this.add((Component)this.textLib, c);
                ++c.gridx;
                c.weightx = 0.0;
                JLabel labelDate = new JLabel(this.getLabelFor("DATE"), 4);
                this.add((Component)labelDate, c);
                ++c.gridx;
                this.date = new JDate(true);
                this.add((Component)this.date, c);
                ElementComboBox articleSelect = new ElementComboBox();
                c.gridx = 0;
                ++c.gridy;
                JLabel labelArticle = new JLabel(this.getLabelFor("ID_ARTICLE"), 4);
                this.add((Component)labelArticle, c);
                ++c.gridx;
                c.gridwidth = 0;
                c.weightx = 1.0;
                this.add((Component)articleSelect, c);
                c.gridwidth = 1;
                c.weightx = 0.0;
                ++c.gridy;
                c.gridx = 0;
                c.anchor = 13;
                JLabel labelQte = new JLabel(this.getLabelFor("QTE"), 4);
                this.add((Component)labelQte, c);
                ++c.gridx;
                c.fill = 0;
                this.textQte = new JTextField(6);
                c.weighty = 1.0;
                c.anchor = 18;
                this.add((Component)this.textQte, c);
                DefaultGridBagConstraints.lockMinimumSize(this.textQte);
                DefaultGridBagConstraints.lockMaximumSize(this.textQte);
                this.addRequiredSQLObject(this.textQte, "QTE");
                this.addSQLObject(this.textLib, "NOM");
                this.addRequiredSQLObject(articleSelect, "ID_ARTICLE");
                this.addRequiredSQLObject(this.date, "DATE");
            }

            @Override
            public int insert(SQLRow order) {
                int id = super.insert(order);
                MouvementStockSQLElement.updateStock(Arrays.asList(id));
                return id;
            }

            @Override
            public void update() {
                int id = this.getSelectedID();
                MouvementStockSQLElement.updateStock(Arrays.asList(id), true);
                super.update();
                MouvementStockSQLElement.updateStock(Arrays.asList(id));
            }
        };
    }

    @Override
    protected void archive(SQLRow row, boolean cutLinks) throws SQLException {
        super.archive(row, cutLinks);
        MouvementStockSQLElement.updateStock(Arrays.asList(row.getID()), true);
    }

    public static CollectionMap<SQLRow, List<SQLRowValues>> updateStock(List<Integer> ids) {
        return MouvementStockSQLElement.updateStock(ids, false);
    }

    public static CollectionMap<SQLRow, List<SQLRowValues>> updateStock(List<Integer> ids, boolean archive) {
        CollectionMap<SQLRow, List<SQLRowValues>> map = new CollectionMap<SQLRow, List<SQLRowValues>>();
        SQLTable tableCmdElt = Configuration.getInstance().getBase().getTable("COMMANDE_ELEMENT");
        for (Integer id : ids) {
            boolean gestionStockMin;
            DefaultProps props;
            String stockMin;
            SQLElement eltMvtStock = Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
            SQLRow rowMvtStock = eltMvtStock.getTable().getRow(id);
            SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
            SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement(sqlTableArticle);
            SQLElement eltStock = Configuration.getInstance().getDirectory().getElement("STOCK");
            SQLRow rowArticle = rowMvtStock.getForeignRow("ID_ARTICLE");
            SQLRow rowStock = rowArticle.getForeignRow("ID_STOCK");
            float qte = rowStock.getFloat("QTE_REEL");
            float qteMvt = rowMvtStock.getFloat("QTE");
            SQLRowValues rowVals = new SQLRowValues(eltStock.getTable());
            float qteNvlle = archive ? qte - qteMvt : qte + qteMvt;
            rowVals.put("QTE_REEL", Float.valueOf(qteNvlle));
            try {
                if (rowStock.getID() <= 1) {
                    SQLRow row = rowVals.insert();
                    SQLRowValues rowValsArt = new SQLRowValues(eltArticle.getTable());
                    rowValsArt.put("ID_STOCK", row.getID());
                    int idArticle = rowArticle.getID();
                    if (idArticle > 1) {
                        rowValsArt.update(idArticle);
                    }
                } else {
                    rowVals.update(rowStock.getID());
                }
            }
            catch (SQLException e) {
                ExceptionHandler.handle("Erreur lors de la mise \u00e0 jour du stock pour l'article " + rowArticle.getString("CODE"));
                e.printStackTrace();
            }
            Boolean bStockMin = !(stockMin = (props = DefaultNXProps.getInstance()).getStringProperty("ArticleStockMin")).equalsIgnoreCase("false");
            boolean bl = gestionStockMin = bStockMin == null || bStockMin != false;
            if (archive || !rowArticle.getTable().getFieldsName().contains("QTE_MIN") || !gestionStockMin || !(qteNvlle < (float)rowArticle.getInt("QTE_MIN"))) continue;
            SQLInjector inj = SQLInjector.getInjector(rowArticle.getTable(), tableCmdElt);
            SQLRowValues rowValsElt = new SQLRowValues(inj.createRowValuesFrom(rowArticle));
            rowValsElt.put("QTE", Math.round((float)rowArticle.getInt("QTE_MIN") - qteNvlle));
            rowValsElt.put("ID_TAXE", rowValsElt.getObject("ID_TAXE"));
            rowValsElt.put("T_POIDS", rowValsElt.getLong("POIDS") * (long)rowValsElt.getInt("QTE"));
            rowValsElt.put("T_PA_HT", rowValsElt.getLong("PA_HT") * (long)rowValsElt.getInt("QTE"));
            rowValsElt.put("T_PA_TTC", (double)rowValsElt.getLong("T_PA_HT") * ((double)rowValsElt.getForeign("ID_TAXE").getFloat("TAUX") / 100.0 + 1.0));
            map.put((Object)rowArticle.getForeignRow("ID_FOURNISSEUR"), rowValsElt);
        }
        return map;
    }

    public static void createCommandeF(final CollectionMap<SQLRow, List<SQLRowValues>> col, final SQLRow rowDevise) {
        if (col.keySet().size() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SQLElement commande = Configuration.getInstance().getDirectory().getElement("COMMANDE");
                    for (SQLRow fournisseur : col.keySet()) {
                        CommandeSQLComponent cmp;
                        EditFrame frame;
                        SQLSelect sel = new SQLSelect(commande.getTable().getBase());
                        sel.addSelectStar(commande.getTable());
                        Where w = new Where((FieldRef)commande.getTable().getField("EN_COURS"), "=", (Object)Boolean.TRUE);
                        w = w.and(new Where((FieldRef)commande.getTable().getField("ID_FOURNISSEUR"), "=", fournisseur.getID()));
                        sel.setWhere(w);
                        List rowsCmd = (List)Configuration.getInstance().getBase().getDataSource().execute(sel.asString(), SQLRowListRSH.createFromSelect(sel));
                        SQLRow commandeExistante = null;
                        if (rowsCmd != null && rowsCmd.size() > 0) {
                            commandeExistante = (SQLRow)rowsCmd.get(0);
                        }
                        if (commandeExistante != null) {
                            frame = new EditFrame(commande, EditPanel.EditMode.MODIFICATION);
                            cmp = (CommandeSQLComponent)frame.getSQLComponent();
                            cmp.select(commandeExistante);
                        } else {
                            frame = new EditFrame(commande);
                            cmp = (CommandeSQLComponent)frame.getSQLComponent();
                            SQLRowValues rowVals = new SQLRowValues(commande.getTable());
                            SQLElement eltComm = Configuration.getInstance().getDirectory().getElement("COMMERCIAL");
                            int idUser = UserManager.getInstance().getCurrentUser().getId();
                            SQLRow rowsComm = SQLBackgroundTableCache.getInstance().getCacheForTable(eltComm.getTable()).getFirstRowContains(idUser, eltComm.getTable().getField("ID_USER_COMMON"));
                            if (rowsComm != null) {
                                rowVals.put("ID_COMMERCIAL", rowsComm.getID());
                            }
                            rowVals.put("ID_FOURNISSEUR", fournisseur.getID());
                            if (rowDevise != null) {
                                rowVals.put("ID_DEVISE", rowDevise.getID());
                            }
                            cmp.select(rowVals);
                            cmp.getRowValuesTable().getRowValuesTable().getRowValuesTableModel().clearRows();
                        }
                        RowValuesTableModel model = cmp.getRowValuesTable().getRowValuesTable().getRowValuesTableModel();
                        SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement("ARTICLE");
                        for (SQLRowValues rowValsElt : (List)col.get(fournisseur)) {
                            SQLRowAccessor rowValsMatch = null;
                            int index = 0;
                            int i = 0;
                            while (i < model.getRowCount()) {
                                SQLRowValues rowValsCmdElt = model.getRowValuesAt(i);
                                if (ReferenceArticleSQLElement.isReferenceEquals(rowValsCmdElt, rowValsElt)) {
                                    rowValsMatch = rowValsCmdElt;
                                    index = i;
                                    break;
                                }
                                ++i;
                            }
                            if (rowValsMatch != null) {
                                int qte = rowValsMatch.getInt("QTE");
                                model.putValue(qte + rowValsElt.getInt("QTE"), index, "QTE");
                                continue;
                            }
                            model.addRow(rowValsElt);
                        }
                        frame.pack();
                        frame.setVisible(true);
                    }
                }
            });
        }
    }

    public static final void showSource(int id) {
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable tableMvt = base.getTable("MOUVEMENT_STOCK");
        String stringTableSource = tableMvt.getRow(id).getString("SOURCE");
        if (id != 1) {
            EditFrame f;
            if (stringTableSource.trim().length() != 0 && tableMvt.getRow(id).getInt("IDSOURCE") != 1) {
                f = new EditFrame(Configuration.getInstance().getDirectory().getElement(stringTableSource), EditPanel.READONLY);
                f.selectionId(tableMvt.getRow(id).getInt("IDSOURCE"));
            } else {
                f = new EditFrame(Configuration.getInstance().getDirectory().getElement(tableMvt), EditPanel.READONLY);
                f.selectionId(id);
            }
            f.pack();
            f.setVisible(true);
        } else {
            System.err.println("Aucun mouvement associ\u00e9, impossible de modifier ou d'acc\u00e9der \u00e0 la source de cette ecriture!");
        }
    }
}

