/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.component;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.common.ui.MontantPanel;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.generationEcritures.GenerationMvtSaisieAchat;
import org.openconcerto.erp.model.ISQLCompteSelector;
import org.openconcerto.erp.preferences.ModeReglementDefautPrefPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class SaisieAchatSQLComponent
extends BaseSQLComponent {
    private JTextField textNumeroFacture;
    private JTextField textNumeroCmd;
    private JTextField textSource;
    private JTextField textIdSource;
    private DeviseField fieldMontantRegle = new DeviseField();
    private JRadioButton radioButtonNumeroFacture;
    private JCheckBox checkImmo;
    private JRadioButton radioButtonNumeroCmd;
    private ButtonGroup grp1;
    private MontantPanel montant;
    private ElementComboBox nomFournisseur;
    private ElementComboBox comboAvoir;
    private ElementSQLObject eltModeRegl;
    private int idFournSelect = 1;
    private PropertyChangeListener listenerModeReglDefaut = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Integer idSeleted = SaisieAchatSQLComponent.this.nomFournisseur.getValue();
            if (idSeleted != null && idSeleted > 1) {
                int idModeRegl;
                SQLElement fournisseur = Configuration.getInstance().getDirectory().getElement("FOURNISSEUR");
                SQLRow rowFourn = fournisseur.getTable().getRow(idSeleted);
                SaisieAchatSQLComponent.this.montant.setUE(rowFourn.getBoolean("UE"));
                if ((SaisieAchatSQLComponent.this.getSelectedID() <= 1 || SaisieAchatSQLComponent.this.idFournSelect != idSeleted) && (idModeRegl = rowFourn.getInt("ID_MODE_REGLEMENT")) > 1 && SaisieAchatSQLComponent.this.eltModeRegl != null && SaisieAchatSQLComponent.this.getMode() == SQLComponent.Mode.INSERTION) {
                    SQLElement sqlEltModeRegl = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
                    SQLRow rowModeRegl = sqlEltModeRegl.getTable().getRow(idModeRegl);
                    SQLRowValues rowVals = rowModeRegl.createUpdateRow();
                    rowVals.clearPrimaryKeys();
                    SaisieAchatSQLComponent.this.eltModeRegl.setValue(rowVals);
                    System.err.println("Select Mode regl " + idModeRegl);
                }
            }
            SaisieAchatSQLComponent.this.idFournSelect = idSeleted == null ? 1 : idSeleted;
        }
    };
    final SQLTable tablePrefCompte = this.getTable().getTable("PREFS_COMPTE");

    public SaisieAchatSQLComponent(SQLElement element) {
        super(element);
    }

    @Override
    public void addViews() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.textIdSource = new JTextField();
        this.textSource = new JTextField();
        c.gridwidth = 0;
        c.gridheight = 1;
        TitledSeparator sep = new TitledSeparator("Renseignements");
        this.add((Component)sep, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.gridx = 0;
        JLabel labelLibelle = new JLabel("Achat de ");
        SQLTextCombo textLibelle = new SQLTextCombo();
        c.weightx = 0.0;
        labelLibelle.setHorizontalAlignment(4);
        this.add((Component)labelLibelle, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 1;
        this.add((Component)textLibelle, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel("Date"), c);
        ++c.gridx;
        c.weightx = 1.0;
        JDate dateSaisie = new JDate(true);
        c.fill = 0;
        this.add((Component)dateSaisie, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 2;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Fournisseur", 4), c);
        ++c.gridx;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.nomFournisseur = new ElementComboBox();
        this.add((Component)this.nomFournisseur, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        c.fill = 2;
        ISQLCompteSelector compteSel = new ISQLCompteSelector();
        this.add((Component)new JLabel(this.getLabelFor("ID_COMPTE_PCE")), c);
        c.gridwidth = 0;
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)compteSel, c);
        c.gridwidth = 1;
        this.radioButtonNumeroFacture = new JRadioButton(this.getLabelFor("NUMERO_FACTURE"));
        this.radioButtonNumeroFacture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaisieAchatSQLComponent.this.textNumeroFacture.setEnabled(true);
                SaisieAchatSQLComponent.this.textNumeroCmd.setEnabled(false);
            }
        });
        c.fill = 0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.add((Component)this.radioButtonNumeroFacture, c);
        this.textNumeroFacture = new JTextField(16);
        DefaultGridBagConstraints.lockMinimumSize(this.textNumeroFacture);
        c.gridx = 1;
        c.gridwidth = 1;
        this.add((Component)this.textNumeroFacture, c);
        this.radioButtonNumeroCmd = new JRadioButton(this.getLabelFor("NUMERO_COMMANDE"));
        this.radioButtonNumeroCmd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaisieAchatSQLComponent.this.textNumeroFacture.setEnabled(false);
                SaisieAchatSQLComponent.this.textNumeroCmd.setEnabled(true);
            }
        });
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.add((Component)this.radioButtonNumeroCmd, c);
        this.textNumeroCmd = new JTextField(16);
        c.gridx = 1;
        c.gridwidth = 1;
        DefaultGridBagConstraints.lockMinimumSize(this.textNumeroCmd);
        this.add((Component)this.textNumeroCmd, c);
        ++c.gridx;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.anchor = 13;
        this.checkImmo = new JCheckBox(this.getLabelFor("IMMO"));
        this.add((Component)this.checkImmo, c);
        c.anchor = 17;
        this.grp1 = new ButtonGroup();
        this.grp1.add(this.radioButtonNumeroCmd);
        this.grp1.add(this.radioButtonNumeroFacture);
        this.radioButtonNumeroFacture.setSelected(true);
        this.textNumeroFacture.setEnabled(true);
        this.textNumeroCmd.setEnabled(false);
        c.gridx = 0;
        ++c.gridy;
        c.insets = new Insets(10, 2, 1, 2);
        c.gridwidth = 0;
        c.fill = 1;
        sep = new TitledSeparator("Montant en euros");
        this.add((Component)sep, c);
        c.insets = new Insets(2, 2, 1, 2);
        c.gridwidth = 4;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.anchor = 17;
        c.fill = 0;
        this.montant = new MontantPanel();
        this.add((Component)this.montant, c);
        JPanel panelAvoir = new JPanel();
        this.comboAvoir = new ElementComboBox(true);
        panelAvoir.add(new JLabel(this.getLabelFor("ID_AVOIR_FOURNISSEUR")));
        this.comboAvoir.setAddIconVisible(false);
        panelAvoir.add(this.comboAvoir);
        panelAvoir.add(new JLabel("Montant r\u00e9gl\u00e9"));
        panelAvoir.add(this.fieldMontantRegle);
        this.fieldMontantRegle.setEditable(false);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.weightx = 0.0;
        c.fill = 0;
        this.add((Component)panelAvoir, c);
        c.gridwidth = 0;
        c.gridx = 0;
        ++c.gridy;
        c.insets = new Insets(10, 2, 1, 2);
        c.fill = 2;
        sep = new TitledSeparator("Mode de r\u00e8glement");
        this.add((Component)sep, c);
        c.insets = new Insets(2, 2, 1, 2);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        this.addView("ID_MODE_REGLEMENT", "required;notdecorated;noseparator");
        this.eltModeRegl = (ElementSQLObject)this.getView("ID_MODE_REGLEMENT");
        this.add((Component)this.eltModeRegl, c);
        c.gridwidth = 0;
        c.gridx = 0;
        ++c.gridy;
        sep = new TitledSeparator("Informations compl\u00e9mentaires");
        c.insets = new Insets(10, 2, 1, 2);
        this.add((Component)sep, c);
        c.insets = new Insets(2, 2, 1, 2);
        c.gridx = 0;
        ++c.gridy;
        c.gridheight = 0;
        c.gridwidth = 0;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 1;
        ITextArea textInfos = new ITextArea(4, 4);
        JScrollPane scrollPane = new JScrollPane(textInfos);
        DefaultGridBagConstraints.lockMinimumSize(scrollPane);
        this.add((Component)textInfos, c);
        this.addSQLObject(textInfos, "INFOS");
        this.addRequiredSQLObject(dateSaisie, "DATE");
        this.addRequiredSQLObject(this.nomFournisseur, "ID_FOURNISSEUR");
        this.addRequiredSQLObject(this.montant.getChoixTaxe(), "ID_TAXE");
        this.addRequiredSQLObject(this.montant.getMontantTTC(), "MONTANT_TTC");
        this.addRequiredSQLObject(this.montant.getMontantHT(), "MONTANT_HT");
        this.addRequiredSQLObject(this.montant.getMontantTVA(), "MONTANT_TVA");
        this.addSQLObject(textLibelle, "NOM");
        this.addSQLObject(this.textNumeroFacture, "NUMERO_FACTURE");
        this.addSQLObject(this.textNumeroCmd, "NUMERO_COMMANDE");
        this.addSQLObject(this.textIdSource, "IDSOURCE");
        this.addSQLObject(this.textSource, "SOURCE");
        this.addRequiredSQLObject(compteSel, "ID_COMPTE_PCE");
        this.addSQLObject(this.comboAvoir, "ID_AVOIR_FOURNISSEUR");
        this.addSQLObject(this.checkImmo, "IMMO");
        this.montant.setChoixTaxe(2);
        this.nomFournisseur.addValueListener(this.listenerModeReglDefaut);
        this.montant.getMontantTTC().getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                SaisieAchatSQLComponent.this.refreshText();
            }
        });
        this.comboAvoir.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SaisieAchatSQLComponent.this.refreshText();
            }
        });
        final SQLTable tableAvoir = Configuration.getInstance().getDirectory().getElement("AVOIR_FOURNISSEUR").getTable();
        this.nomFournisseur.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Where w = new Where((FieldRef)tableAvoir.getField("SOLDE"), "=", (Object)Boolean.FALSE);
                if (SaisieAchatSQLComponent.this.nomFournisseur.isEmpty()) {
                    w.and(new Where((FieldRef)SaisieAchatSQLComponent.this.getTable().getBase().getTable("AVOIR_FOURNISSEUR").getField("ID_FOURNISSEUR"), "=", -1));
                } else {
                    w.and(new Where((FieldRef)SaisieAchatSQLComponent.this.getTable().getBase().getTable("AVOIR_FOURNISSEUR").getField("ID_FOURNISSEUR"), "=", (Object)SaisieAchatSQLComponent.this.nomFournisseur.getValue()));
                }
                if (SaisieAchatSQLComponent.this.getSelectedID() > 1) {
                    SQLRow row = SaisieAchatSQLComponent.this.getTable().getRow(SaisieAchatSQLComponent.this.getSelectedID());
                    w = w.or(new Where((FieldRef)SaisieAchatSQLComponent.this.getTable().getBase().getTable("AVOIR_FOURNISSEUR").getKey(), "=", row.getInt("ID_AVOIR_FOURNISSEUR")));
                }
                SaisieAchatSQLComponent.this.comboAvoir.getRequest().setWhere(null);
                SaisieAchatSQLComponent.this.comboAvoir.getRequest().setWhere(w);
                SaisieAchatSQLComponent.this.comboAvoir.fillCombo();
            }
        });
        Where w = new Where((FieldRef)tableAvoir.getField("SOLDE"), "=", (Object)Boolean.FALSE);
        this.comboAvoir.getRequest().setWhere(w);
        this.comboAvoir.fillCombo();
        DefaultGridBagConstraints.lockMinimumSize(this.nomFournisseur);
        DefaultGridBagConstraints.lockMinimumSize(panelAvoir);
        DefaultGridBagConstraints.lockMinimumSize(this.montant);
        DefaultGridBagConstraints.lockMaximumSize(this.montant);
    }

    @Override
    public synchronized boolean isValidated() {
        boolean b = true;
        if (this.montant.getMontantTTC() != null && this.montant.getMontantTTC().getUncheckedValue() != null) {
            long l = (Long)this.montant.getMontantTTC().getUncheckedValue();
            if (this.comboAvoir != null && !this.comboAvoir.isEmpty() && this.comboAvoir.getSelectedId() > 1) {
                SQLElement eltAvoir = Configuration.getInstance().getDirectory().getElement("AVOIR_FOURNISSEUR");
                SQLRow rowAvoir = eltAvoir.getTable().getRow(this.comboAvoir.getSelectedId());
                l -= ((Number)rowAvoir.getObject("MONTANT_TTC")).longValue();
            }
            boolean bl = b = l >= 0L;
        }
        return super.isValidated() && b;
    }

    @Override
    public int insert(SQLRow order) {
        int id = super.insert(order);
        if (this.comboAvoir.getSelectedId() > 1) {
            SQLTable tableAvoir = Configuration.getInstance().getDirectory().getElement("AVOIR_FOURNISSEUR").getTable();
            SQLRow rowAvoir = tableAvoir.getRow(this.comboAvoir.getSelectedId());
            SQLRowValues rowVals = rowAvoir.createEmptyUpdateRow();
            rowVals.put("SOLDE", Boolean.TRUE);
            try {
                rowVals.update();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        new GenerationMvtSaisieAchat(id);
        return id;
    }

    @Override
    public void select(SQLRowAccessor r) {
        this.nomFournisseur.rmValueListener(this.listenerModeReglDefaut);
        super.select(r);
        if (r != null) {
            int idSeleted;
            System.err.println(r);
            this.montant.calculMontant();
            Object idF = r.getObject("ID_FOURNISSEUR");
            System.err.println("Founisseur " + idF);
            if (idF != null && (idSeleted = Integer.valueOf(idF.toString()).intValue()) > 1) {
                SQLElement fournisseur = Configuration.getInstance().getDirectory().getElement("FOURNISSEUR");
                SQLRow rowFourn = fournisseur.getTable().getRow(idSeleted);
                this.idFournSelect = rowFourn.getID();
                this.montant.setUE(rowFourn.getBoolean("UE"));
            }
            System.out.println("select id Saisie Achat " + r.getID());
        }
        this.nomFournisseur.addValueListener(this.listenerModeReglDefaut);
    }

    @Override
    protected SQLRowValues createDefaults() {
        SQLRow rowPrefsCompte;
        int idCompteAchat;
        SQLRowValues vals = new SQLRowValues(this.getTable());
        try {
            SQLRow r = ModeReglementDefautPrefPanel.getDefaultRow(false);
            SQLElement eltModeReglement = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
            if (r.getID() > 1) {
                SQLRowValues rowVals = eltModeReglement.createCopy(r, null);
                System.err.println("Primary Keys " + rowVals.getID());
                rowVals.clearPrimaryKeys();
                System.err.println(rowVals.getInt("ID_TYPE_REGLEMENT"));
                vals.put("ID_MODE_REGLEMENT", rowVals);
            }
        }
        catch (SQLException e) {
            System.err.println("Impossible de s\u00e9lectionner le mode de r\u00e8glement par d\u00e9faut du client.");
            e.printStackTrace();
        }
        if ((idCompteAchat = (rowPrefsCompte = SQLBackgroundTableCache.getInstance().getCacheForTable(this.tablePrefCompte).getRowFromId(2)).getInt("ID_COMPTE_PCE_ACHAT")) <= 1) {
            try {
                idCompteAchat = ComptePCESQLElement.getIdComptePceDefault("Achats");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        vals.put("ID_COMPTE_PCE", idCompteAchat);
        vals.put("ID_TAXE", 2);
        return vals;
    }

    @Override
    public void update() {
        if (JOptionPane.showConfirmDialog(this, "Attention en modifiant cette facture, vous supprimerez les ch\u00e9ques et les \u00e9ch\u00e9ances associ\u00e9s. Continuer?", "Modification de facture", 0) == 0) {
            super.update();
            if (this.comboAvoir.getSelectedId() > 1) {
                SQLTable tableAvoir = Configuration.getInstance().getDirectory().getElement("AVOIR_FOURNISSEUR").getTable();
                SQLRow rowAvoir = tableAvoir.getRow(this.comboAvoir.getSelectedId());
                SQLRowValues rowVals = rowAvoir.createEmptyUpdateRow();
                rowVals.put("SOLDE", Boolean.TRUE);
                try {
                    rowVals.update();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            SQLRow row = this.getTable().getRow(this.getSelectedID());
            int idMvt = row.getInt("ID_MOUVEMENT");
            System.err.println("__________***************** UPDATE" + idMvt);
            EcritureSQLElement eltEcr = (EcritureSQLElement)Configuration.getInstance().getDirectory().getElement("ECRITURE");
            eltEcr.archiveMouvementProfondeur(idMvt, false);
            new GenerationMvtSaisieAchat(this.getSelectedID(), idMvt);
        }
    }

    private void refreshText() {
        Number n = (Number)this.montant.getMontantTTC().getUncheckedValue();
        if (this.comboAvoir.getSelectedId() > 1) {
            SQLTable tableAvoir = Configuration.getInstance().getDirectory().getElement("AVOIR_FOURNISSEUR").getTable();
            if (n != null) {
                long ttc = n.longValue();
                SQLRow rowAvoir = tableAvoir.getRow(this.comboAvoir.getSelectedId());
                long totalAvoir = ((Number)rowAvoir.getObject("MONTANT_TTC")).longValue();
                this.fieldMontantRegle.setValue(GestionDevise.currencyToString(ttc - totalAvoir));
            } else {
                this.fieldMontantRegle.setValue(GestionDevise.currencyToString(0L));
            }
        } else if (n != null) {
            this.fieldMontantRegle.setValue(GestionDevise.currencyToString(n.longValue()));
        } else {
            this.fieldMontantRegle.setValue(GestionDevise.currencyToString(0L));
        }
    }

    public final void loadCommande(int id) {
        this.loadFromTable("COMMANDE", id);
    }

    public final void loadBonReception(int id) {
        this.loadFromTable("BON_RECEPTION", id);
    }

    private final void loadFromTable(String tableName, int id) {
        this.montant.setEnabled(false);
        this.montant.getChoixTaxe().setVisible(false);
        if (id > 1) {
            SQLElement eltCommande = Configuration.getInstance().getDirectory().getElement(tableName);
            SQLInjector injector = SQLInjector.getInjector(eltCommande.getTable(), this.getTable());
            this.select(injector.createRowValuesFrom(id));
        }
    }
}

