/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.action;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.core.sales.order.element.CommandeClientSQLElement;
import org.openconcerto.erp.core.sales.order.report.CommandeClientXmlSheet;
import org.openconcerto.erp.core.sales.order.ui.CommandeClientRenderer;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class ListeDesCommandesClientAction
extends CreateFrameAbstractAction {
    public ListeDesCommandesClientAction() {
        this.putValue("Name", "Liste des commandes clients");
    }

    @Override
    public JFrame createFrame() {
        final IListFrame frame = new IListFrame(new ListeAddPanel(Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT")){

            @Override
            protected GridBagConstraints createConstraints() {
                GridBagConstraints c = super.createConstraints();
                ++c.gridy;
                return c;
            }
        });
        CommandeClientRenderer rend = CommandeClientRenderer.getInstance();
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        JPanel legendePanel = rend.getLegendePanel();
        legendePanel.setBorder(BorderFactory.createTitledBorder("L\u00e9gende"));
        legendePanel.setOpaque(true);
        c.fill = 0;
        frame.getPanel().add((Component)legendePanel, c);
        JTable table = frame.getPanel().getListe().getJTable();
        int i = 0;
        while (i < table.getColumnCount()) {
            table.getColumnModel().getColumn(i).setCellRenderer(rend);
            ++i;
        }
        frame.getPanel().getListe().getJTable().addMouseListener(new MouseSheetXmlListeListener(frame.getPanel().getListe(), CommandeClientXmlSheet.class){

            @Override
            public List<AbstractAction> addToMenu() {
                AbstractAction bonAction = new AbstractAction("Transfert vers BL"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ListeDesCommandesClientAction.this.transfertBonLivraisonClient(frame.getPanel().getListe().getSelectedRow());
                    }
                };
                AbstractAction factureAction = new AbstractAction("Transfert vers facture"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ListeDesCommandesClientAction.this.transfertFactureClient(frame.getPanel().getListe().getSelectedRow());
                    }
                };
                AbstractAction cmdAction = new AbstractAction("Transfert vers commande fournisseur"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CommandeClientSQLElement elt = (CommandeClientSQLElement)Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT");
                        elt.transfertCommande(frame.getPanel().getListe().getSelectedRow().getID());
                    }
                };
                ArrayList<AbstractAction> l = new ArrayList<AbstractAction>();
                l.add(bonAction);
                l.add(factureAction);
                l.add(cmdAction);
                return l;
            }
        });
        return frame;
    }

    private void transfertBonLivraisonClient(SQLRow row) {
        CommandeClientSQLElement elt = (CommandeClientSQLElement)Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT");
        elt.transfertBonLivraison(row.getID());
    }

    private void transfertFactureClient(SQLRow row) {
        CommandeClientSQLElement elt = (CommandeClientSQLElement)Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT");
        elt.transfertFacture(row.getID());
    }
}

