/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.shipment.report;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import org.openconcerto.erp.generationDoc.AbstractSheetXml;
import org.openconcerto.erp.generationDoc.SheetXml;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.utils.Tuple2;

public class BonLivraisonXmlSheet
extends AbstractSheetXml {
    private static final Tuple2<String, String> tuple = Tuple2.create("LocationBon", "Bon de livraison");

    public static Tuple2<String, String> getTuple2Location() {
        return tuple;
    }

    @Override
    public String getReference() {
        return this.row.getString("NOM");
    }

    @Override
    public SQLRow getRowLanguage() {
        SQLRow rowClient = this.row.getForeignRow("ID_CLIENT");
        if (rowClient.getTable().contains("ID_LANGUE")) {
            return rowClient.getForeignRow("ID_LANGUE");
        }
        return super.getRowLanguage();
    }

    public BonLivraisonXmlSheet(SQLRow row) {
        super(row);
        this.printer = PrinterNXProps.getInstance().getStringProperty("BonPrinter");
        this.elt = Configuration.getInstance().getDirectory().getElement("BON_DE_LIVRAISON");
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)row.getObject("DATE"));
        this.locationOO = String.valueOf(SheetXml.getLocationForTuple(tuple, false)) + File.separator + cal.get(1);
        this.locationPDF = String.valueOf(SheetXml.getLocationForTuple(tuple, true)) + File.separator + cal.get(1);
        this.modele = "BonLivraison";
    }

    @Override
    public String getFileName() {
        return BonLivraisonXmlSheet.getValidFileName("BonLivraison_" + this.row.getString("NUMERO"));
    }
}

