/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.shipment.action;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.core.sales.shipment.element.BonDeLivraisonSQLElement;
import org.openconcerto.erp.core.sales.shipment.report.BonLivraisonXmlSheet;
import org.openconcerto.erp.core.sales.shipment.ui.BonLivraisionRenderer;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class ListeDesBonsDeLivraisonAction
extends CreateFrameAbstractAction {
    public ListeDesBonsDeLivraisonAction() {
        this.putValue("Name", "Liste des bons de livraison");
    }

    @Override
    public JFrame createFrame() {
        final IListFrame edit1 = new IListFrame(new ListeAddPanel(Configuration.getInstance().getDirectory().getElement("BON_DE_LIVRAISON")){

            @Override
            protected GridBagConstraints createConstraints() {
                GridBagConstraints c = super.createConstraints();
                ++c.gridy;
                return c;
            }
        });
        JTable table = edit1.getPanel().getListe().getJTable();
        BonLivraisionRenderer rend = BonLivraisionRenderer.getInstance();
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        JPanel legendePanel = rend.getLegendePanel();
        legendePanel.setBorder(BorderFactory.createTitledBorder("L\u00e9gende"));
        legendePanel.setOpaque(true);
        c.fill = 0;
        edit1.getPanel().add((Component)legendePanel, c);
        int i = 0;
        while (i < table.getColumnCount()) {
            table.getColumnModel().getColumn(i).setCellRenderer(rend);
            ++i;
        }
        table.addMouseListener(new MouseSheetXmlListeListener(edit1.getPanel().getListe(), BonLivraisonXmlSheet.class){

            @Override
            public List<AbstractAction> addToMenu() {
                AbstractAction actionTransfertFacture = new AbstractAction("Transfert en facture"){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        ListeDesBonsDeLivraisonAction.this.transfertFactureClient(edit1.getPanel().getListe().getSelectedRow());
                    }
                };
                ArrayList<AbstractAction> l = new ArrayList<AbstractAction>();
                l.add(actionTransfertFacture);
                return l;
            }
        });
        return edit1;
    }

    private void transfertFactureClient(SQLRow row) {
        BonDeLivraisonSQLElement elt = (BonDeLivraisonSQLElement)Configuration.getInstance().getDirectory().getElement("BON_DE_LIVRAISON");
        elt.transfertFacture(row.getID());
    }
}

