/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.quote.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.openconcerto.erp.core.sales.invoice.ui.DateEnvoiRenderer;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.quote.component.DevisSQLComponent;
import org.openconcerto.erp.core.sales.quote.element.DevisItemSQLElement;
import org.openconcerto.erp.core.sales.quote.element.DevisSQLElement;
import org.openconcerto.erp.core.sales.quote.report.DevisXmlSheet;
import org.openconcerto.erp.core.supplychain.stock.element.MouvementStockSQLElement;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.IListener;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelColumnPath;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.table.TimestampTableCellEditor;
import org.openconcerto.utils.CollectionMap;

public class ListeDesDevisPanel
extends JPanel {
    private JTabbedPane tabbedPane = new JTabbedPane();
    private Map<Integer, ListeAddPanel> map = new HashMap<Integer, ListeAddPanel>();
    private SQLElement eltDevis = Configuration.getInstance().getDirectory().getElement("DEVIS");
    private JButton buttonShow;
    private JButton buttonGen;
    private JButton buttonPrint;
    private JButton buttonFacture;
    private JButton buttonCmd;
    private JButton buttonClone;
    private EditFrame editFrame;

    public ListeDesDevisPanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 0;
        ListeAddPanel panelAttente = this.createPanel(2);
        this.map.put(this.tabbedPane.getTabCount(), panelAttente);
        this.tabbedPane.add("En attente", panelAttente);
        ListeAddPanel panelAccepte = this.createPanel(4);
        this.map.put(this.tabbedPane.getTabCount(), panelAccepte);
        this.tabbedPane.add("Accept\u00e9", panelAccepte);
        ListeAddPanel panelRefuse = this.createPanel(3);
        this.map.put(this.tabbedPane.getTabCount(), panelRefuse);
        this.tabbedPane.add("Refus\u00e9", panelRefuse);
        this.buttonGen = new JButton("G\u00e9n\u00e9rer le document");
        this.add((Component)this.buttonGen, c);
        this.buttonGen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeAddPanel selectedPanel = (ListeAddPanel)ListeDesDevisPanel.this.map.get(ListeDesDevisPanel.this.tabbedPane.getSelectedIndex());
                SQLRow row = selectedPanel.getListe().getSelectedRow();
                DevisXmlSheet sheet = new DevisXmlSheet(row);
                sheet.genere(true, false);
            }
        });
        this.buttonShow = new JButton("Voir le document");
        ++c.gridx;
        this.add((Component)this.buttonShow, c);
        this.buttonShow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeAddPanel selectedPanel = (ListeAddPanel)ListeDesDevisPanel.this.map.get(ListeDesDevisPanel.this.tabbedPane.getSelectedIndex());
                SQLRow row = selectedPanel.getListe().getSelectedRow();
                DevisXmlSheet sheet = new DevisXmlSheet(row);
                sheet.showDocument();
            }
        });
        this.buttonPrint = new JButton("Impression");
        ++c.gridx;
        this.add((Component)this.buttonPrint, c);
        this.buttonPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeAddPanel selectedPanel = (ListeAddPanel)ListeDesDevisPanel.this.map.get(ListeDesDevisPanel.this.tabbedPane.getSelectedIndex());
                SQLRow row = selectedPanel.getListe().getSelectedRow();
                DevisXmlSheet sheet = new DevisXmlSheet(row);
                sheet.fastPrintDocument();
            }
        });
        this.buttonFacture = new JButton("Transfert en facture");
        ++c.gridx;
        this.add((Component)this.buttonFacture, c);
        this.buttonFacture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeAddPanel selectedPanel = (ListeAddPanel)ListeDesDevisPanel.this.map.get(ListeDesDevisPanel.this.tabbedPane.getSelectedIndex());
                SQLRow row = selectedPanel.getListe().getSelectedRow();
                ListeDesDevisPanel.this.transfertFacture(row);
            }
        });
        this.buttonCmd = new JButton("Transfert en commande client");
        ++c.gridx;
        this.add((Component)this.buttonCmd, c);
        this.buttonCmd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeAddPanel selectedPanel = (ListeAddPanel)ListeDesDevisPanel.this.map.get(ListeDesDevisPanel.this.tabbedPane.getSelectedIndex());
                SQLRow row = selectedPanel.getListe().getSelectedRow();
                ListeDesDevisPanel.this.transfertCommandeClient(row);
            }
        });
        this.buttonClone = new JButton("Cr\u00e9er \u00e0 partir de");
        ++c.gridx;
        this.add((Component)this.buttonClone, c);
        this.buttonClone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeAddPanel selectedPanel = (ListeAddPanel)ListeDesDevisPanel.this.map.get(ListeDesDevisPanel.this.tabbedPane.getSelectedIndex());
                SQLRow row = selectedPanel.getListe().getSelectedRow();
                if (ListeDesDevisPanel.this.editFrame == null) {
                    SQLElement eltFact = Configuration.getInstance().getDirectory().getElement("DEVIS");
                    ListeDesDevisPanel.this.editFrame = new EditFrame(eltFact, EditPanel.CREATION);
                }
                ((DevisSQLComponent)ListeDesDevisPanel.this.editFrame.getSQLComponent()).loadDevisExistant(row.getID());
                ListeDesDevisPanel.this.editFrame.setVisible(true);
            }
        });
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        this.add((Component)this.tabbedPane, c);
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ListeAddPanel selectedPanel = (ListeAddPanel)ListeDesDevisPanel.this.map.get(ListeDesDevisPanel.this.tabbedPane.getSelectedIndex());
                selectedPanel.getListe().getModel().fireTableDataChanged();
            }
        });
        this.checkButton(-1);
    }

    private ListeAddPanel createPanel(int idFilter) {
        SQLTableModelColumnPath dateEnvoiCol;
        SQLTableModelSourceOnline lAttente = this.eltDevis.getTableSource(true);
        if (idFilter == 4) {
            dateEnvoiCol = new SQLTableModelColumnPath(this.eltDevis.getTable().getField("DATE_ENVOI"));
            lAttente.getColumns().add(dateEnvoiCol);
            dateEnvoiCol.setRenderer(new DateEnvoiRenderer());
            dateEnvoiCol.setEditable(true);
        } else {
            dateEnvoiCol = null;
        }
        Where wAttente = new Where((FieldRef)this.eltDevis.getTable().getField("ID_ETAT_DEVIS"), "=", idFilter);
        lAttente.getReq().setWhere(wAttente);
        final ListeAddPanel pane = new ListeAddPanel(this.eltDevis, new IListe(lAttente), "idFilter" + idFilter);
        JTable table = pane.getListe().getJTable();
        if (idFilter == 4) {
            pane.getListe().setSQLEditable(true);
            TableColumn columnDateEnvoi = pane.getListe().getJTable().getColumnModel().getColumn(table.getColumnCount() - 1);
            columnDateEnvoi.setCellEditor(new TimestampTableCellEditor());
            SQLTableModelSourceOnline src = (SQLTableModelSourceOnline)pane.getListe().getModel().getReq();
            for (SQLTableModelColumn column : src.getColumns()) {
                if (column == dateEnvoiCol || !column.getClass().isAssignableFrom(SQLTableModelColumnPath.class)) continue;
                ((SQLTableModelColumnPath)column).setEditable(false);
            }
        }
        pane.getListe().getJTable().addMouseListener(new MouseSheetXmlListeListener(pane.getListe(), DevisXmlSheet.class){

            @Override
            public List<AbstractAction> addToMenu() {
                ArrayList<AbstractAction> list = new ArrayList<AbstractAction>();
                final SQLRow row = pane.getListe().getSelectedRow();
                AbstractAction factureAction = new AbstractAction("Transfert vers facture"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ListeDesDevisPanel.this.transfertFacture(row);
                    }
                };
                AbstractAction actionTransfertCmd = new AbstractAction("Transf\u00e9rer en commande"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ListeDesDevisPanel.this.transfertCommande(row);
                    }
                };
                AbstractAction commandeAction = new AbstractAction("Transfert vers commande client"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ListeDesDevisPanel.this.transfertCommandeClient(row);
                    }
                };
                AbstractAction accepteAction = new AbstractAction("Marquer comme accept\u00e9"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SQLRowValues rowVals = row.createEmptyUpdateRow();
                        rowVals.put("ID_ETAT_DEVIS", 4);
                        try {
                            rowVals.update();
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                        }
                        row.getTable().fireTableModified(row.getID());
                    }
                };
                int type = pane.getListe().getSelectedRow().getInt("ID_ETAT_DEVIS");
                factureAction.setEnabled(type == 4);
                commandeAction.setEnabled(type == 4);
                if (type == 2) {
                    list.add(accepteAction);
                }
                list.add(factureAction);
                list.add(commandeAction);
                list.add(actionTransfertCmd);
                return list;
            }
        });
        pane.getListe().addIListener(new IListener(){

            @Override
            public void selectionId(int id, int field) {
                ListeDesDevisPanel.this.checkButton(id);
            }
        });
        return pane;
    }

    private void checkButton(int id) {
        if (id > 1) {
            ListeAddPanel selectedPanel = this.map.get(this.tabbedPane.getSelectedIndex());
            SQLRow row = selectedPanel.getListe().getSelectedRow();
            DevisXmlSheet sheet = new DevisXmlSheet(row);
            int etat = row.getInt("ID_ETAT_DEVIS");
            this.buttonFacture.setEnabled(etat == 4);
            this.buttonCmd.setEnabled(etat == 4);
            this.buttonPrint.setEnabled(sheet.isFileOOExist());
            this.buttonShow.setEnabled(sheet.isFileOOExist());
            this.buttonGen.setEnabled(true);
            this.buttonClone.setEnabled(true);
        } else {
            this.buttonClone.setEnabled(false);
            this.buttonFacture.setEnabled(false);
            this.buttonCmd.setEnabled(false);
            this.buttonGen.setEnabled(false);
            this.buttonPrint.setEnabled(false);
            this.buttonShow.setEnabled(false);
        }
    }

    private void transfertFacture(SQLRow row) {
        DevisSQLElement elt = (DevisSQLElement)Configuration.getInstance().getDirectory().getElement("DEVIS");
        elt.transfertFacture(row.getID());
    }

    private void transfertCommandeClient(SQLRow row) {
        DevisSQLElement elt = (DevisSQLElement)Configuration.getInstance().getDirectory().getElement("DEVIS");
        elt.transfertCommandeClient(row.getID());
    }

    private void transfertCommande(SQLRow row) {
        DevisItemSQLElement elt = (DevisItemSQLElement)Configuration.getInstance().getDirectory().getElement("DEVIS_ELEMENT");
        SQLTable tableCmdElt = Configuration.getInstance().getDirectory().getElement("COMMANDE_ELEMENT").getTable();
        SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement("ARTICLE");
        Collection rows = row.getReferentRows(elt.getTable());
        CollectionMap<SQLRow, List<SQLRowValues>> map = new CollectionMap<SQLRow, List<SQLRowValues>>();
        for (SQLRow sqlRow : rows) {
            SQLRowValues rowArticle = new SQLRowValues(eltArticle.getTable());
            for (SQLField field : eltArticle.getTable().getFields()) {
                if (!sqlRow.getTable().getFieldsName().contains(field.getName())) continue;
                rowArticle.put(field.getName(), sqlRow.getObject(field.getName()));
            }
            int idArticle = ReferenceArticleSQLElement.getIdForCNM(rowArticle, true);
            SQLRow rowArticleFind = eltArticle.getTable().getRow(idArticle);
            SQLInjector inj = SQLInjector.getInjector(rowArticle.getTable(), tableCmdElt);
            SQLRowValues rowValsElt = new SQLRowValues(inj.createRowValuesFrom(rowArticleFind));
            rowValsElt.put("QTE", sqlRow.getObject("QTE"));
            rowValsElt.put("T_POIDS", rowValsElt.getLong("POIDS") * (long)rowValsElt.getInt("QTE"));
            rowValsElt.put("T_PA_HT", rowValsElt.getLong("PA_HT") * (long)rowValsElt.getInt("QTE"));
            rowValsElt.put("T_PA_TTC", (double)rowValsElt.getLong("T_PA_HT") * ((double)rowValsElt.getForeign("ID_TAXE").getFloat("TAUX") / 100.0 + 1.0));
            map.put((Object)rowArticleFind.getForeignRow("ID_FOURNISSEUR"), rowValsElt);
        }
        MouvementStockSQLElement.createCommandeF(map, row.getForeignRow("ID_TARIF").getForeignRow("ID_DEVISE"));
    }
}

