/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.quote.report;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import org.openconcerto.erp.generationDoc.AbstractSheetXml;
import org.openconcerto.erp.generationDoc.SheetXml;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.utils.Tuple2;

public class DevisXmlSheet
extends AbstractSheetXml {
    private static final Tuple2<String, String> tuple = Tuple2.create("LocationDevis", "Devis");

    public static Tuple2<String, String> getTuple2Location() {
        return tuple;
    }

    @Override
    public String getReference() {
        return this.row.getString("OBJET");
    }

    @Override
    public SQLRow getRowLanguage() {
        SQLRow rowClient = this.row.getForeignRow("ID_CLIENT");
        if (rowClient.getTable().contains("ID_LANGUE")) {
            return rowClient.getForeignRow("ID_LANGUE");
        }
        return super.getRowLanguage();
    }

    public DevisXmlSheet(SQLRow row) {
        super(row);
        this.printer = PrinterNXProps.getInstance().getStringProperty("DevisPrinter");
        this.elt = Configuration.getInstance().getDirectory().getElement("DEVIS");
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)row.getObject("DATE"));
        this.locationOO = String.valueOf(SheetXml.getLocationForTuple(tuple, false)) + File.separator + cal.get(1);
        this.locationPDF = String.valueOf(SheetXml.getLocationForTuple(tuple, true)) + File.separator + cal.get(1);
        this.modele = "Devis";
    }

    @Override
    public String getFileName() {
        return DevisXmlSheet.getValidFileName("Devis_" + this.row.getString("NUMERO"));
    }
}

