/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.quote.element;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.sales.invoice.component.SaisieVenteFactureSQLComponent;
import org.openconcerto.erp.core.sales.order.component.CommandeClientSQLComponent;
import org.openconcerto.erp.core.sales.quote.component.DevisSQLComponent;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.view.EditFrame;

public class DevisSQLElement
extends ComptaSQLConfElement {
    public DevisSQLElement() {
        super("DEVIS", "un devis", "devis");
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        return l;
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        l.add("DATE");
        l.add("ID_CLIENT");
        l.add("OBJET");
        l.add("T_HT");
        l.add("T_TTC");
        l.add("INFOS");
        return l;
    }

    @Override
    public synchronized ListSQLRequest createListRequest() {
        return new ListSQLRequest(this.getTable(), this.getListFields()){

            @Override
            protected void customizeToFetch(SQLRowValues graphToFetch) {
                super.customizeToFetch(graphToFetch);
                graphToFetch.put("ID_ETAT_DEVIS", null);
            }
        };
    }

    @Override
    protected Set<String> getChildren() {
        HashSet<String> set = new HashSet<String>();
        set.add("DEVIS_ELEMENT");
        return set;
    }

    @Override
    protected List<String> getPrivateFields() {
        ArrayList<String> s = new ArrayList<String>(1);
        s.add("ID_ADRESSE");
        return s;
    }

    @Override
    public SQLComponent createComponent() {
        return new DevisSQLComponent(this);
    }

    public void transfertFacture(int devisID) {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
        EditFrame editFactureFrame = new EditFrame(elt);
        editFactureFrame.setIconImage(new ImageIcon(Gestion.class.getResource("frameicon.png")).getImage());
        SaisieVenteFactureSQLComponent comp = (SaisieVenteFactureSQLComponent)editFactureFrame.getSQLComponent();
        comp.setDefaults();
        comp.loadDevis(devisID);
        editFactureFrame.pack();
        editFactureFrame.setState(0);
        editFactureFrame.setVisible(true);
    }

    public void transfertCommandeClient(int devisID) {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT");
        EditFrame editFactureFrame = new EditFrame(elt);
        editFactureFrame.setIconImage(new ImageIcon(Gestion.class.getResource("frameicon.png")).getImage());
        CommandeClientSQLComponent comp = (CommandeClientSQLComponent)editFactureFrame.getSQLComponent();
        comp.setDefaults();
        comp.loadDevis(devisID);
        editFactureFrame.pack();
        editFactureFrame.setState(0);
        editFactureFrame.setVisible(true);
    }
}

