/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jdesktop.swingx.VerticalLayout;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.preferences.DefaultPreferencePanel;
import org.openconcerto.ui.preferences.DefaultProps;

public class GestionArticlePreferencePanel
extends DefaultPreferencePanel {
    private final JCheckBox checkModeVente;
    private final JCheckBox checkLongueur;
    private final JCheckBox checkLargeur;
    private final JCheckBox checkPoids;
    private final JCheckBox checkGestionStockMin;
    private final JCheckBox checkService;
    private final JCheckBox checkVenteComptoir;
    private final JCheckBox checkShowPoids;
    private final JCheckBox checkShowStyle;
    private final JCheckBox checkSFE;

    public GestionArticlePreferencePanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.anchor = 18;
        c.weightx = 1.0;
        this.checkSFE = new JCheckBox("Activer la vente de formation");
        this.checkService = new JCheckBox("Activer la gestion de vente de service");
        this.checkGestionStockMin = new JCheckBox("Activer la gestion de stock minimum par article");
        this.checkLargeur = new JCheckBox("Largeurs");
        this.checkLongueur = new JCheckBox("Longueurs");
        this.checkPoids = new JCheckBox("Poids");
        this.checkShowStyle = new JCheckBox("Voir la colonne Style");
        this.checkModeVente = new JCheckBox("Activer le mode de vente sp\u00e9cifique");
        this.checkVenteComptoir = new JCheckBox("Activer le mode vente comptoir");
        this.checkShowPoids = new JCheckBox("Voir le Poids");
        this.add((Component)this.checkGestionStockMin, c);
        ++c.gridy;
        this.add((Component)this.checkService, c);
        ++c.gridy;
        this.add((Component)this.checkVenteComptoir, c);
        ++c.gridy;
        this.add((Component)this.checkShowPoids, c);
        ++c.gridy;
        this.add((Component)this.checkShowStyle, c);
        ++c.gridy;
        this.add((Component)this.checkModeVente, c);
        JPanel panelGestionArticle = new JPanel();
        panelGestionArticle.setBorder(BorderFactory.createTitledBorder("G\u00e9rer les"));
        panelGestionArticle.setLayout(new VerticalLayout());
        panelGestionArticle.add(this.checkLargeur);
        panelGestionArticle.add(this.checkLongueur);
        panelGestionArticle.add(this.checkPoids);
        ++c.gridy;
        c.weighty = 1.0;
        this.add((Component)panelGestionArticle, c);
        this.setValues();
        this.checkModeVente.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GestionArticlePreferencePanel.this.enableAdvancedMode(GestionArticlePreferencePanel.this.checkModeVente.isSelected());
            }
        });
    }

    @Override
    public void storeValues() {
        DefaultProps props = DefaultNXProps.getInstance();
        props.setProperty("ArticleLongueur", String.valueOf(this.checkLongueur.isSelected()));
        props.setProperty("ArticleLargeur", String.valueOf(this.checkLargeur.isSelected()));
        props.setProperty("ArticlePoids", String.valueOf(this.checkPoids.isSelected()));
        props.setProperty("ArticleShowPoids", String.valueOf(this.checkShowPoids.isSelected()));
        props.setProperty("ArticleShowStyle", String.valueOf(this.checkShowStyle.isSelected()));
        props.setProperty("ArticleModeVenteAvance", String.valueOf(this.checkModeVente.isSelected()));
        props.setProperty("ArticleService", String.valueOf(this.checkService.isSelected()));
        props.setProperty("ArticleSFE", String.valueOf(this.checkSFE.isSelected()));
        props.setProperty("ArticleVenteComptoir", String.valueOf(this.checkVenteComptoir.isSelected()));
        props.setProperty("ArticleStockMin", String.valueOf(this.checkGestionStockMin.isSelected()));
        props.store();
    }

    @Override
    public void restoreToDefaults() {
        this.checkModeVente.setSelected(false);
        this.checkShowPoids.setSelected(true);
        this.checkShowStyle.setSelected(true);
        this.enableAdvancedMode(false);
        this.checkService.setSelected(true);
        this.checkSFE.setSelected(false);
        this.checkVenteComptoir.setSelected(false);
        this.checkGestionStockMin.setSelected(true);
    }

    @Override
    public String getTitleName() {
        return "Gestion des articles";
    }

    private void setValues() {
        DefaultProps props = DefaultNXProps.getInstance();
        String service = props.getStringProperty("ArticleService");
        Boolean bService = Boolean.valueOf(service);
        this.checkService.setSelected(bService == null || bService != false);
        String sfe = props.getStringProperty("ArticleSFE");
        Boolean bSfe = Boolean.valueOf(sfe);
        this.checkSFE.setSelected(bSfe != null && bSfe != false);
        String venteComptoir = props.getStringProperty("ArticleVenteComptoir");
        Boolean bVenteComptoir = Boolean.valueOf(venteComptoir);
        this.checkVenteComptoir.setSelected(bVenteComptoir != null && bVenteComptoir != false);
        String longueur = props.getStringProperty("ArticleLongueur");
        Boolean bLong = Boolean.valueOf(longueur);
        this.checkLongueur.setSelected(bLong == null || bLong != false);
        String largeur = props.getStringProperty("ArticleLargeur");
        Boolean bLarg = Boolean.valueOf(largeur);
        this.checkLargeur.setSelected(bLarg == null || bLarg != false);
        String poids = props.getStringProperty("ArticlePoids");
        Boolean bPoids = Boolean.valueOf(poids);
        this.checkPoids.setSelected(bPoids == null || bPoids != false);
        String showPoids = props.getStringProperty("ArticleShowPoids");
        Boolean bShowPoids = Boolean.valueOf(showPoids);
        this.checkShowPoids.setSelected(bShowPoids == null || bShowPoids != false);
        String showStyle = props.getStringProperty("ArticleShowStyle");
        Boolean bShowStyle = !showStyle.equalsIgnoreCase("false");
        this.checkShowStyle.setSelected(bShowStyle == null || bShowStyle != false);
        String gestionStockMin = props.getStringProperty("ArticleStockMin");
        Boolean bStockMin = !gestionStockMin.equalsIgnoreCase("false");
        this.checkGestionStockMin.setSelected(bStockMin == null || bStockMin != false);
        String modeVente = props.getStringProperty("ArticleModeVenteAvance");
        Boolean bModeVente = Boolean.valueOf(modeVente);
        this.checkModeVente.setSelected(bModeVente == null || bModeVente != false);
        this.enableAdvancedMode(bModeVente == null || bModeVente != false);
    }

    private void enableAdvancedMode(boolean b) {
        this.checkLargeur.setEnabled(b);
        this.checkLongueur.setEnabled(b);
        this.checkPoids.setEnabled(b);
    }
}

