/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.model.PrixHT;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.GestionDevise;

public class ArticleSQLElement
extends ComptaSQLConfElement {
    public ArticleSQLElement() {
        super("ARTICLE", "un article", "articles");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        l.add("NOM");
        l.add("POIDS");
        l.add("PA_HT");
        l.add("PV_HT");
        l.add("ID_TAXE");
        l.add("PV_TTC");
        l.add("VALEUR_METRIQUE_1");
        l.add("VALEUR_METRIQUE_2");
        l.add("VALEUR_METRIQUE_3");
        l.add("PRIX_METRIQUE_HA_1");
        l.add("PRIX_METRIQUE_VT_1");
        l.add("ID_STOCK");
        String val = DefaultNXProps.getInstance().getStringProperty("ArticleService");
        Boolean b = Boolean.valueOf(val);
        if (b != null && b.booleanValue()) {
            l.add("SERVICE");
        }
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        l.add("NOM");
        return l;
    }

    @Override
    protected List<String> getPrivateFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_STOCK");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            private DeviseField textPVHT;
            private DeviseField textPVTTC;
            private DeviseField textPAHT;
            private JTextField textNom;
            private JTextField textCode;
            private JTextField textPoids;
            private DocumentListener htDocListener;
            private DocumentListener ttcDocListener;
            private PropertyChangeListener taxeListener;
            final ElementComboBox comboSelTaxe;
            {
                this.comboSelTaxe = new ElementComboBox(false);
            }

            @Override
            public void addViews() {
                this.textPVHT = new DeviseField();
                this.textPVTTC = new DeviseField();
                this.textPAHT = new DeviseField();
                this.textCode = new JTextField();
                this.textNom = new JTextField();
                this.textPoids = new JTextField();
                this.ttcDocListener = new DocumentListener(){

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        this.setTextHT();
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.setTextHT();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.setTextHT();
                    }
                };
                this.htDocListener = new DocumentListener(){

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        this.setTextTTC();
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.setTextTTC();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.setTextTTC();
                    }
                };
                this.taxeListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (textPVHT.getText().trim().length() > 0) {
                            this.setTextTTC();
                        } else {
                            this.setTextHT();
                        }
                    }
                };
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                this.add((Component)new JLabel(this.getLabelFor("CODE")), c);
                ++c.gridx;
                this.add((Component)this.textCode, c);
                ++c.gridx;
                this.add((Component)new JLabel(this.getLabelFor("NOM")), c);
                ++c.gridx;
                this.add((Component)this.textNom, c);
                ++c.gridx;
                c.gridwidth = 0;
                c.gridheight = 2;
                JPanel panelStock = new JPanel();
                this.addView("ID_STOCK", "required;notdecorated;noseparator");
                ElementSQLObject eltStock = (ElementSQLObject)this.getView("ID_STOCK");
                panelStock.add(eltStock.getComp());
                panelStock.setBorder(BorderFactory.createTitledBorder(this.getLabelFor("ID_STOCK")));
                this.add((Component)panelStock, c);
                c.gridx = 0;
                ++c.gridy;
                c.gridwidth = 1;
                c.gridheight = 1;
                this.add((Component)new JLabel(this.getLabelFor("PA_HT")), c);
                ++c.gridx;
                this.add((Component)this.textPAHT, c);
                ++c.gridx;
                JLabel labelPds = new JLabel(this.getLabelFor("POIDS"));
                this.add((Component)labelPds, c);
                ++c.gridx;
                labelPds.setHorizontalAlignment(4);
                this.add((Component)this.textPoids, c);
                c.gridx = 0;
                ++c.gridy;
                this.add((Component)new JLabel(this.getLabelFor("PV_HT")), c);
                ++c.gridx;
                this.add((Component)this.textPVHT, c);
                ++c.gridx;
                JLabel labelTaxe = new JLabel(this.getLabelFor("ID_TAXE"));
                this.add((Component)labelTaxe, c);
                ++c.gridx;
                labelTaxe.setHorizontalAlignment(4);
                this.add((Component)this.comboSelTaxe, c);
                ++c.gridx;
                this.add((Component)new JLabel(this.getLabelFor("PV_TTC")), c);
                ++c.gridx;
                this.add((Component)this.textPVTTC, c);
                ++c.gridy;
                c.weighty = 1.0;
                JPanel spacer = new JPanel();
                c.fill = 1;
                this.add((Component)spacer, c);
                this.addRequiredSQLObject(this.textNom, "NOM");
                this.addRequiredSQLObject(this.textCode, "CODE");
                this.addRequiredSQLObject(this.textPAHT, "PA_HT");
                this.addSQLObject(this.textPoids, "POIDS");
                this.addRequiredSQLObject(this.textPVHT, "PV_HT");
                this.addRequiredSQLObject(this.comboSelTaxe, "ID_TAXE");
                this.addRequiredSQLObject(this.textPVTTC, "PV_TTC");
                this.textPVHT.getDocument().addDocumentListener(this.htDocListener);
                this.textPVTTC.getDocument().addDocumentListener(this.ttcDocListener);
                this.comboSelTaxe.addValueListener(this.taxeListener);
            }

            private void setTextHT() {
                this.textPVHT.getDocument().removeDocumentListener(this.htDocListener);
                String textTTC = this.textPVTTC.getText().trim();
                PrixTTC ttc = new PrixTTC(GestionDevise.parseLongCurrency(textTTC));
                int id = this.comboSelTaxe.getSelectedId();
                if (id > 1) {
                    SQLRow ligneTaxe = this.getTable().getBase().getTable("TAXE").getRow(id);
                    float taux = ligneTaxe.getFloat("TAUX") / 100.0f;
                    this.textPVHT.setText(GestionDevise.currencyToString(ttc.calculLongHT(taux)));
                }
                this.textPVHT.getDocument().addDocumentListener(this.htDocListener);
            }

            private void setTextTTC() {
                this.textPVTTC.getDocument().removeDocumentListener(this.ttcDocListener);
                String textHT = this.textPVHT.getText().trim();
                PrixHT ht = new PrixHT(GestionDevise.parseLongCurrency(textHT));
                int id = this.comboSelTaxe.getSelectedId();
                if (id > 1) {
                    SQLRow ligneTaxe = this.getTable().getBase().getTable("TAXE").getRow(id);
                    float taux = ligneTaxe.getFloat("TAUX") / 100.0f;
                    this.textPVTTC.setText(GestionDevise.currencyToString(ht.calculLongTTC(taux)));
                }
                this.textPVTTC.getDocument().addDocumentListener(this.ttcDocListener);
            }

            @Override
            protected SQLRowValues createDefaults() {
                SQLRowValues rowVals = new SQLRowValues(this.getTable());
                rowVals.put("ID_MODE_VENTE_ARTICLE", 5);
                return rowVals;
            }
        };
    }
}

