/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.action;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.sales.product.ui.FamilleArticlePanel;
import org.openconcerto.erp.panel.ITreeSelection;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.PanelFrame;

public class ListeDesArticlesAction
extends CreateFrameAbstractAction {
    private PanelFrame panelFrame;
    String title = "Liste des articles";
    private final SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
    private final SQLTable sqlTableFamilleArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("FAMILLE_ARTICLE");

    public ListeDesArticlesAction() {
        this.putValue("Name", "Liste des articles");
    }

    @Override
    public JFrame createFrame() {
        final FamilleArticlePanel panelFam = new FamilleArticlePanel();
        SQLElement elt = Configuration.getInstance().getDirectory().getElement(this.sqlTableArticle);
        IListe liste = new IListe(elt.createTableSource(this.getWhere(panelFam)));
        final ListeAddPanel panel = new ListeAddPanel(elt, liste);
        JSplitPane pane = new JSplitPane(1, panelFam, panel);
        JPanel panelAll = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        panelAll.add((Component)pane, c);
        ITreeSelection tree = panelFam.getFamilleTree();
        tree.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                panel.getListe().getRequest().setWhere(ListeDesArticlesAction.this.getWhere(panelFam));
            }
        });
        panel.getListe().addListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ListeDesArticlesAction.this.setTitle(panel);
            }
        });
        panel.getListe().addListenerOnModel(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == null || evt.getPropertyName().equals("loading") || evt.getPropertyName().equals("searching")) {
                    ListeDesArticlesAction.this.setTitle(panel);
                }
            }
        });
        panelFam.getCheckObsolete().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.getListe().getRequest().setWhere(ListeDesArticlesAction.this.getWhere(panelFam));
            }
        });
        this.panelFrame = new PanelFrame(panelAll, "Liste des articles");
        return this.panelFrame;
    }

    protected void setTitle(ListeAddPanel panel) {
        String title = this.title;
        if (panel.getListe().getModel().isLoading()) {
            title = String.valueOf(title) + ", chargement en cours";
        }
        if (panel.getListe().getModel().isSearching()) {
            title = String.valueOf(title) + ", recherche en cours";
        }
        this.panelFrame.setTitle(title);
    }

    public Where getWhere(FamilleArticlePanel panel) {
        int id = panel.getFamilleTree().getSelectedID();
        Where w = null;
        if (panel.getCheckObsolete().isSelected()) {
            w = new Where((FieldRef)this.sqlTableArticle.getField("OBSOLETE"), "=", (Object)Boolean.FALSE);
        }
        if (id > 1) {
            SQLRow row = this.sqlTableFamilleArticle.getRow(id);
            String code = String.valueOf(row.getString("CODE")) + "%";
            Where w2 = new Where((FieldRef)this.sqlTableArticle.getField("ID_FAMILLE_ARTICLE"), "=", this.sqlTableFamilleArticle.getKey());
            w = w != null ? w.and(w2) : w2;
            w = w.and(new Where((FieldRef)this.sqlTableFamilleArticle.getField("CODE"), "LIKE", (Object)code));
        }
        return w;
    }
}

