/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;

public class TouchScrollPane
extends JScrollPane
implements MouseListener,
MouseMotionListener {
    private JComponent child;
    int dy = 0;
    int olddy = 0;
    private int mousePressedY;
    private double viewY;
    private int lastLocationOnscreen;

    public TouchScrollPane(JComponent l) {
        super(l);
        this.setVerticalScrollBarPolicy(21);
        this.setHorizontalScrollBarPolicy(31);
        if (!(l instanceof Scrollable)) {
            throw new IllegalArgumentException("Argument is not implementing Scrollable");
        }
        this.child = l;
        this.child.addMouseListener(this);
        this.child.addMouseMotionListener(this);
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(Color.RED);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paint(g);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < 100) {
            v.add("Item " + i);
            ++i;
        }
        JList l = new JList(v);
        l.putClientProperty("List.isFileList", Boolean.TRUE);
        l.setFixedCellHeight(50);
        TouchScrollPane t = new TouchScrollPane(l);
        f.setContentPane(t);
        f.setSize(200, 400);
        f.setDefaultCloseOperation(3);
        f.show();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        System.out.println("TouchScrollPane.mouseClicked()");
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        System.out.println("TouchScrollPane.mouseEntered()");
    }

    @Override
    public void mouseExited(MouseEvent e) {
        System.out.println("TouchScrollPane.mouseExited()");
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mousePressedY = e.getLocationOnScreen().y;
        System.out.println("TouchScrollPane.mousePressed():" + e.getY());
        this.viewY = this.getViewport().getViewPosition().getY();
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        System.out.println("TouchScrollPane.mouseReleased()");
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        e.consume();
        if (e.getLocationOnScreen().y == this.lastLocationOnscreen) {
            return;
        }
        this.lastLocationOnscreen = e.getLocationOnScreen().y;
        System.out.println("TouchScrollPane.mouseDragged()");
        boolean xDiff = false;
        int yDiff = this.mousePressedY;
        System.out.println("DY:" + yDiff);
        JViewport jv = this.getViewport();
        Point p = jv.getViewPosition();
        int newX = 0;
        int deplacementY = e.getLocationOnScreen().y - yDiff;
        int newY = (int)this.viewY - deplacementY;
        System.out.println("View Position:" + p.y);
        System.out.println("Decallage depuis mouse pressed:" + deplacementY + "(" + e.getLocationOnScreen().y + " - " + yDiff + ")");
        int maxX = this.child.getWidth() - jv.getWidth();
        int maxY = this.child.getHeight() - jv.getHeight();
        if (newY < 0) {
            newY = 0;
        }
        jv.setViewPosition(new Point(newX, newY));
        System.out.println(newY);
        e.consume();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        System.out.println("TouchScrollPane.mouseMoved()");
    }
}

