/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ServerFinderConfig;
import org.openconcerto.erp.config.ServerFinderPanel;
import org.openconcerto.erp.core.sales.pos.Caisse;
import org.openconcerto.erp.core.sales.pos.ui.TicketLineTable;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;

public class ConfigCaissePanel
extends JPanel {
    private final JComboBox comboType;
    private final JTextField textPrintWidth;
    private final JTextField textPort;
    private final JTextField textLibJPOS;
    private final JCheckBox checkboxDouble;
    private int userId;
    private int societeId;
    private int caisseId;
    private final ServerFinderPanel serverFinderPanel;
    private final JComboBox comboSociete;
    private final JComboBox comboCaisse;
    private final JComboBox comboUtilisateur;
    private final TicketLineTable headerTable;
    private final TicketLineTable footerTable;

    public ConfigCaissePanel(ServerFinderPanel serverFinderPanel) {
        this.serverFinderPanel = serverFinderPanel;
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weighty = 0.0;
        JLabelBold titleConnexion = new JLabelBold("Connexion");
        c.gridwidth = 2;
        this.add((Component)titleConnexion, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Soci\u00e9t\u00e9", 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.comboSociete = new JComboBox();
        this.comboSociete.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                SQLRow r = (SQLRow)value;
                String label = "";
                if (r != null) {
                    label = String.valueOf(r.getString("NOM")) + " (" + r.getString("ID") + ")";
                }
                return super.getListCellRendererComponent((JList<?>)list, label, index, isSelected, cellHasFocus);
            }
        });
        this.add((Component)this.comboSociete, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Caisse", 4), c);
        ++c.gridx;
        this.comboCaisse = new JComboBox();
        this.comboCaisse.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                SQLRow r = (SQLRow)value;
                String label = "";
                if (r != null) {
                    label = String.valueOf(r.getString("NOM")) + " (" + r.getString("ID") + ")";
                }
                return super.getListCellRendererComponent((JList<?>)list, label, index, isSelected, cellHasFocus);
            }
        });
        this.add((Component)this.comboCaisse, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Utilisateur", 4), c);
        ++c.gridx;
        this.comboUtilisateur = new JComboBox();
        this.comboUtilisateur.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                SQLRow r = (SQLRow)value;
                String label = "";
                if (r != null) {
                    label = String.valueOf(r.getString("NOM")) + " " + r.getString("PRENOM") + " (" + r.getString("ID") + ")";
                }
                return super.getListCellRendererComponent((JList<?>)list, label, index, isSelected, cellHasFocus);
            }
        });
        this.add((Component)this.comboUtilisateur, c);
        JLabelBold titleTicket = new JLabelBold("Ticket");
        c.gridwidth = 2;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)titleTicket, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 2;
        c.anchor = 18;
        this.add((Component)new JLabel("Ent\u00eate", 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 1;
        this.headerTable = new TicketLineTable();
        this.add((Component)this.headerTable, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel("Pied de page", 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 1;
        this.footerTable = new TicketLineTable();
        this.add((Component)this.footerTable, c);
        c.fill = 2;
        this.checkboxDouble = new JCheckBox("imprimer le ticket en double exemplaire");
        this.checkboxDouble.setOpaque(false);
        c.gridx = 1;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.add((Component)this.checkboxDouble, c);
        JLabelBold titleImprimante = new JLabelBold("Imprimante ticket");
        c.anchor = 17;
        c.gridwidth = 2;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)titleImprimante, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        this.add((Component)new JLabel("Largeur (en caract\u00e8res)", 4), c);
        ++c.gridx;
        this.textPrintWidth = new JTextField(8);
        this.add((Component)this.textPrintWidth, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel("Type", 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        this.comboType = new JComboBox<String>(new String[]{"jpos", "escp"});
        this.add((Component)this.comboType, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel("Port/nom", 4), c);
        ++c.gridx;
        this.textPort = new JTextField();
        this.add((Component)this.textPort, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Dossier lib JPOS", 4), c);
        ++c.gridx;
        this.textLibJPOS = new JTextField();
        this.add((Component)this.textLibJPOS, c);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 1;
        JPanel spacer = new JPanel();
        spacer.setOpaque(false);
        spacer.setPreferredSize(new Dimension(10, 10));
        this.add((Component)spacer, c);
        this.comboSociete.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ConfigCaissePanel.this.societeId = ((SQLRow)e.getItem()).getID();
                    ConfigCaissePanel.this.reloadCaisses();
                }
            }
        });
        this.comboCaisse.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ConfigCaissePanel.this.caisseId = ((SQLRow)e.getItem()).getID();
                }
            }
        });
        this.comboUtilisateur.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ConfigCaissePanel.this.userId = ((SQLRow)e.getItem()).getID();
                }
            }
        });
    }

    protected void reloadCaisses() {
        this.comboCaisse.setEnabled(false);
        int id = this.societeId;
        ServerFinderConfig config = this.serverFinderPanel.createServerFinderConfig();
        if (!config.isOnline()) {
            JOptionPane.showMessageDialog(this, "Impossible de se connecter au serveur");
            return;
        }
        try {
            System.out.println("Reloading POS information from: " + config);
            SQLServer server = config.createServer("Common");
            DBSystemRoot r = server.getSystemRoot("OpenConcerto");
            DBRoot root = r.getRoot("Common");
            SQLSelect sel = new SQLSelect(root.getBase());
            sel.addSelectStar(root.getTable("SOCIETE_COMMON"));
            sel.setWhere("SOCIETE_COMMON.ID", "=", id);
            List<SQLRow> societes = SQLRowListRSH.execute(sel);
            server.destroy();
            if (societes.size() > 0) {
                final String name = societes.get(0).getString("DATABASE_NAME");
                server = config.createServer(name);
                r = server.getSystemRoot("OpenConcerto");
                root = r.getRoot(name);
                sel = new SQLSelect(root.getBase());
                sel.addSelectStar(root.getTable("CAISSE"));
                final List<SQLRow> caisses = SQLRowListRSH.execute(sel);
                server.destroy();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (caisses.isEmpty()) {
                            JOptionPane.showMessageDialog(ConfigCaissePanel.this, "Pas de caisses d\u00e9finies dans la soci\u00e9t\u00e9 " + name);
                        }
                        ConfigCaissePanel.this.comboCaisse.setModel(new DefaultComboBoxModel(new Vector(caisses)));
                        ConfigCaissePanel.this.comboUtilisateur.setEnabled(true);
                        ConfigCaissePanel.this.comboCaisse.setEnabled(true);
                        ComboBoxModel model = ConfigCaissePanel.this.comboCaisse.getModel();
                        int stop = model.getSize();
                        if (stop > 0) {
                            ConfigCaissePanel.this.caisseId = ((SQLRow)model.getElementAt(0)).getID();
                        }
                        int i = 0;
                        while (i < stop) {
                            SQLRow r = (SQLRow)model.getElementAt(i);
                            if (r.getID() == ConfigCaissePanel.this.caisseId) {
                                ConfigCaissePanel.this.comboCaisse.setSelectedItem(r);
                                break;
                            }
                            ++i;
                        }
                    }
                });
            } else {
                JOptionPane.showMessageDialog(this, "Impossible de trouver la soci\u00e9t\u00e9 d'ID " + id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadConfiguration() {
        if (Caisse.isUsingJPos()) {
            this.comboType.setSelectedIndex(0);
            this.textPort.setText(Caisse.getJPosPrinter());
        } else {
            this.comboType.setSelectedIndex(1);
            this.textPort.setText(Caisse.getESCPPort());
        }
        this.textPrintWidth.setText(String.valueOf(Caisse.getTicketWidth()));
        this.textLibJPOS.setText(Caisse.getJPosDirectory());
        this.checkboxDouble.setSelected(Caisse.isCopyActive());
        this.userId = Caisse.getUserID();
        this.societeId = Caisse.getSocieteID();
        this.caisseId = Caisse.getID();
        this.headerTable.fillFrom(Caisse.getHeaders());
        this.footerTable.fillFrom(Caisse.getFooters());
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent event) {
            }

            @Override
            public void componentMoved(ComponentEvent event) {
            }

            @Override
            public void componentResized(ComponentEvent event) {
            }

            @Override
            public void componentShown(ComponentEvent event) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ConfigCaissePanel.this.comboSociete.setEnabled(false);
                        ConfigCaissePanel.this.comboUtilisateur.setEnabled(false);
                        ConfigCaissePanel.this.comboCaisse.setEnabled(false);
                        ServerFinderConfig config = ConfigCaissePanel.this.serverFinderPanel.createServerFinderConfig();
                        if (!config.isOnline()) {
                            JOptionPane.showMessageDialog(ConfigCaissePanel.this, "Impossible de se connecter au serveur");
                            return;
                        }
                        String result = "Erreur de connexion. \n";
                        try {
                            SQLServer server = config.createServer("Common");
                            DBSystemRoot r = server.getSystemRoot("OpenConcerto");
                            DBRoot root = r.getRoot("Common");
                            SQLSelect sel = new SQLSelect(root.getBase());
                            sel.addSelectStar(root.getTable("SOCIETE_COMMON"));
                            final List<SQLRow> societes = SQLRowListRSH.execute(sel);
                            sel = new SQLSelect(root.getBase());
                            sel.addSelectStar(root.getTable("USER_COMMON"));
                            final List<SQLRow> utilisateurs = SQLRowListRSH.execute(sel);
                            server.destroy();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    SQLRow r;
                                    ConfigCaissePanel.this.comboSociete.setModel(new DefaultComboBoxModel(new Vector(societes)));
                                    ConfigCaissePanel.this.comboUtilisateur.setModel(new DefaultComboBoxModel(new Vector(utilisateurs)));
                                    ConfigCaissePanel.this.comboSociete.setEnabled(true);
                                    ConfigCaissePanel.this.comboUtilisateur.setEnabled(true);
                                    ComboBoxModel model = ConfigCaissePanel.this.comboSociete.getModel();
                                    int stop = model.getSize();
                                    int i = 0;
                                    while (i < stop) {
                                        r = (SQLRow)model.getElementAt(i);
                                        if (r.getID() == ConfigCaissePanel.this.societeId) {
                                            ConfigCaissePanel.this.comboSociete.setSelectedItem(r);
                                            break;
                                        }
                                        ++i;
                                    }
                                    model = ConfigCaissePanel.this.comboUtilisateur.getModel();
                                    stop = model.getSize();
                                    i = 0;
                                    while (i < stop) {
                                        r = (SQLRow)model.getElementAt(i);
                                        if (r.getID() == ConfigCaissePanel.this.userId) {
                                            ConfigCaissePanel.this.comboUtilisateur.setSelectedItem(r);
                                            break;
                                        }
                                        ++i;
                                    }
                                }
                            });
                        }
                        catch (Exception e) {
                            result = String.valueOf(result) + e.getMessage();
                            e.printStackTrace();
                        }
                    }
                });
                t.setDaemon(true);
                t.start();
            }
        });
    }

    public void saveConfiguration() {
        Caisse.setPrinterType(this.comboType.getSelectedItem().toString());
        if (this.comboType.getSelectedIndex() == 0) {
            Caisse.setJPosPrinter(this.textPort.getText());
        } else {
            Caisse.setESCPPort(this.textPort.getText());
        }
        Caisse.setTicketWidth(this.textPrintWidth.getText());
        Caisse.setJPosDirectory(this.textLibJPOS.getText());
        Caisse.setCopyActive(this.checkboxDouble.isSelected());
        Caisse.setUserID(this.userId);
        Caisse.setSocieteID(this.societeId);
        Caisse.setID(this.caisseId);
        Caisse.setHeaders(this.headerTable.getLines());
        Caisse.setFooters(this.footerTable.getLines());
        Caisse.saveConfiguration();
    }
}

