/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.Categorie;
import org.openconcerto.erp.core.sales.pos.ui.ArticleSelectorPanel;
import org.openconcerto.erp.core.sales.pos.ui.CaisseControler;
import org.openconcerto.erp.core.sales.pos.ui.CaisseFrame;
import org.openconcerto.erp.core.sales.pos.ui.CaisseListener;
import org.openconcerto.erp.core.sales.pos.ui.PaiementPanel;
import org.openconcerto.erp.core.sales.pos.ui.StatusBar;
import org.openconcerto.erp.core.sales.pos.ui.TicketPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.utils.ExceptionHandler;

public class CaissePanel
extends JPanel
implements CaisseListener {
    private CaisseControler controler;
    private CaisseFrame caisseFrame;
    private StatusBar st;

    public CaissePanel(final CaisseFrame caisseFrame) {
        this.caisseFrame = caisseFrame;
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.WHITE);
        this.setOpaque(this.isOpaque());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.controler = new CaisseControler(caisseFrame);
        c.fill = 2;
        this.st = new StatusBar("toolbar.png", "toolbar_menu.png");
        this.st.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getX() < 110) {
                    try {
                        CaissePanel.this.controler.printTicket();
                        CaissePanel.this.controler.printTicket();
                    }
                    catch (Throwable ex) {
                        ExceptionHandler.handle("Erreur d'impression du ticket", ex);
                    }
                    try {
                        CaissePanel.this.controler.saveAndClearTicket();
                    }
                    catch (Throwable ex) {
                        ExceptionHandler.handle("Erreur de sauvegardes des informations du ticket", ex);
                    }
                } else if (e.getX() > 165 && e.getX() < 275) {
                    try {
                        caisseFrame.showMenu();
                    }
                    catch (Throwable ex) {
                        ExceptionHandler.handle("Erreur d'affichage du menu", ex);
                    }
                }
            }
        });
        this.st.setPrevious(true);
        this.add((Component)this.st, c);
        TicketPanel t = new TicketPanel(this.controler);
        this.loadArticles();
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.anchor = 16;
        c.fill = 0;
        this.add((Component)t, c);
        c.fill = 1;
        ++c.gridx;
        c.weightx = 1.0;
        --c.gridy;
        c.gridheight = 2;
        this.add((Component)new ArticleSelectorPanel(this.controler), c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)new PaiementPanel(this.controler), c);
        this.controler.addCaisseListener(this);
    }

    private void loadArticles() {
        HashMap<Integer, Categorie> m = new HashMap<Integer, Categorie>();
        SQLElement eltFam = Configuration.getInstance().getDirectory().getElement("FAMILLE_ARTICLE");
        SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement("ARTICLE");
        SQLSelect selFamille = new SQLSelect(Configuration.getInstance().getBase());
        selFamille.addSelectStar(eltFam.getTable());
        selFamille.addRawOrder(eltFam.getTable().getField("CODE").getFieldRef());
        List l = (List)Configuration.getInstance().getBase().getDataSource().execute(selFamille.asString(), SQLRowListRSH.createFromSelect(selFamille, eltFam.getTable()));
        for (SQLRow row : l) {
            Categorie c;
            Categorie cP = (Categorie)m.get(row.getInt("ID_FAMILLE_ARTICLE_PERE"));
            if (cP != null) {
                c = new Categorie(row.getString("NOM"));
                cP.add(c);
            } else {
                c = new Categorie(row.getString("NOM"), true);
            }
            m.put(row.getID(), c);
        }
        SQLSelect selArticle = new SQLSelect(Configuration.getInstance().getBase());
        selArticle.addSelectStar(eltArticle.getTable());
        List l2 = (List)Configuration.getInstance().getBase().getDataSource().execute(selArticle.asString(), SQLRowListRSH.createFromSelect(selArticle, eltArticle.getTable()));
        for (SQLRow row : l2) {
            Categorie s1 = (Categorie)m.get(row.getInt("ID_FAMILLE_ARTICLE"));
            if (s1 == null) continue;
            Article a = new Article(s1, row.getString("NOM"));
            a.setBarCode(row.getString("CODE_BARRE"));
            a.setIdTaxe(row.getInt("ID_TAXE"));
            a.setPriceHTInCents((int)row.getLong("PV_HT"));
            a.setPriceInCents((int)row.getLong("PV_TTC"));
        }
    }

    private void fillExampleArticle() {
        Categorie c1 = new Categorie("Carte postales", true);
        Categorie s1 = new Categorie("Baie de Somme");
        c1.add(s1);
        Categorie s2 = new Categorie("Villes");
        c1.add(s2);
        Categorie c2 = new Categorie("Livres", true);
        Categorie s2_1 = new Categorie("Livre Baie");
        c2.add(s2_1);
        Categorie s2_2 = new Categorie("Livre Abbeville");
        c2.add(s2_2);
        int i = 0;
        while (i < 100) {
            Article al = new Article(s2_2, "ILM" + i);
            al.setPriceInCents(5000);
            al.setBarCode("INFORMATIQUE " + i);
            ++i;
        }
        Article a = new Article(s1, "012345678901234567890123456789");
        a.setPriceInCents(106);
        Article b = new Article(s1, "St Valery");
        b.setBarCode("ST VALERY");
        b.setPriceInCents(300);
        Article cc = new Article(s1, "Cayeux");
        cc.setPriceInCents(300);
        Article v1 = new Article(s2, "Abbeville");
        v1.setPriceInCents(106);
        Article v2 = new Article(s2, "Amiens");
        v2.setPriceInCents(300);
        Article v3 = new Article(s2, "Rue");
        v3.setPriceInCents(300);
        this.controler.addArticle(a);
        this.controler.addArticle(a);
        this.controler.addArticle(b);
        this.controler.addArticle(cc);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(1440, 900);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(1440, 900);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g.setFont(new Font("Arial", 0, 32));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x = 300;
        int y = 110;
        g.setFont(g.getFont().deriveFont(66.0f));
        int total = this.controler.getTotal();
        String euros = String.valueOf(CaisseControler.getEuros(total)) + ".";
        String cents = CaisseControler.getCents(total);
        Rectangle2D r = g.getFontMetrics().getStringBounds(euros, g);
        g.drawString(euros, x -= (int)r.getWidth(), y);
        g.setFont(g.getFont().deriveFont(40.0f));
        g.drawString(cents, x + (int)r.getWidth(), y);
        y += 40;
        x = 300;
        int paye = this.controler.getPaidTotal();
        euros = String.valueOf(CaisseControler.getEuros(paye)) + ".";
        cents = CaisseControler.getCents(paye);
        g.setFont(g.getFont().deriveFont(18.0f));
        Rectangle2D r2 = g.getFontMetrics().getStringBounds("Pay\u00e9", g);
        if (paye >= total) {
            g.setColor(Color.DARK_GRAY);
        } else {
            g.setColor(Color.ORANGE);
        }
        g.setFont(g.getFont().deriveFont(32.0f));
        r = g.getFontMetrics().getStringBounds(euros, g);
        g.drawString(euros, x - (int)r.getWidth(), y);
        g.setFont(g.getFont().deriveFont(24.0f));
        g.drawString(cents, x, y);
        g.setFont(g.getFont().deriveFont(18.0f));
        g.setColor(Color.GRAY);
        g.drawString("Pay\u00e9", x - (int)r2.getWidth() - (int)r.getWidth() - 10, y);
        y += 40;
        x = 300;
        int aRendre = paye - total;
        if (aRendre != 0) {
            String label;
            if (aRendre > 0) {
                label = "Rendu";
            } else {
                label = "Reste \u00e0 payer";
                aRendre = -aRendre;
            }
            euros = String.valueOf(CaisseControler.getEuros(aRendre)) + ".";
            cents = CaisseControler.getCents(aRendre);
            g.setFont(g.getFont().deriveFont(18.0f));
            Rectangle2D r3 = g.getFontMetrics().getStringBounds(label, g);
            g.setColor(Color.DARK_GRAY);
            g.setFont(g.getFont().deriveFont(32.0f));
            r = g.getFontMetrics().getStringBounds(euros, g);
            g.drawString(euros, x - (int)r.getWidth(), y);
            g.setFont(g.getFont().deriveFont(24.0f));
            g.drawString(cents, x, y);
            g.setFont(g.getFont().deriveFont(18.0f));
            g.setColor(Color.GRAY);
            g.drawString(label, x - (int)r3.getWidth() - (int)r.getWidth() - 10, y);
        }
    }

    @Override
    public void caisseStateChanged() {
        this.repaint();
    }
}

