/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.ui.TicketCellRenderer;

public class ArticleListCellRenderer
implements ListCellRenderer {
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Article article = (Article)value;
        JPanel p = new JPanel(){

            @Override
            public void paint(Graphics g) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                super.paint(g);
                g.setColor(Color.LIGHT_GRAY);
                g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
            }
        };
        p.setOpaque(true);
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        JLabel l = new JLabel(" " + article.getName());
        p.setOpaque(true);
        if (isSelected) {
            p.setBackground(new Color(232, 242, 254));
            p.setForeground(Color.BLACK);
        } else {
            p.setBackground(Color.WHITE);
            p.setForeground(Color.GRAY);
        }
        c.gridwidth = 1;
        c.weightx = 1.0;
        p.add((Component)l, c);
        ++c.gridx;
        c.weightx = 0.0;
        JLabel l2 = new JLabel(String.valueOf(TicketCellRenderer.centsToString(article.getPriceInCents())) + "\u20ac");
        p.add((Component)l2, c);
        l.setFont(l.getFont().deriveFont(24.0f));
        l2.setFont(l2.getFont().deriveFont(24.0f));
        return p;
    }
}

