/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.io;

import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.core.sales.pos.ui.BarcodeListener;

public class BarcodeReader
implements KeyEventDispatcher {
    public static final int MAX_INTER_KEY = 80;
    private static final int MIN_BARCODE_LENGTH = 2;
    private final List<BarcodeListener> listeners = new ArrayList<BarcodeListener>(1);
    private String value = "";
    private final List<KeyEvent> eve = new ArrayList<KeyEvent>();
    private long firstTime = -1L;
    private Timer timer = null;
    private TimerTask task = null;

    public synchronized void removeBarcodeListener(BarcodeListener l) {
        this.listeners.remove(l);
        if (this.listeners.size() == 0) {
            this.stop();
        }
    }

    public synchronized void addBarcodeListener(BarcodeListener l) {
        if (this.timer == null) {
            this.start();
        }
        this.listeners.add(l);
    }

    private void fire(String code) {
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).barcodeRead(code);
            ++i;
        }
    }

    public void start() {
        this.timer = new Timer(this.getClass().getName(), true);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (this.task != null) {
            this.task.cancel();
        }
        long t = e.getWhen();
        if (this.firstTime < 0L) {
            this.firstTime = t;
        }
        int key = e.getKeyCode();
        if (t - this.firstTime > 80L && key != 16) {
            this.redispatch();
        }
        char key2 = e.getKeyChar();
        this.eve.add(e);
        if (key != 0 && e.getID() == 402) {
            if (key != 16) {
                if (key2 == '*' || key2 == '$' || key2 == '+' || key2 == '/' || key2 == '%' || key2 == '-' | key2 == ' ') {
                    this.value = String.valueOf(this.value) + key2;
                } else if (key >= 48 && key <= 57 || key >= 65 && key <= 90) {
                    this.value = String.valueOf(this.value) + (char)key;
                } else if (key == 10 && this.value.length() >= 2) {
                    this.value = this.value.trim();
                    this.fire(this.value);
                    this.reset();
                } else {
                    this.redispatch();
                }
            }
            if (this.eve.size() > 0) {
                this.firstTime = t;
                this.task = new TimerTask(){

                    @Override
                    public void run() {
                        BarcodeReader.this.redispatchLater();
                    }
                };
                this.timer.schedule(this.task, 80L);
            }
            assert (this.eve.size() > 0 || this.firstTime == -1L);
        }
        return true;
    }

    private void redispatchLater() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BarcodeReader.this.redispatch();
            }
        });
    }

    private void redispatch() {
        int i = 0;
        while (i < this.eve.size()) {
            KeyEvent ee = this.eve.get(i);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().redispatchEvent(ee.getComponent(), ee);
            int j = 0;
            while (j < this.listeners.size()) {
                this.listeners.get(j).keyReceived(ee);
                ++j;
            }
            ++i;
        }
        this.reset();
    }

    private void reset() {
        this.value = "";
        this.eve.clear();
        this.firstTime = -1L;
    }
}

