/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.report;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.generationDoc.AbstractListeSheetXml;
import org.openconcerto.erp.generationDoc.SheetXml;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.Tuple2;

public class ListeVenteXmlSheet
extends AbstractListeSheetXml {
    private static final DateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
    private Date du;
    private Date au;
    private List<SQLRow> listeIds;
    JProgressBar bar;
    SQLElement eltAvoir = Configuration.getInstance().getDirectory().getElement("AVOIR_CLIENT");
    SQLElement eltEnc = Configuration.getInstance().getDirectory().getElement("ENCAISSER_MONTANT");
    SQLElement eltEncElt = Configuration.getInstance().getDirectory().getElement("ENCAISSER_MONTANT_ELEMENT");

    public static Tuple2<String, String> getTuple2Location() {
        return tupleDefault;
    }

    public ListeVenteXmlSheet(List<SQLRow> listeIds, Date du, Date au, JProgressBar bar) {
        this.printer = PrinterNXProps.getInstance().getStringProperty("BonPrinter");
        this.listeIds = listeIds;
        this.locationOO = SheetXml.getLocationForTuple(tupleDefault, false);
        this.locationPDF = SheetXml.getLocationForTuple(tupleDefault, true);
        this.du = du;
        this.au = au;
        this.modele = "ListeVentes";
        this.bar = bar;
    }

    @Override
    protected void createListeValues() {
        if (this.listeIds == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ListeVenteXmlSheet.this.bar.setMaximum(ListeVenteXmlSheet.this.listeIds.size());
            }
        });
        ArrayList listValues = new ArrayList(this.listeIds.size());
        int i = 1;
        for (SQLRow rowFacture : this.listeIds) {
            HashMap<String, Object> mValues = new HashMap<String, Object>();
            String dateFacture = dateFormat.format((Date)rowFacture.getObject("DATE"));
            mValues.put("DATE", dateFacture);
            mValues.put("NUMERO", rowFacture.getObject("NUMERO"));
            if (rowFacture.getTable().getName().equalsIgnoreCase(this.eltAvoir.getTable().getName())) {
                mValues.put("MONTANT_HT", new Double((double)(-((Number)rowFacture.getObject("MONTANT_HT")).longValue()) / 100.0));
                mValues.put("MONTANT_TVA", new Double((double)(-((Number)rowFacture.getObject("MONTANT_TVA")).longValue()) / 100.0));
                mValues.put("MONTANT_TTC", new Double((double)(-((Number)rowFacture.getObject("MONTANT_TTC")).longValue()) / 100.0));
            } else {
                mValues.put("MONTANT_HT", new Double((double)((Number)rowFacture.getObject("T_HT")).longValue() / 100.0));
                mValues.put("MONTANT_TVA", new Double((double)((Number)rowFacture.getObject("T_TVA")).longValue() / 100.0));
                mValues.put("MONTANT_TTC", new Double((double)((Number)rowFacture.getObject("T_TTC")).longValue() / 100.0));
            }
            SQLRow rowCli = rowFacture.getForeignRow("ID_CLIENT");
            String libClient = String.valueOf(rowCli.getString("FORME_JURIDIQUE")) + " " + rowCli.getString("NOM");
            mValues.put("CLIENT", libClient.trim());
            SQLRow rowMode = rowFacture.getForeignRow("ID_MODE_REGLEMENT");
            int typeReglement = rowMode.getInt("ID_TYPE_REGLEMENT");
            if (rowMode.getBoolean("COMPTANT").booleanValue() && typeReglement <= 5) {
                Calendar c;
                SQLRow foreignRow = rowMode.getForeignRow("ID_TYPE_REGLEMENT");
                Date d = (Date)rowFacture.getObject("DATE");
                if (foreignRow.getID() == 5) {
                    c = rowMode.getDate("DATE_VIREMENT");
                    if (c != null) {
                        d = c.getTime();
                    }
                } else if (foreignRow.getID() == 2 && (c = rowMode.getDate("DATE")) != null) {
                    d = c.getTime();
                }
                mValues.put("DATE_REGLEMENT", dateFormat.format(d));
                mValues.put("TYPE_REGLEMENT", foreignRow.getString("NOM"));
            } else {
                SQLRow rowMvt = rowFacture.getForeignRow("ID_MOUVEMENT");
                SQLRow rowPiece = rowMvt.getForeignRow("ID_PIECE");
                SQLSelect sel = new SQLSelect(rowFacture.getTable().getBase());
                sel.addSelect(this.eltEnc.getTable().getKey());
                sel.addSelect(this.eltEnc.getTable().getField("ID_MODE_REGLEMENT"));
                Where w = new Where((FieldRef)rowMvt.getTable().getField("ID_PIECE"), "=", rowPiece.getID());
                w = w.and(new Where((FieldRef)rowMvt.getTable().getKey(), "=", this.eltEncElt.getTable().getField("ID_MOUVEMENT_ECHEANCE")));
                w = w.and(new Where((FieldRef)this.eltEncElt.getTable().getField("ID_ENCAISSER_MONTANT"), "=", this.eltEnc.getTable().getKey()));
                sel.setWhere(w);
                List l = (List)Configuration.getInstance().getBase().getDataSource().execute(sel.asString(), SQLRowListRSH.createFromSelect(sel, this.eltEnc.getTable()));
                for (SQLRow sqlRow : l) {
                    SQLRow foreignRow = sqlRow.getForeignRow("ID_MODE_REGLEMENT");
                    SQLRow rowTypeRegl = foreignRow.getForeignRow("ID_TYPE_REGLEMENT");
                    Calendar cDate = foreignRow.getDate("DATE");
                    Calendar cDateVirement = foreignRow.getDate("DATE_VIREMENT");
                    if (cDate != null) {
                        mValues.put("DATE_REGLEMENT", dateFormat.format(cDate.getTime()));
                    } else if (cDateVirement != null) {
                        mValues.put("DATE_REGLEMENT", dateFormat.format(cDateVirement.getTime()));
                    } else {
                        mValues.put("DATE_REGLEMENT", dateFormat.format(sqlRow.getDate("DATE").getTime()));
                    }
                    mValues.put("TYPE_REGLEMENT", rowTypeRegl.getString("NOM"));
                }
            }
            listValues.add(mValues);
            final int value = i++;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ListeVenteXmlSheet.this.bar.setValue(value);
                }
            });
        }
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("DATE", "Du " + dateFormat.format(this.du) + " au " + dateFormat.format(this.au));
        this.listAllSheetValues.put(0, listValues);
        this.mapAllSheetValues.put(0, values);
    }

    @Override
    public String getFileName() {
        return ListeVenteXmlSheet.getValidFileName("JournalVentes");
    }
}

