/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.reports.history.ui;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.core.reports.history.ui.HistoriqueClientBilanPanel;
import org.openconcerto.erp.core.reports.history.ui.ListeHistoriquePanel;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;

public class HistoriqueClientFrame {
    private PanelFrame panelFrame;
    private ListeHistoriquePanel listPanel;

    public HistoriqueClientFrame() {
        ComptaPropsConfiguration comptaPropsConfiguration = (ComptaPropsConfiguration)Configuration.getInstance();
        SQLBase b = comptaPropsConfiguration.getSQLBaseSociete();
        ArrayList<String> l = new ArrayList<String>();
        String valModeVenteComptoir = DefaultNXProps.getInstance().getStringProperty("ArticleVenteComptoir");
        Boolean bModeVenteComptoir = Boolean.valueOf(valModeVenteComptoir);
        if (bModeVenteComptoir.booleanValue()) {
            l.add("SAISIE_VENTE_COMPTOIR");
        }
        l.add("SAISIE_VENTE_FACTURE");
        l.add("CHEQUE_A_ENCAISSER");
        l.add("ECHEANCE_CLIENT");
        l.add("RELANCE");
        l.add("DEVIS");
        l.add("AVOIR_CLIENT");
        l.add("SAISIE_VENTE_FACTURE_ELEMENT");
        HashMap<SQLTable, SQLField> map = new HashMap<SQLTable, SQLField>();
        map.put(b.getTable("SAISIE_VENTE_FACTURE_ELEMENT"), b.getTable("SAISIE_VENTE_FACTURE_ELEMENT").getField("ID_SAISIE_VENTE_FACTURE"));
        final HistoriqueClientBilanPanel bilanPanel = new HistoriqueClientBilanPanel();
        this.listPanel = new ListeHistoriquePanel("Clients", b.getTable("CLIENT"), l, bilanPanel, map);
        this.listPanel.addListenerTable(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                bilanPanel.updateRelance(HistoriqueClientFrame.this.listPanel.getListId("RELANCE"));
            }
        }, "RELANCE");
        this.listPanel.addListenerTable(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                bilanPanel.updateEcheance(HistoriqueClientFrame.this.listPanel.getListId("ECHEANCE_CLIENT"));
            }
        }, "ECHEANCE_CLIENT");
        this.listPanel.addListenerTable(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                int size = HistoriqueClientFrame.this.listPanel.getListId("CHEQUE_A_ENCAISSER").size();
                System.err.println("------------------------------------ Fire Table Changed --> cheque a encaisser " + size);
                bilanPanel.updateChequeData(HistoriqueClientFrame.this.listPanel.getListId("CHEQUE_A_ENCAISSER"));
            }
        }, "CHEQUE_A_ENCAISSER");
        this.listPanel.addListenerTable(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                bilanPanel.updateVCData(HistoriqueClientFrame.this.listPanel.getListId("SAISIE_VENTE_COMPTOIR"));
            }
        }, "SAISIE_VENTE_COMPTOIR");
        this.listPanel.addListenerTable(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                SQLRowAccessor rowSel = HistoriqueClientFrame.this.listPanel.getSelectedRow();
                int id = rowSel == null ? -1 : rowSel.getID();
                bilanPanel.updateVFData(HistoriqueClientFrame.this.listPanel.getListId("SAISIE_VENTE_FACTURE"), id);
                bilanPanel.updateTotalVente(id);
            }
        }, "SAISIE_VENTE_FACTURE");
        this.panelFrame = new PanelFrame(this.listPanel, "Historique client");
        this.panelFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                HistoriqueClientFrame.this.listPanel.removeAllTableListener();
            }
        });
        this.panelFrame.setDefaultCloseOperation(2);
    }

    public PanelFrame getFrame() {
        return this.panelFrame;
    }

    public void selectId(int id) {
        this.listPanel.selectIDinJList(id);
    }

    public void setVisible(boolean b) {
        this.panelFrame.setVisible(b);
    }
}

