/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import java.util.Calendar;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openconcerto.erp.model.EditionFichePayeModel;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.preferences.DefaultProps;
import org.openconcerto.utils.ExceptionHandler;

public class EditionFichePayePanel
extends JPanel
implements MouseListener {
    private final DefaultProps props = DefaultNXProps.getInstance();
    private final JProgressBar bar = new JProgressBar();
    private final JLabel labelEtatEdition = new JLabel();
    private final EditionFichePayeModel model = new EditionFichePayeModel(this.bar, this.labelEtatEdition);
    private final JTable table;
    private EditFrame frameModifySal = null;

    public EditionFichePayePanel() {
        super(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(2, 2, 1, 2);
        JPanel panelPeriode = new JPanel();
        panelPeriode.setBorder(BorderFactory.createTitledBorder("P\u00e9riode de travail"));
        SQLElement eltMois = Configuration.getInstance().getDirectory().getElement("MOIS");
        JLabel labelMois = new JLabel("Mois");
        final ElementComboBox selMois = new ElementComboBox(false, 25);
        selMois.init(eltMois);
        selMois.setButtonsVisible(false);
        int valMois = this.props.getIntProperty("MoisEditionPaye");
        if (valMois > 1) {
            selMois.setValue(valMois);
        }
        JLabel labelAnnee = new JLabel("Ann\u00e9e");
        Calendar cal = Calendar.getInstance();
        SpinnerNumberModel modelSpinner = new SpinnerNumberModel(cal.get(1), cal.get(1) - 100, cal.get(1) + 100, 1);
        final JSpinner textAnnee = new JSpinner(modelSpinner);
        String valYear = this.props.getStringProperty("AnneeEditionPaye");
        if (valYear != null && valYear.trim().length() > 0) {
            textAnnee.setValue(Integer.valueOf(valYear));
        }
        panelPeriode.add(labelMois);
        panelPeriode.add(selMois);
        panelPeriode.add(labelAnnee);
        panelPeriode.add(textAnnee);
        JLabel periodeDeb = new JLabel("Correspondant \u00e0 la p\u00e9riode du");
        JLabel periodeFin = new JLabel("au");
        final JDate dateDeb = new JDate();
        final JDate dateFin = new JDate();
        panelPeriode.add(periodeDeb);
        panelPeriode.add(dateDeb);
        panelPeriode.add(periodeFin);
        panelPeriode.add(dateFin);
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.add((Component)panelPeriode, c);
        ++c.gridy;
        this.table = new JTable(this.model);
        this.table.addMouseListener(this);
        c.fill = 1;
        c.weighty = 1.0;
        this.add((Component)new JScrollPane(this.table), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.fill = 2;
        c.weighty = 0.0;
        c.weightx = 1.0;
        this.labelEtatEdition.setHorizontalAlignment(0);
        this.add((Component)this.labelEtatEdition, c);
        c.gridwidth = 0;
        c.fill = 2;
        ++c.gridy;
        c.weighty = 0.0;
        this.add((Component)this.bar, c);
        JButton buttonValid = new JButton("Valider");
        JButton buttonFermer = new JButton("Fermer");
        ++c.gridy;
        c.gridwidth = 1;
        c.anchor = 13;
        c.weightx = 1.0;
        c.fill = 0;
        this.add((Component)buttonValid, c);
        c.weightx = 0.0;
        ++c.gridx;
        this.add((Component)buttonFermer, c);
        buttonFermer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(EditionFichePayePanel.this)).dispose();
            }
        });
        buttonValid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    EditionFichePayePanel.this.props.setProperty("MoisEditionPaye", String.valueOf(selMois.getSelectedId()));
                    EditionFichePayePanel.this.props.store();
                    Date du = new Date(dateDeb.getDate().getTime());
                    Date au = new Date(dateFin.getDate().getTime());
                    EditionFichePayePanel.this.model.validationFiche(textAnnee.getValue().toString(), selMois.getSelectedId(), du, au);
                }
                catch (Exception ex) {
                    ExceptionHandler.handle("Impossible de valider la paye", ex);
                }
            }
        });
        selMois.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (selMois.getSelectedId() > 1 && textAnnee.getValue() != null) {
                    Calendar cal = Calendar.getInstance();
                    cal.set(5, 1);
                    cal.set(2, selMois.getSelectedId() - 2);
                    cal.set(1, Integer.valueOf(textAnnee.getValue().toString()));
                    dateDeb.setValue(cal.getTime());
                    cal.set(5, cal.getActualMaximum(5));
                    dateFin.setValue(cal.getTime());
                }
            }
        });
        textAnnee.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Calendar cal = Calendar.getInstance();
                cal.set(5, 1);
                cal.set(2, selMois.getSelectedId() - 2);
                cal.set(1, Integer.valueOf(textAnnee.getValue().toString()));
                dateDeb.setValue(cal.getTime());
                cal.set(5, cal.getActualMaximum(5));
                dateFin.setValue(cal.getTime());
            }
        });
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int row = this.table.rowAtPoint(e.getPoint());
        final int idSal = this.model.getIdSalAtRow(row);
        if (e.getButton() == 3) {
            JPopupMenu menuDroit = new JPopupMenu();
            menuDroit.add(new AbstractAction("Modifier"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EditionFichePayePanel.this.frameModifySal == null) {
                        SQLElement elt = Configuration.getInstance().getDirectory().getElement("SALARIE");
                        EditionFichePayePanel.this.frameModifySal = new EditFrame(elt, EditPanel.MODIFICATION);
                    }
                    EditionFichePayePanel.this.frameModifySal.selectionId(idSal, 1);
                    EditionFichePayePanel.this.frameModifySal.pack();
                    EditionFichePayePanel.this.frameModifySal.setVisible(true);
                }
            });
            menuDroit.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

