/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.report;

import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.generationDoc.SheetInterface;
import org.openconcerto.erp.generationDoc.SheetXml;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.Tuple2;

public class EtatChargesPayeSheet
extends SheetInterface {
    private static int debutFill;
    private static int endFill;
    private static final SQLTable tableFichePaye;
    private static final SQLTable tableFichePayeElement;
    private static final SQLTable tableMois;
    private static final SQLTable tableCaisse;
    private static final SQLTable tableRubCot;
    private static final DateFormat dateFormat;
    private int moisDu;
    private int moisAu;
    private String annee;
    private static final Tuple2<String, String> tuple;

    static {
        tableFichePaye = base.getTable("FICHE_PAYE");
        tableFichePayeElement = base.getTable("FICHE_PAYE_ELEMENT");
        tableMois = base.getTable("MOIS");
        tableCaisse = Configuration.getInstance().getBase().getTable("CAISSE_COTISATION");
        tableRubCot = Configuration.getInstance().getBase().getTable("RUBRIQUE_COTISATION");
        dateFormat = DateFormat.getDateInstance(2);
        EtatChargesPayeSheet.setSize(7, 66);
        tuple = Tuple2.create("LocationEtatChargesPaye", "Etat des charges");
    }

    public static void setSize(int debut, int fin) {
        debutFill = debut;
        endFill = fin;
    }

    public static Tuple2<String, String> getTuple2Location() {
        return tuple;
    }

    public EtatChargesPayeSheet(int moisDu, int moisAu, String annee) {
        this.printer = PrinterNXProps.getInstance().getStringProperty("EtatChargesPayePrinter");
        this.modele = "EtatChargesPaye.ods";
        this.locationOO = String.valueOf(SheetXml.getLocationForTuple(tuple, false)) + File.separator + annee;
        this.locationPDF = String.valueOf(SheetXml.getLocationForTuple(tuple, true)) + File.separator + annee;
        this.moisAu = moisAu;
        this.moisDu = moisDu;
        this.annee = annee;
        this.nbRowsPerPage = 68;
        this.createMap();
    }

    private void makeEntete(int row) {
        SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
        this.mCell.put("A" + row, rowSociete.getObject("NOM"));
        this.mCell.put("F" + row, "Edition du " + dateFormat.format(new Date()));
        System.err.println("MAKE ENTETE");
    }

    private void makeBasPage(int row) {
        SQLRow rowMoisDu = tableMois.getRow(this.moisDu);
        SQLRow rowMoisAu = tableMois.getRow(this.moisAu);
        this.mCell.put("A" + row, "P\u00e9riode de " + rowMoisDu.getString("NOM") + " \u00e0 " + rowMoisAu.getString("NOM") + " " + this.annee);
    }

    @Override
    protected void createMap() {
        this.mapReplace = new HashMap();
        this.mCell = new HashMap();
        this.mapStyleRow = new HashMap();
        SQLSelect sel = new SQLSelect(base);
        sel.addSelect(tableFichePaye.getField("ID"));
        sel.addSelect(tableFichePayeElement.getField("ID"));
        Where w = new Where((FieldRef)tableFichePayeElement.getField("ID_FICHE_PAYE"), "=", tableFichePaye.getField("ID"));
        Where w6 = new Where((FieldRef)tableFichePayeElement.getField("SOURCE"), "=", (Object)"RUBRIQUE_COTISATION");
        Where w3 = new Where((FieldRef)tableFichePaye.getField("ID_MOIS"), new Integer(this.moisDu), (Object)new Integer(this.moisAu));
        Where w4 = new Where((FieldRef)tableFichePaye.getField("ANNEE"), "=", (Object)new Integer(this.annee));
        Where w5 = new Where((FieldRef)tableFichePaye.getField("VALIDE"), "=", (Object)Boolean.TRUE);
        sel.setWhere(w);
        sel.andWhere(w3);
        sel.andWhere(w4);
        sel.andWhere(w5);
        sel.andWhere(w6);
        sel.setDistinct(true);
        String req = sel.asString();
        System.err.println(req);
        List l = (List)base.getDataSource().execute(req, new ArrayListHandler());
        HashMap<Integer, Map<Object, SQLRowValues>> mapCaisse = new HashMap<Integer, Map<Object, SQLRowValues>>();
        HashMap<Object, String> mapFiche = new HashMap<Object, String>();
        int i = 0;
        while (i < l.size()) {
            SQLRowValues rowVals;
            Map<Object, SQLRowValues> mapValueRub;
            Object[] tmp = (Object[])l.get(i);
            mapFiche.put(tmp[0], "");
            int idFicheElt = Integer.parseInt(tmp[1].toString());
            SQLRow rowFicheElt = tableFichePayeElement.getRow(idFicheElt);
            SQLRow rowRub = tableRubCot.getRow(rowFicheElt.getInt("IDSOURCE"));
            if (mapCaisse.containsKey(new Integer(rowRub.getInt("ID_CAISSE_COTISATION")))) {
                mapValueRub = (Map)mapCaisse.get(new Integer(rowRub.getInt("ID_CAISSE_COTISATION")));
            } else {
                mapValueRub = new HashMap();
                mapCaisse.put(new Integer(rowRub.getInt("ID_CAISSE_COTISATION")), mapValueRub);
            }
            if (mapValueRub.containsKey(rowFicheElt.getObject("IDSOURCE"))) {
                float montant;
                Object o;
                rowVals = (SQLRowValues)mapValueRub.get(rowFicheElt.getObject("IDSOURCE"));
                if (rowFicheElt.getObject("NB_BASE") != null) {
                    o = rowVals.getObject("NB_BASE");
                    float base = o == null ? 0.0f : ((Float)o).floatValue();
                    rowVals.put("NB_BASE", new Float(base += rowFicheElt.getFloat("NB_BASE")));
                }
                if (rowFicheElt.getObject("MONTANT_PAT") != null) {
                    o = rowVals.getObject("MONTANT_PAT");
                    montant = o == null ? 0.0f : ((Float)o).floatValue();
                    rowVals.put("MONTANT_PAT", new Float(montant += rowFicheElt.getFloat("MONTANT_PAT")));
                }
                if (rowFicheElt.getObject("MONTANT_SAL_DED") != null) {
                    o = rowVals.getObject("MONTANT_SAL_DED");
                    montant = o == null ? 0.0f : ((Float)o).floatValue();
                    rowVals.put("MONTANT_SAL_DED", new Float(montant += rowFicheElt.getFloat("MONTANT_SAL_DED")));
                }
            } else {
                float montantSal;
                rowVals = new SQLRowValues(tableFichePayeElement);
                rowVals.loadAllSafe(rowFicheElt);
                Object o = rowVals.getObject("MONTANT_PAT");
                float montantPat = o == null ? 0.0f : ((Float)o).floatValue();
                o = rowVals.getObject("MONTANT_SAL_DED");
                float f = montantSal = o == null ? 0.0f : ((Float)o).floatValue();
                if (montantPat != 0.0f || montantSal != 0.0f) {
                    mapValueRub.put(rowFicheElt.getObject("IDSOURCE"), rowVals);
                }
            }
            ++i;
        }
        int posLine = 1;
        int firstLine = 1;
        System.err.println("Dump fiche " + mapFiche);
        System.err.println("NB Pages = " + mapCaisse.keySet().size());
        int n = 0;
        while (n < mapCaisse.keySet().size()) {
            this.makeEntete(posLine);
            Map mapValue = (Map)mapCaisse.get(mapCaisse.keySet().toArray()[n]);
            float totalMontantSal = 0.0f;
            float totalMontantPat = 0.0f;
            SQLRow rowCaisse = tableCaisse.getRow(Integer.parseInt(mapCaisse.keySet().toArray()[n].toString()));
            this.mCell.put("A" + (posLine += debutFill - 1), "Caisse " + rowCaisse.getObject("NOM"));
            this.mCell.put("B" + posLine, "");
            this.mCell.put("C" + posLine, "");
            this.mCell.put("D" + posLine, "");
            this.mCell.put("E" + posLine, "");
            this.mCell.put("F" + posLine, "");
            this.mapStyleRow.put(new Integer(posLine), "Titre 1");
            ++posLine;
            int i2 = 0;
            while (i2 < mapValue.keySet().size()) {
                SQLRowValues rowVals = (SQLRowValues)mapValue.get(mapValue.keySet().toArray()[i2]);
                this.mCell.put("A" + posLine, rowVals.getObject("NOM"));
                this.mCell.put("B" + posLine, rowVals.getObject("NB_BASE"));
                Float oTxSal = (Float)rowVals.getObject("TAUX_SAL");
                float txSal = oTxSal == null ? 0.0f : oTxSal.floatValue();
                Float oTxPat = (Float)rowVals.getObject("TAUX_PAT");
                float txPat = oTxPat == null ? 0.0f : oTxPat.floatValue();
                this.mCell.put("C" + posLine, new Float(txSal + txPat));
                System.err.println(rowVals.getObject("MONTANT_SAL_DED").getClass());
                Float oMontantSal = (Float)rowVals.getObject("MONTANT_SAL_DED");
                float montantSal = oMontantSal == null ? 0.0f : oMontantSal.floatValue();
                Float oMontantPat = (Float)rowVals.getObject("MONTANT_PAT");
                float montantPat = oMontantPat == null ? 0.0f : oMontantPat.floatValue();
                this.mCell.put("D" + posLine, new Float(montantPat));
                this.mCell.put("E" + posLine, new Float(montantSal));
                this.mCell.put("F" + posLine, new Float(montantSal + montantPat));
                totalMontantPat += montantPat;
                totalMontantSal += montantSal;
                this.mapStyleRow.put(new Integer(posLine), "Normal");
                ++posLine;
                ++i2;
            }
            this.mCell.put("A" + posLine, "Total");
            this.mCell.put("B" + posLine, "");
            this.mCell.put("C" + posLine, "");
            this.mCell.put("D" + posLine, new Float(totalMontantPat));
            this.mCell.put("E" + posLine, new Float(totalMontantSal));
            this.mCell.put("F" + posLine, new Float(totalMontantPat + totalMontantSal));
            this.mapStyleRow.put(new Integer(posLine), "Titre 1");
            posLine = firstLine + endFill - 1;
            this.makeBasPage(posLine += 2);
            firstLine = ++posLine;
            ++n;
        }
        this.nbPage = mapCaisse.size();
        System.err.println("Nombre de page " + this.nbPage);
        if (this.nbPage > 0) {
            --this.nbPage;
        }
    }
}

