/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.element;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.TreePath;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.jedit.CTokenMarker;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.SQLJavaEditor;
import org.openconcerto.erp.core.humanresources.payroll.component.FormuleTreeNode;
import org.openconcerto.erp.core.humanresources.payroll.component.VariableRowTreeNode;
import org.openconcerto.erp.core.humanresources.payroll.component.VariableTree;
import org.openconcerto.erp.core.humanresources.payroll.element.SalarieSQLElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.ConfSQLElement;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.warning.JLabelWarning;
import org.openconcerto.utils.ExceptionHandler;

public class VariablePayeSQLElement
extends ConfSQLElement {
    private static SQLTable tableVarSal = null;

    private static SQLTable getTableVarSal() {
        if (tableVarSal == null) {
            tableVarSal = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("VARIABLE_SALARIE");
        }
        return tableVarSal;
    }

    public VariablePayeSQLElement() {
        super("VARIABLE_PAYE", "une variable de paye", "variables de paye");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        l.add("CATEGORIE");
        l.add("VALEUR");
        l.add("FORMULE");
        return l;
    }

    @Override
    public Set<String> getInsertOnlyFields() {
        HashSet<String> s = new HashSet<String>();
        s.add("NOM");
        return s;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        return l;
    }

    public static final List<String> getForbiddenVarName() {
        ArrayList<String> l = new ArrayList<String>();
        for (SQLField field : VariablePayeSQLElement.getTableVarSal().getContentFields()) {
            l.add(field.getName());
        }
        l.add("PAT");
        l.add("SAL");
        l.add("BASE");
        l.add("MONTANT");
        l.add("TAUX");
        l.add("ACOMPTE");
        l.add("DUREE_HEBDO");
        l.add("DUREE_MOIS");
        l.add("SALAIRE_MOIS");
        l.add("TAUX_AT");
        l.add("CONGES_PAYES");
        l.add("NB_ENFANTS");
        l.add("NB_PERS_A_CHARGE");
        l.add("PAT");
        l.add("SAL");
        l.add("BASE");
        l.add("MONTANT");
        l.add("SAL_BRUT");
        l.add("COT_PAT");
        l.add("COT_SAL");
        l.add("NET_IMP");
        l.add("NET_A_PAYER");
        l.add("CSG");
        l.add("CONGES_ACQUIS");
        l.add("CSG_C");
        l.add("CONGES_PRIS");
        l.add("RESTANT");
        l.add("COT_PAT_C");
        l.add("COT_SAL_C");
        l.add("HEURE_ABS");
        l.add("HEURE_TRAV");
        l.add("HEURE_110");
        l.add("HEURE_125");
        l.add("HEURE_150");
        l.add("HEURE_200");
        l.add("SAL_BRUT_C");
        l.add("NET_A_PAYER_C");
        l.add("NET_IMP_C");
        return l;
    }

    public static final Map<String, List<?>> getMapTree() {
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLBase baseCommon = Configuration.getInstance().getBase();
        SQLTable tableVar = baseCommon.getTable("VARIABLE_PAYE");
        SQLTable tableCumulsConges = base.getTable("CUMULS_CONGES");
        SQLTable tableCumulsPaye = base.getTable("CUMULS_PAYE");
        HashMap mapTree = new HashMap();
        ArrayList<SQLField> varSal = new ArrayList<SQLField>();
        for (SQLField field : VariablePayeSQLElement.getTableVarSal().getContentFields()) {
            varSal.add(field);
        }
        for (SQLField field : tableCumulsConges.getContentFields()) {
            varSal.add(field);
        }
        for (SQLField field : tableCumulsPaye.getContentFields()) {
            varSal.add(field);
        }
        mapTree.put("Infos p\u00e9riode", varSal);
        ArrayList<SQLField> l = new ArrayList<SQLField>();
        SQLTable tableInfos = base.getTable("INFOS_SALARIE_PAYE");
        l.add(tableInfos.getField("DUREE_HEBDO"));
        l.add(tableInfos.getField("DUREE_MOIS"));
        l.add(tableInfos.getField("SALAIRE_MOIS"));
        l.add(tableInfos.getField("TAUX_AT"));
        l.add(tableInfos.getField("CONGES_PAYES"));
        mapTree.put("Contrat salari\u00e9", l);
        ArrayList<SQLField> l2 = new ArrayList<SQLField>();
        SQLTable tableFichePaye = base.getTable("FICHE_PAYE");
        l2.add(tableFichePaye.getField("CONGES_ACQUIS"));
        l2.add(tableFichePaye.getField("ACOMPTE"));
        l2.add(tableFichePaye.getField("SAL_BRUT"));
        l2.add(tableFichePaye.getField("COT_PAT"));
        l2.add(tableFichePaye.getField("COT_SAL"));
        l2.add(tableFichePaye.getField("NET_IMP"));
        l2.add(tableFichePaye.getField("NET_A_PAYER"));
        l2.add(tableFichePaye.getField("CSG"));
        mapTree.put("Contenu paye", l2);
        SQLSelect selAllVarID = new SQLSelect(tableVar.getBase());
        selAllVarID.addSelect(tableVar.getField("ID"));
        selAllVarID.addRawOrder("LENGTH(\"VARIABLE_PAYE\".\"NOM\") DESC");
        String reqAllVarID = selAllVarID.asString();
        Object[] objKeysRowVar = ((List)tableVar.getBase().getDataSource().execute(reqAllVarID, new ArrayListHandler())).toArray();
        ArrayList<SQLRow> lVar = new ArrayList<SQLRow>();
        int i = 0;
        while (i < objKeysRowVar.length) {
            Object[] tmp = (Object[])objKeysRowVar[i];
            lVar.add(tableVar.getRow(Integer.parseInt(tmp[0].toString())));
            ++i;
        }
        if (lVar.size() > 0) {
            mapTree.put("Variables", lVar);
        }
        ArrayList fonction = new ArrayList();
        HashMap<String, String> listFonction = new HashMap<String, String>();
        listFonction.put("Minimum", "Math.min()");
        listFonction.put("Maximum", "Math.max()");
        listFonction.put("Valeur absolue", "Math.abs()");
        listFonction.put("Arrondi", "Math.round()");
        fonction.add(listFonction);
        mapTree.put("Fonctions", fonction);
        return mapTree;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            private boolean validVarName;
            private static final String VAR_ALREADY_EXIST = "Cette variable existe d\u00e9j\u00e0!";
            private static final String VAR_NAME_NOT_CORRECT = "Nom de variable incorrect!";
            private static final String VAR_NO_NAME = "Aucun nom attribu\u00e9!";
            private JRadioButton radioVal;
            private JRadioButton radioFormule;
            private final JTextField textValeur;
            private final VariableTree treeVariable;
            private final JTextField textNom;
            private final JLabel labelImgWarningBadVar;
            private final JLabel labelWarningBadVar;
            private ElementComboBox comboSelSal;
            private EditFrame edit;
            private final SQLJavaEditor textFormule;
            {
                this.radioVal = new JRadioButton("Valeur");
                this.radioFormule = new JRadioButton("Formule");
                this.textValeur = new JTextField();
                this.treeVariable = new VariableTree();
                this.textNom = new JTextField();
                this.labelImgWarningBadVar = new JLabelWarning();
                this.labelWarningBadVar = new JLabel(VAR_NO_NAME);
                this.edit = null;
                this.textFormule = new SQLJavaEditor(VariablePayeSQLElement.getMapTree());
            }

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                this.validVarName = false;
                this.textFormule.setEditable(false);
                c.gridheight = 0;
                c.anchor = 18;
                c.fill = 1;
                JScrollPane sc = new JScrollPane(this.treeVariable);
                sc.setPreferredSize(new Dimension(150, sc.getPreferredSize().height));
                this.treeVariable.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent mE) {
                        TreePath path;
                        Object obj;
                        if (mE.getButton() == 3) {
                            JPopupMenu menuDroit = new JPopupMenu();
                            TreePath path2 = treeVariable.getClosestPathForLocation(mE.getPoint().x, mE.getPoint().y);
                            final Object obj2 = path2.getLastPathComponent();
                            if (obj2 == null || !(obj2 instanceof VariableRowTreeNode)) {
                                return;
                            }
                            menuDroit.add(new AbstractAction("Editer"){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    if (edit == null) {
                                        edit = new EditFrame(new VariablePayeSQLElement(), EditFrame.MODIFICATION);
                                    }
                                    System.err.println("Action performed");
                                    if (obj2 != null) {
                                        System.err.println("Object not null --> " + obj2.toString());
                                        if (obj2 instanceof VariableRowTreeNode) {
                                            System.err.println("Object VariableRowTreeNode");
                                            VariableRowTreeNode varNode = (VariableRowTreeNode)obj2;
                                            edit.selectionId(varNode.getID(), 1);
                                            edit.setVisible(true);
                                        }
                                    }
                                }
                            });
                            menuDroit.show((Component)mE.getSource(), mE.getPoint().x, mE.getPoint().y);
                        } else if (mE.getClickCount() == 2 && (obj = (path = treeVariable.getClosestPathForLocation(mE.getPoint().x, mE.getPoint().y)).getLastPathComponent()) != null && obj instanceof FormuleTreeNode) {
                            FormuleTreeNode n = (FormuleTreeNode)obj;
                            int start = textFormule.getSelectionStart();
                            String tmp = textFormule.getText();
                            textFormule.setText(String.valueOf(tmp.substring(0, start)) + n.getTextValue() + tmp.substring(start, tmp.length()));
                        }
                    }
                });
                JPanel panelDroite = new JPanel();
                panelDroite.setLayout(new GridBagLayout());
                JTextField textCategorie = new JTextField();
                c.fill = 2;
                c.gridheight = 1;
                c.gridx = 1;
                c.gridy = 0;
                JLabel labelCategorie = new JLabel("Cat\u00e9gorie");
                panelDroite.add((Component)labelCategorie, c);
                ++c.gridx;
                panelDroite.add((Component)textCategorie, c);
                c.fill = 2;
                c.gridheight = 1;
                c.gridx = 1;
                ++c.gridy;
                JLabel labelNom = new JLabel("Nom");
                panelDroite.add((Component)labelNom, c);
                ++c.gridx;
                panelDroite.add((Component)this.textNom, c);
                this.textNom.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        validVarName = this.isValidVarName();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        validVarName = this.isValidVarName();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        validVarName = this.isValidVarName();
                    }
                });
                ++c.gridx;
                panelDroite.add((Component)this.labelImgWarningBadVar, c);
                ++c.gridx;
                panelDroite.add((Component)this.labelWarningBadVar, c);
                JLabel labelInfos = new JLabel(this.getLabelFor("INFOS"));
                ITextArea textInfos = new ITextArea();
                ++c.gridy;
                c.gridx = 1;
                c.gridwidth = 1;
                panelDroite.add((Component)labelInfos, c);
                ++c.gridx;
                c.gridwidth = 0;
                c.weighty = 0.0;
                panelDroite.add((Component)textInfos, c);
                c.gridx = 1;
                ++c.gridy;
                c.gridwidth = 1;
                panelDroite.add((Component)this.radioVal, c);
                ++c.gridx;
                c.gridwidth = 0;
                panelDroite.add((Component)this.textValeur, c);
                c.gridwidth = 1;
                c.gridx = 1;
                ++c.gridy;
                panelDroite.add((Component)this.radioFormule, c);
                ++c.gridx;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.fill = 1;
                c.gridwidth = 0;
                panelDroite.add((Component)this.textFormule, c);
                c.gridwidth = 1;
                ButtonGroup group = new ButtonGroup();
                group.add(this.radioVal);
                group.add(this.radioFormule);
                this.radioVal.setSelected(true);
                this.setFormuleEnabled(false);
                this.radioVal.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.setFormuleEnabled(false);
                    }
                });
                this.radioFormule.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.setFormuleEnabled(true);
                    }
                });
                ++c.gridy;
                c.gridx = 1;
                c.weighty = 0.0;
                c.weightx = 0.0;
                c.fill = 2;
                this.comboSelSal = new ElementComboBox(false);
                this.comboSelSal.init(new SalarieSQLElement());
                ++c.gridx;
                panelDroite.add((Component)this.comboSelSal, c);
                JSplitPane split = new JSplitPane(1, sc, panelDroite);
                c.fill = 1;
                c.gridx = 0;
                c.gridy = 0;
                c.weightx = 1.0;
                c.weighty = 1.0;
                this.add((Component)split, c);
                this.addRequiredSQLObject(this.textNom, "NOM");
                this.addSQLObject(this.textValeur, "VALEUR");
                this.addSQLObject(this.textFormule, "FORMULE");
                this.addSQLObject(textCategorie, "CATEGORIE");
                this.addSQLObject(textInfos, "INFOS");
                this.comboSelSal.addValueListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        textFormule.setSalarieID(comboSelSal.getSelectedId());
                    }
                });
            }

            @Override
            public synchronized boolean isValidated() {
                return super.isValidated() && this.validVarName;
            }

            private void setFormuleEnabled(boolean b) {
                if (b) {
                    this.textValeur.setText("");
                } else {
                    this.textFormule.setText("");
                }
                this.textValeur.setEditable(!b);
                this.textValeur.setEnabled(!b);
                this.textFormule.setEditable(b);
                this.textFormule.setEnabled(b);
                this.treeVariable.setEnabled(b);
                this.treeVariable.setEditable(b);
            }

            private boolean isValidVarName() {
                String varName = this.textNom.getText();
                System.err.println("Verification de la validit\u00e9 du nom de la variable.");
                if (varName.length() == 0) {
                    System.err.println("--> nom vide");
                    this.labelImgWarningBadVar.setVisible(true);
                    this.labelWarningBadVar.setText(VAR_NO_NAME);
                    this.labelWarningBadVar.setVisible(true);
                    return false;
                }
                if (!this.isJavaVar(varName)) {
                    System.err.println("nom invalide");
                    this.labelImgWarningBadVar.setVisible(true);
                    this.labelWarningBadVar.setText(VAR_NAME_NOT_CORRECT);
                    this.labelWarningBadVar.setVisible(true);
                    return false;
                }
                SQLSelect selAllVarName = new SQLSelect(this.getTable().getBase());
                selAllVarName.addSelect(VariablePayeSQLElement.this.getTable().getField("ID"));
                Where w = new Where((FieldRef)VariablePayeSQLElement.this.getTable().getField("NOM"), "=", (Object)this.textNom.getText().trim());
                w = w.and(new Where((FieldRef)VariablePayeSQLElement.this.getTable().getKey(), "!=", this.getSelectedID()));
                selAllVarName.setWhere(w);
                String reqAllVarName = selAllVarName.asString();
                Object[] objKeysRowName = ((List)this.getTable().getBase().getDataSource().execute(reqAllVarName, new ArrayListHandler())).toArray();
                if (objKeysRowName.length > 0) {
                    this.labelImgWarningBadVar.setVisible(true);
                    this.labelWarningBadVar.setText(VAR_ALREADY_EXIST);
                    this.labelWarningBadVar.setVisible(true);
                    System.err.println("---------<<>>>>>>>  length > 0");
                    return false;
                }
                List<String> l = VariablePayeSQLElement.getForbiddenVarName();
                int i = 0;
                while (i < l.size()) {
                    if (l.get(i).toString().trim().compareToIgnoreCase(this.textNom.getText().trim()) == 0) {
                        this.labelImgWarningBadVar.setVisible(true);
                        this.labelWarningBadVar.setText(VAR_ALREADY_EXIST);
                        this.labelWarningBadVar.setVisible(true);
                        System.err.println("---------<<>>>>>>>  forbidenn var");
                        return false;
                    }
                    ++i;
                }
                this.labelImgWarningBadVar.setVisible(false);
                this.labelWarningBadVar.setVisible(false);
                this.textFormule.setVarAssign(this.textNom.getText());
                return true;
            }

            private boolean isJavaVar(String s) {
                if (s.charAt(0) >= '0' && s.charAt(0) <= '9') {
                    System.err.println("Erreur la variable commence par un chiffre!!");
                    return false;
                }
                int i = 0;
                while (i < s.length()) {
                    if (!(s.charAt(i) >= '0' && s.charAt(i) <= '9' || s.charAt(i) >= 'a' && s.charAt(i) <= 'z' || s.charAt(i) >= 'A' && s.charAt(i) <= 'Z' || s.charAt(i) == '_')) {
                        System.err.println("Erreur la variable contient un caractere incorrect!!");
                        return false;
                    }
                    ++i;
                }
                return !CTokenMarker.getKeywords().isExisting(s);
            }

            @Override
            public void select(SQLRowAccessor r) {
                super.select(r);
                if (r != null) {
                    if (r.getString("FORMULE").trim().length() == 0) {
                        this.radioVal.setSelected(true);
                        this.setFormuleEnabled(false);
                    } else {
                        this.radioFormule.setSelected(true);
                        this.setFormuleEnabled(true);
                    }
                    this.textFormule.setVarAssign(r.getString("NOM"));
                }
                this.validVarName = true;
                this.labelImgWarningBadVar.setVisible(false);
                this.labelWarningBadVar.setVisible(false);
            }
        };
    }

    @Override
    protected void archive(SQLRow row, boolean cutLinks) throws SQLException {
        this.secureArchiveVariable(row.getID());
    }

    private void secureArchiveVariable(int id) throws SQLException {
        SQLRow row = this.getTable().getRow(id);
        if (row != null) {
            SQLSelect sel = new SQLSelect(this.getTable().getBase());
            sel.addSelect(this.getTable().getField("ID"));
            System.err.println("Check variable");
            sel.setWhere("VARIABLE_PAYE.FORMULE", "LIKE", "%" + row.getString("NOM") + "%");
            sel.andWhere(new Where((FieldRef)this.getTable().getField("ID"), "!=", id));
            String req = sel.asString();
            List l = (List)this.getTable().getBase().getDataSource().execute(req, new ArrayListHandler());
            if (l.size() == 0) {
                super.archive(this.getTable().getRow(id));
            } else {
                System.err.println("Suppression impossible, cette variable est r\u00e9f\u00e9renc\u00e9e par une autre.");
                ExceptionHandler.handle("Suppression impossible, cette variable est r\u00e9f\u00e9renc\u00e9e par une autre.");
            }
        } else {
            super.archive(this.getTable().getRow(id), true);
        }
    }
}

