/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.finance.payment.ui.GestionChequesRenderer;
import org.openconcerto.erp.model.GestionChequesModel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.ui.JDate;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.TableSorter;

public class ListeDesChequesADecaisserPanel
extends JPanel {
    private GestionChequesModel model;
    private JLabel labelDecaisse = new JLabel("S\u00e9lectionner les ch\u00e9ques \u00e0 d\u00e9caisser, en date du ");
    private JDate dateDecaisse = new JDate();
    private JLabel labelMontant = new JLabel("");
    private JTable table;
    private TableSorter s;
    private EditFrame edit;
    private final JButton boutonValide = new JButton("Valider le d\u00e9caissement");
    private JCheckBox checkImpression = new JCheckBox("Impression du relev\u00e9");

    public ListeDesChequesADecaisserPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 1, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.anchor = 17;
        c.fill = 1;
        SQLTable tableChequeFournisseur = Configuration.getInstance().getDirectory().getElement("CHEQUE_FOURNISSEUR").getTable();
        SQLTable tableFourn = Configuration.getInstance().getDirectory().getElement("FOURNISSEUR").getTable();
        ArrayList<FieldRef> fields = new ArrayList<FieldRef>();
        fields.add(tableChequeFournisseur.getField("MONTANT"));
        fields.add(tableFourn.getField("TYPE"));
        fields.add(tableFourn.getField("NOM"));
        fields.add(tableChequeFournisseur.getField("ID_MOUVEMENT"));
        fields.add(tableChequeFournisseur.getField("DATE_ACHAT"));
        fields.add(tableChequeFournisseur.getField("DATE_MIN_DECAISSE"));
        fields.add(tableChequeFournisseur.getField("DECAISSE"));
        this.model = new GestionChequesModel(tableChequeFournisseur, fields, tableChequeFournisseur.getField("DECAISSE"), tableChequeFournisseur.getField("DATE_MIN_DECAISSE"));
        this.s = new TableSorter(this.model);
        this.table = new JTable(this.s);
        this.s.setTableHeader(this.table.getTableHeader());
        this.model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ListeDesChequesADecaisserPanel.this.setLabels();
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    ListeDesChequesADecaisserPanel.this.actionDroitTable(e);
                }
            }
        });
        this.model.selectionDecaisseAll();
        this.table.getColumnModel().getColumn(0).setCellRenderer(new GestionChequesRenderer(this.s));
        this.table.getColumnModel().getColumn(5).setCellRenderer(new GestionChequesRenderer(this.s));
        this.add((Component)new JScrollPane(this.table), c);
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        this.dateDecaisse.setValue(new Date());
        ++c.gridy;
        c.gridx = -1;
        c.gridwidth = 1;
        this.add((Component)this.labelDecaisse, c);
        c.gridwidth = 1;
        this.add((Component)this.dateDecaisse, c);
        c.gridwidth = 0;
        this.add((Component)this.labelMontant, c);
        JButton boutonSelectAll = new JButton("S\u00e9lectionner tous les ch\u00e8ques");
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        this.add((Component)boutonSelectAll, c);
        boutonSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeDesChequesADecaisserPanel.this.model.selectionDecaisseAll();
            }
        });
        ++c.gridx;
        this.add((Component)this.checkImpression, c);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        this.add((Component)this.boutonValide, c);
        this.boutonValide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeDesChequesADecaisserPanel.this.model.valideDepot(ListeDesChequesADecaisserPanel.this.dateDecaisse.getDate(), 1, ListeDesChequesADecaisserPanel.this.checkImpression.isSelected());
                ListeDesChequesADecaisserPanel.this.model.fireTableDataChanged();
            }
        });
        JButton buttonFermer = new JButton("Fermer");
        ++c.gridx;
        c.fill = 0;
        c.anchor = 13;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        this.add((Component)buttonFermer, c);
        buttonFermer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame frame = (JFrame)SwingUtilities.getRoot(ListeDesChequesADecaisserPanel.this);
                frame.setVisible(false);
                frame.dispose();
            }
        });
    }

    public GestionChequesModel getModel() {
        return this.model;
    }

    private void setLabels() {
        int nbChq = this.model.getNbChequeSelected();
        if (nbChq == 0) {
            this.labelDecaisse.setText("S\u00e9lectionner les ch\u00e9ques \u00e0 d\u00e9caisser, en date du ");
            this.labelMontant.setText("");
            this.boutonValide.setVisible(false);
            this.checkImpression.setVisible(false);
        } else {
            long montantTot = this.model.getMontantTotalSelected();
            this.boutonValide.setVisible(true);
            this.checkImpression.setVisible(true);
            if (nbChq == 1) {
                this.labelDecaisse.setText("D\u00e9caissement de " + nbChq + " ch\u00e9que, en date du ");
                this.labelMontant.setText(", pour un montant total de " + GestionDevise.currencyToString(montantTot) + " \u20ac");
            } else {
                this.labelDecaisse.setText("D\u00e9caissement de " + nbChq + " ch\u00e9ques, en date du ");
                this.labelMontant.setText(", pour un montant total de " + GestionDevise.currencyToString(montantTot) + " \u20ac");
            }
        }
    }

    private void actionDroitTable(MouseEvent mE) {
        JPopupMenu menuDroit = new JPopupMenu();
        final int row = this.table.getSelectedRow();
        AbstractAction abstractAction = new AbstractAction("Voir la source"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (row >= 0 && row < ListeDesChequesADecaisserPanel.this.table.getRowCount()) {
                    SQLElement chequeFournisseurElt = Configuration.getInstance().getDirectory().getElement("CHEQUE_FOURNISSEUR");
                    SQLTable tableCheque = chequeFournisseurElt.getTable();
                    SQLRow rowCheque = tableCheque.getRow(ListeDesChequesADecaisserPanel.this.model.getIdAtRow(ListeDesChequesADecaisserPanel.this.s.modelIndex(row)));
                    int idMouvement = rowCheque.getInt("ID_MOUVEMENT");
                    if (idMouvement > 1) {
                        MouvementSQLElement.showSource(idMouvement);
                    } else {
                        if (ListeDesChequesADecaisserPanel.this.edit == null) {
                            ListeDesChequesADecaisserPanel.this.edit = new EditFrame(chequeFournisseurElt, EditFrame.MODIFICATION);
                            ListeDesChequesADecaisserPanel.this.edit.pack();
                        }
                        ListeDesChequesADecaisserPanel.this.edit.selectionId(rowCheque.getID());
                        ListeDesChequesADecaisserPanel.this.edit.setVisible(true);
                    }
                }
            }
        };
        abstractAction.setEnabled(row >= 0 && row < this.table.getRowCount());
        menuDroit.add(abstractAction);
        menuDroit.add(new AbstractAction("S\u00e9lectionner tout"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeDesChequesADecaisserPanel.this.model.selectionDecaisseAll();
            }
        });
        menuDroit.add(new AbstractAction("D\u00e9s\u00e9lectionner tout"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeDesChequesADecaisserPanel.this.model.deselectionAll();
            }
        });
        menuDroit.show(mE.getComponent(), mE.getX(), mE.getY());
    }
}

