/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.component;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import org.openconcerto.erp.model.BanqueModifiedListener;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.component.ITextCombo;
import org.openconcerto.utils.CollectionUtils;

public class ModeDeReglementSQLComponent
extends BaseSQLComponent {
    private ElementComboBox boxBanque = new ElementComboBox(true, 20);
    private JPanel panelBanque = new JPanel(new GridBagLayout());
    private JPanel panelEcheance = new JPanel(new GridBagLayout());
    private final EventListenerList banqueModifiedListenerList = new EventListenerList();
    private final SQLRequestComboBox comboTypeReglement = new SQLRequestComboBox();
    private ITextCombo comboA;
    private ITextCombo comboLe = new SQLTextCombo();
    private ITextCombo comboBanque = new SQLTextCombo();
    private JRadioButton buttonFinMois = new JRadioButton("fin de mois");
    private JRadioButton buttonDateFacture = new JRadioButton("date de facturation");
    private JRadioButton buttonLe = new JRadioButton("le");
    private JCheckBox checkboxComptant = new JCheckBox("Comptant");
    private JDate dateDepot = new JDate(false);
    private JDate dateVirt = new JDate(false);
    private JDate dateCheque = new JDate(false);
    private JTextField numeroChq = new JTextField();
    private JTextField nom = new JTextField(30);
    private static final int MODE_VIRT = 3;
    private static final int MODE_CHEQUE = 2;
    private static final int MODE_ECHEANCE = 1;
    private JPanel panelActive = null;
    private Map<Integer, JPanel> m = new HashMap<Integer, JPanel>();
    private int rowIdMode;
    private JPanel infosCheque = new JPanel(new GridBagLayout());
    private JPanel infosVirt = new JPanel(new GridBagLayout());
    final ItemListener listenerComptant = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            ModeDeReglementSQLComponent.this.setEcheanceEnabled(!ModeDeReglementSQLComponent.this.checkboxComptant.isSelected());
        }
    };

    private void setComponentModeEnabled(SQLRow rowTypeRegl) {
        if (rowTypeRegl == null || this.rowIdMode == rowTypeRegl.getID()) {
            return;
        }
        this.rowIdMode = rowTypeRegl.getID();
        System.err.println("ModeDeReglementNGSQLComponent.setComponentModeEnabled() " + this.rowIdMode);
        ButtonGroup group = new ButtonGroup();
        group.add(this.buttonFinMois);
        group.add(this.buttonDateFacture);
        group.add(this.buttonLe);
        Boolean boolean1 = rowTypeRegl.getBoolean("ECHEANCE");
        Boolean boolean2 = rowTypeRegl.getBoolean("COMPTANT");
        this.checkboxComptant.setEnabled(boolean1 == false && boolean2 == false);
        if (boolean1.booleanValue()) {
            this.checkboxComptant.setSelected(false);
        }
        if (boolean2.booleanValue()) {
            this.checkboxComptant.setSelected(true);
        }
        this.setEcheanceEnabled(boolean2 == false);
        boolean chequeComptant = rowTypeRegl.getID() == 2 && this.checkboxComptant.isSelected();
        int mode = 1;
        if (chequeComptant) {
            mode = 2;
        } else {
            boolean virtComptant;
            boolean bl = virtComptant = rowTypeRegl.getID() == 5 && this.checkboxComptant.isSelected();
            if (virtComptant) {
                mode = 3;
            }
        }
        this.replacePanel(mode);
    }

    public ModeDeReglementSQLComponent(SQLElement elt) {
        super(elt);
    }

    @Override
    public void addViews() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 0;
        c.anchor = 17;
        this.comboA = new SQLTextCombo(false);
        ++c.gridy;
        c.gridheight = 1;
        this.add((Component)new JLabel("R\u00e8glement par"), c);
        this.comboTypeReglement.setPreferredSize(new Dimension(80, new JTextField().getPreferredSize().height));
        DefaultGridBagConstraints.lockMinimumSize(this.comboTypeReglement);
        ++c.gridx;
        c.fill = 2;
        this.add((Component)this.comboTypeReglement, c);
        c.gridheight = 1;
        ++c.gridx;
        DefaultGridBagConstraints.lockMinimumSize(this.checkboxComptant);
        this.add((Component)this.checkboxComptant, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridwidth = 3;
        c.fill = 2;
        c.gridheight = 0;
        this.createPanelChequeComptant();
        this.add((Component)this.infosCheque, c);
        this.createPanelVirementComptant();
        this.add((Component)this.infosVirt, c);
        this.createPanelEcheance();
        this.add((Component)this.panelEcheance, c);
        this.addSQLObject(this.comboBanque, "ETS");
        this.addSQLObject(this.dateCheque, "DATE");
        this.addSQLObject(this.numeroChq, "NUMERO");
        this.addSQLObject(this.nom, "NOM");
        this.addRequiredSQLObject(this.comboA, "AJOURS");
        this.addRequiredSQLObject(this.comboLe, "LENJOUR");
        this.addSQLObject(this.buttonFinMois, "FIN_MOIS");
        this.addSQLObject(this.buttonDateFacture, "DATE_FACTURE");
        this.addSQLObject(this.dateDepot, "DATE_DEPOT");
        this.addSQLObject(this.dateVirt, "DATE_VIREMENT");
        this.addSQLObject(this.checkboxComptant, "COMPTANT");
        this.addRequiredSQLObject(this.comboTypeReglement, "ID_TYPE_REGLEMENT");
        this.comboTypeReglement.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Integer id = ModeDeReglementSQLComponent.this.comboTypeReglement.getValue();
                if (id != null && id > 1) {
                    SQLRow ligneTypeReg = SQLBackgroundTableCache.getInstance().getCacheForTable(ModeDeReglementSQLComponent.this.getTable().getBase().getTable("TYPE_REGLEMENT")).getRowFromId(id);
                    ModeDeReglementSQLComponent.this.setComponentModeEnabled(ligneTypeReg);
                }
            }
        });
        this.buttonFinMois.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ModeDeReglementSQLComponent.this.buttonFinMois.isSelected()) {
                    ModeDeReglementSQLComponent.this.comboLe.setValue("31");
                }
                boolean activeComboLe = !ModeDeReglementSQLComponent.this.buttonFinMois.isSelected() && !ModeDeReglementSQLComponent.this.checkboxComptant.isSelected();
                ModeDeReglementSQLComponent.this.comboLe.setEnabled(activeComboLe);
            }
        });
        this.buttonDateFacture.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ModeDeReglementSQLComponent.this.buttonDateFacture.isSelected()) {
                    ModeDeReglementSQLComponent.this.comboLe.setValue("0");
                }
                boolean activeComboLe = !ModeDeReglementSQLComponent.this.buttonDateFacture.isSelected() && !ModeDeReglementSQLComponent.this.checkboxComptant.isSelected();
                ModeDeReglementSQLComponent.this.comboLe.setEnabled(activeComboLe);
            }
        });
        this.checkboxComptant.addItemListener(this.listenerComptant);
    }

    private void createPanelEcheance() {
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 0;
        this.panelEcheance.setOpaque(false);
        this.panelEcheance.add((Component)new JLabel("A"), c);
        ++c.gridx;
        c.gridwidth = 1;
        this.comboA.setMinimumSize(new Dimension(60, this.comboA.getMinimumSize().height));
        this.comboA.setPreferredSize(new Dimension(60, this.comboA.getMinimumSize().height));
        this.comboA.setMaximumSize(new Dimension(60, this.comboA.getMinimumSize().height));
        this.panelEcheance.add((Component)this.comboA, c);
        ++c.gridx;
        c.gridwidth = 1;
        this.panelEcheance.add((Component)new JLabel("jours,"), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 2;
        c.fill = 2;
        this.buttonDateFacture.setOpaque(false);
        this.panelEcheance.add((Component)this.buttonDateFacture, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 0;
        this.buttonFinMois.setOpaque(false);
        this.panelEcheance.add((Component)this.buttonFinMois, c);
        ++c.gridy;
        c.gridwidth = 1;
        this.buttonLe.setOpaque(false);
        this.panelEcheance.add((Component)this.buttonLe, c);
        ++c.gridx;
        this.comboLe.setMinimumSize(new Dimension(60, this.comboLe.getMinimumSize().height));
        this.comboLe.setPreferredSize(new Dimension(60, this.comboLe.getMinimumSize().height));
        this.comboLe.setMaximumSize(new Dimension(60, this.comboLe.getMinimumSize().height));
        this.panelEcheance.add((Component)this.comboLe, c);
        this.panelActive = this.panelEcheance;
        this.m.put(1, this.panelEcheance);
        DefaultGridBagConstraints.lockMinimumSize(this.panelEcheance);
    }

    public void createPanelChequeComptant() {
        DefaultGridBagConstraints cCheque = new DefaultGridBagConstraints();
        this.infosCheque.add((Component)new JLabel("Banque"), cCheque);
        ++cCheque.gridx;
        this.infosCheque.add((Component)this.comboBanque, cCheque);
        ++cCheque.gridx;
        this.infosCheque.add((Component)new JLabel("N\u00b0"), cCheque);
        ++cCheque.gridx;
        DefaultGridBagConstraints.lockMinimumSize(this.numeroChq);
        this.infosCheque.add((Component)this.numeroChq, cCheque);
        ++cCheque.gridy;
        cCheque.gridx = 0;
        this.infosCheque.add((Component)new JLabel("Dat\u00e9 du"), cCheque);
        ++cCheque.gridx;
        this.infosCheque.add((Component)this.dateCheque, cCheque);
        JLabel labelDepot = new JLabel("A d\u00e9poser apr\u00e8s le");
        ++cCheque.gridx;
        DefaultGridBagConstraints.lockMinimumSize(this.infosCheque);
        this.infosCheque.add((Component)labelDepot, cCheque);
        ++cCheque.gridx;
        this.infosCheque.add((Component)this.dateDepot, cCheque);
        this.m.put(2, this.infosCheque);
        this.infosCheque.setVisible(false);
        DefaultGridBagConstraints.lockMinimumSize(this.infosCheque);
    }

    public void createPanelVirementComptant() {
        DefaultGridBagConstraints cCheque = new DefaultGridBagConstraints();
        cCheque.weightx = 1.0;
        this.infosVirt.add((Component)new JLabel("Libell\u00e9"), cCheque);
        ++cCheque.gridx;
        this.infosVirt.add((Component)this.nom, cCheque);
        ++cCheque.gridy;
        cCheque.gridx = 0;
        cCheque.fill = 0;
        cCheque.weightx = 0.0;
        this.infosVirt.add((Component)new JLabel("Dat\u00e9 du"), cCheque);
        ++cCheque.gridx;
        this.infosVirt.add((Component)this.dateVirt, cCheque);
        this.m.put(3, this.infosVirt);
        this.infosVirt.setVisible(false);
        DefaultGridBagConstraints.lockMinimumSize(this.infosVirt);
    }

    private void replacePanel(int mode) {
        JPanel panel = this.m.get(mode);
        if (panel != this.panelActive) {
            this.panelActive.setVisible(false);
            this.clearFields();
            panel.setVisible(true);
            this.panelActive = panel;
        }
    }

    private void clearFields() {
        System.err.println("ModeDeReglementNGSQLComponent.clearFields()");
        this.dateCheque.setValue(null);
        this.dateDepot.setValue(null);
        this.dateVirt.setValue(null);
        this.nom.setText("");
        this.numeroChq.setText("");
        this.comboBanque.setValue("");
    }

    private void fireBanqueIdChange(int id) {
        BanqueModifiedListener[] l;
        BanqueModifiedListener[] banqueModifiedListenerArray = l = (BanqueModifiedListener[])this.banqueModifiedListenerList.getListeners(BanqueModifiedListener.class);
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            BanqueModifiedListener banqueModifiedListener = banqueModifiedListenerArray[n2];
            banqueModifiedListener.idChange(id);
            ++n2;
        }
    }

    @Override
    public void select(SQLRowAccessor r) {
        if (r != null) {
            SQLRowValues rVals = r.asRowValues();
            SQLRowValues vals = new SQLRowValues(r.getTable());
            this.checkboxComptant.removeItemListener(this.listenerComptant);
            vals.load(rVals, CollectionUtils.createSet("ID_TYPE_REGLEMENT", "COMPTANT"));
            vals.setID(rVals.getID());
            super.select(vals);
            this.comboTypeReglement.setValue(vals.getInt("ID_TYPE_REGLEMENT"));
            this.checkboxComptant.setSelected(vals.getBoolean("COMPTANT"));
            this.setComponentModeEnabled(SQLBackgroundTableCache.getInstance().getCacheForTable(r.getTable().getTable("TYPE_REGLEMENT")).getRowFromId(vals.getInt("ID_TYPE_REGLEMENT")));
            this.setEcheanceEnabled(vals.getBoolean("COMPTANT") == false, vals.getInt("ID_TYPE_REGLEMENT"));
            super.select(rVals);
            if (rVals.getInt("LENJOUR") != 0 && rVals.getInt("LENJOUR") != 31) {
                this.buttonLe.setSelected(true);
            }
            this.checkboxComptant.addItemListener(this.listenerComptant);
        } else {
            super.select(r);
        }
    }

    private void setEcheanceEnabled(boolean b) {
        this.setEcheanceEnabled(b, this.comboTypeReglement.getValue());
    }

    private void setEcheanceEnabled(boolean b, Integer typeReglt) {
        this.comboA.setEnabled(b);
        this.comboLe.setEnabled(b);
        this.buttonFinMois.setEnabled(b);
        this.buttonDateFacture.setEnabled(b);
        this.buttonLe.setEnabled(b);
        if (!b) {
            this.buttonLe.setSelected(true);
            this.comboA.setValue("0");
            this.comboLe.setValue("0");
        } else {
            this.comboA.setValue("30");
            this.buttonDateFacture.setSelected(true);
        }
        if (typeReglt != null) {
            boolean chequeComptant = typeReglt == 2 && !b;
            int mode = 1;
            if (chequeComptant) {
                mode = 2;
            } else {
                boolean virtComptant;
                boolean bl = virtComptant = typeReglt == 5 && !b;
                if (virtComptant) {
                    mode = 3;
                }
            }
            this.replacePanel(mode);
        }
        this.panelActive.revalidate();
        this.panelActive.repaint();
    }

    @Override
    protected SQLRowValues createDefaults() {
        SQLRowValues vals = new SQLRowValues(this.getTable());
        vals.put("AJOURS", 30);
        vals.put("LENJOUR", 31);
        this.buttonLe.setSelected(true);
        return vals;
    }

    public void setWhereBanque(Where w) {
        ComboSQLRequest request;
        if (this.boxBanque != null && this.boxBanque.isShowing() && (request = this.boxBanque.getRequest()) != null) {
            request.setWhere(w);
            this.boxBanque.fillCombo();
        }
    }

    public void setSelectedIdBanque(int id) {
        this.boxBanque.setValue(id);
    }

    public int getSelectedIdBanque() {
        return this.boxBanque.getSelectedId();
    }

    public void addBanqueModifiedListener(BanqueModifiedListener e) {
        this.banqueModifiedListenerList.add(BanqueModifiedListener.class, e);
    }
}

