/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.action;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.core.sales.invoice.report.VenteFactureXmlSheet;
import org.openconcerto.erp.generationDoc.gestcomm.FicheRelanceSheet;
import org.openconcerto.erp.generationDoc.gestcomm.RelanceSheet;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelColumnPath;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;

public class ListeDesRelancesAction
extends CreateFrameAbstractAction
implements MouseListener {
    private IListFrame frame;

    public ListeDesRelancesAction() {
        this.putValue("Name", "Liste des relances");
    }

    @Override
    public JFrame createFrame() {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("RELANCE");
        this.frame = new IListFrame(new ListeAddPanel(elt));
        SQLTableModelSourceOnline src = (SQLTableModelSourceOnline)this.frame.getPanel().getListe().getModel().getReq();
        this.frame.getPanel().getListe().setSQLEditable(true);
        for (SQLTableModelColumn column : src.getColumns()) {
            if (!column.getClass().isAssignableFrom(SQLTableModelColumnPath.class)) continue;
            ((SQLTableModelColumnPath)column).setEditable(false);
        }
        ((SQLTableModelColumnPath)src.getColumns(elt.getTable().getField("INFOS")).iterator().next()).setEditable(true);
        this.frame.getPanel().getListe().getJTable().addMouseListener(this);
        this.frame.getPanel().setAddVisible(false);
        return this.frame;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int selectedId = this.frame.getPanel().getListe().getSelectedId();
        if (selectedId > 1 && e.getButton() == 3) {
            final SQLRow rowRelance = this.frame.getPanel().getListe().getSelectedRow();
            JPopupMenu menu = new JPopupMenu();
            final RelanceSheet s = new RelanceSheet(rowRelance);
            AbstractAction actionOpen = new AbstractAction("Voir le document"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    s.generate(false, false, "");
                    s.showDocument();
                }
            };
            menu.add(actionOpen);
            AbstractAction actionPrint = new AbstractAction("Imprimer"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    s.fastPrintDocument();
                }
            };
            menu.add(actionPrint);
            AbstractAction actionPrintFact = new AbstractAction("Imprimer la facture"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VenteFactureXmlSheet sheet = new VenteFactureXmlSheet(rowRelance.getForeignRow("ID_SAISIE_VENTE_FACTURE"));
                    if (sheet.getFileODS().exists()) {
                        sheet.fastPrintDocument();
                    } else {
                        sheet.genere(false, true);
                    }
                }
            };
            menu.add(actionPrintFact);
            AbstractAction actionPrintBoth = new AbstractAction("Imprimer la facture et la relance"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    s.fastPrintDocument();
                    VenteFactureXmlSheet sheet = new VenteFactureXmlSheet(rowRelance.getForeignRow("ID_SAISIE_VENTE_FACTURE"));
                    if (sheet.getFileODS().exists()) {
                        sheet.fastPrintDocument();
                    } else {
                        sheet.genere(false, true);
                    }
                }
            };
            menu.add(actionPrintBoth);
            menu.add(new AbstractAction("G\u00e9n\u00e9rer"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String printer = PrinterNXProps.getInstance().getStringProperty("RelancePrinter");
                    s.generate(false, true, printer, true);
                }
            });
            menu.add(new AbstractAction("Cr\u00e9er la fiche de relance"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FicheRelanceSheet sheet = new FicheRelanceSheet(rowRelance);
                    sheet.genere(true, false);
                }
            });
            menu.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

