/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.report.Map2033B;
import org.openconcerto.erp.preferences.TemplateNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.FileUtils;

public class ResultatPanel
extends JPanel {
    public ResultatPanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.add((Component)new JLabel("Vous allez g\u00e9n\u00e9rer le fichier result_2033B.pdf contenant le r\u00e9sultat."), c);
        ++c.gridy;
        try {
            this.add((Component)new JLabel("Il se trouvera dans le dossier " + new File(TemplateNXProps.getInstance().getStringProperty("Location2033BPDF")).getCanonicalPath()), c);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        JButton buttonFermer = new JButton("Fermer");
        buttonFermer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ((JFrame)SwingUtilities.getRoot(ResultatPanel.this)).dispose();
            }
        });
        JButton buttonOuvrir = new JButton("Ouvrir dossier");
        buttonOuvrir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String file = TemplateNXProps.getInstance().getStringProperty("Location2033BPDF");
                File f = new File(file);
                FileUtils.browseFile(f);
            }
        });
        JButton buttonGenerer = new JButton("G\u00e9n\u00e9rer");
        buttonGenerer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Map2033B map = new Map2033B(new JProgressBar());
                map.generateMap();
            }
        });
        c.gridx = -1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        this.add((Component)buttonOuvrir, c);
        ++c.gridy;
        c.anchor = 13;
        c.weightx = 1.0;
        buttonGenerer.setHorizontalAlignment(4);
        this.add((Component)buttonGenerer, c);
        c.weightx = 0.0;
        this.add((Component)buttonFermer, c);
    }

    public static long getResultatValue() {
        long soldeVente = 0L;
        long soldeAchat = 0L;
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable compteTable = base.getTable("COMPTE_PCE");
        SQLTable ecritureTable = base.getTable("ECRITURE");
        SQLSelect selAchat = new SQLSelect(base);
        SQLSelect selVente = new SQLSelect(base);
        selAchat.addSelect(ecritureTable.getField("DEBIT"), "SUM");
        selAchat.addSelect(ecritureTable.getField("CREDIT"), "SUM");
        selVente.addSelect(ecritureTable.getField("DEBIT"), "SUM");
        selVente.addSelect(ecritureTable.getField("CREDIT"), "SUM");
        Where where = new Where((FieldRef)ecritureTable.getField("ID_COMPTE_PCE"), "=", compteTable.getField("ID"));
        Where wVente = new Where((FieldRef)compteTable.getField("NUMERO"), "LIKE", (Object)"7%");
        Where wAchat = new Where((FieldRef)compteTable.getField("NUMERO"), "LIKE", (Object)"6%");
        selAchat.setWhere(where.and(wAchat));
        selVente.setWhere(where.and(wVente));
        String reqAchat = selAchat.asString();
        String reqVente = selVente.asString();
        Object obAchat = base.getDataSource().execute(reqAchat, new ArrayListHandler());
        Object obVente = base.getDataSource().execute(reqVente, new ArrayListHandler());
        List myListAchat = (List)obAchat;
        int achatsCount = myListAchat.size();
        int i = 0;
        while (i < achatsCount) {
            Object[] objTmp = (Object[])myListAchat.get(i);
            soldeAchat += (Long)objTmp[0] - (Long)objTmp[1];
            ++i;
        }
        List myListVente = (List)obVente;
        int ventesCount = myListVente.size();
        int i2 = 0;
        while (i2 < ventesCount) {
            Object[] objTmp = (Object[])myListVente.get(i2);
            soldeVente += (Long)objTmp[1] - (Long)objTmp[0];
            ++i2;
        }
        return soldeVente - soldeAchat;
    }
}

