/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.MaskFormatter;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.DeviseNiceTableCellRenderer;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.finance.accounting.model.LettrageModel;
import org.openconcerto.erp.core.finance.accounting.ui.ListPanelEcritures;
import org.openconcerto.erp.core.finance.accounting.ui.PointageRenderer;
import org.openconcerto.erp.model.ISQLCompteSelector;
import org.openconcerto.erp.rights.ComptaUserRight;
import org.openconcerto.erp.utils.UpperCaseFormatFilter;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.warning.JLabelWarning;
import org.openconcerto.utils.text.DocumentFilterList;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class LettragePanel
extends JPanel {
    private ListPanelEcritures ecriturePanel;
    private JTextField codeLettrage;
    private ISQLCompteSelector selCompte;
    private JCheckBox boxValidEcriture;
    private JCheckBox boxAddSousCompte;
    private JPanel warningPanel;
    private JPanel warningSolde;
    private final SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
    private final SQLTable tableEcr = this.base.getTable("ECRITURE");
    private final SQLTable tableComptePCE = this.base.getTable("COMPTE_PCE");
    private static final int allEcriture = 0;
    private static final int ecritureLettree = 1;
    private static final int ecritureNonLettree = 2;
    private int modeSelect;
    private LettrageModel model;
    private JButton buttonLettrer;
    private JDate dateDeb;
    private JDate dateFin;
    private JDate dateLettrage;

    public LettragePanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.modeSelect = 0;
        JLabel labelPointageCompte = new JLabel("Lettrage du compte");
        labelPointageCompte.setHorizontalAlignment(4);
        this.add((Component)labelPointageCompte, c);
        this.selCompte = new ISQLCompteSelector();
        this.selCompte.init();
        this.selCompte.setValue(ComptePCESQLElement.getId("5"));
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.add((Component)this.selCompte, c);
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 1, 2);
        TitledSeparator sepGestionLettrage = new TitledSeparator("Gestion du lettrage");
        c.fill = 2;
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 0;
        this.add((Component)sepGestionLettrage, c);
        JLabel labelCode = new JLabel("Code lettrage");
        labelCode.setHorizontalAlignment(4);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.add((Component)labelCode, c);
        this.codeLettrage = new JTextField(10);
        DocumentFilterList.add((AbstractDocument)this.codeLettrage.getDocument(), new UpperCaseFormatFilter(), DocumentFilterList.FilterType.SIMPLE_FILTER);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.codeLettrage, c);
        this.codeLettrage.setText(NumerotationAutoSQLElement.getNextCodeLettrage());
        this.createPanelWarning();
        c.gridwidth = 0;
        c.weightx = 0.0;
        ++c.gridx;
        this.add((Component)this.warningPanel, c);
        JLabel labelDate = new JLabel("Date");
        labelDate.setHorizontalAlignment(4);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.add((Component)labelDate, c);
        this.dateLettrage = new JDate(true);
        ++c.gridx;
        this.add((Component)this.dateLettrage, c);
        ++c.gridx;
        this.createPanelWarningSolde();
        c.gridwidth = 0;
        c.weightx = 0.0;
        this.add((Component)this.warningSolde, c);
        c.gridwidth = 1;
        TitledSeparator sepPeriode = new TitledSeparator("Filtre ");
        ++c.gridy;
        c.gridx = 0;
        c.anchor = 17;
        c.gridwidth = 0;
        c.fill = 2;
        this.add((Component)sepPeriode, c);
        JPanel panelSelectEcritures = this.createPanelSelectionEcritures();
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        JLabel labelEcr = new JLabel("Ecritures");
        labelEcr.setHorizontalAlignment(4);
        this.add((Component)labelEcr, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.fill = 0;
        this.add((Component)panelSelectEcritures, c);
        JPanel panelPeriode = new JPanel();
        this.dateDeb = new JDate();
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        JLabel labelPerio = new JLabel("P\u00e9riode du ");
        labelPerio.setHorizontalAlignment(4);
        c.fill = 2;
        this.add((Component)labelPerio, c);
        panelPeriode.add(this.dateDeb);
        this.dateDeb.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LettragePanel.this.changeListRequest();
            }
        });
        this.dateFin = new JDate(true);
        panelPeriode.add(new JLabel("au"));
        this.dateFin.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LettragePanel.this.changeListRequest();
            }
        });
        panelPeriode.add(this.dateFin);
        ++c.gridx;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.fill = 0;
        this.add((Component)panelPeriode, c);
        c.gridx = 0;
        ++c.gridy;
        this.boxAddSousCompte = new JCheckBox("Ajouter les sous comptes");
        this.boxAddSousCompte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LettragePanel.this.changeListRequest();
            }
        });
        this.add((Component)this.boxAddSousCompte, c);
        TitledSeparator sepEcriture = new TitledSeparator("Ecritures ");
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.fill = 2;
        this.add((Component)sepEcriture, c);
        EcritureSQLElement ecritureElem = Configuration.getInstance().getDirectory().getElement(EcritureSQLElement.class);
        this.ecriturePanel = new ListPanelEcritures((SQLElement)ecritureElem, new IListe(ecritureElem.createLettrageTableSource()));
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 1;
        c.gridwidth = 0;
        this.ecriturePanel.getListe().setPreferredSize(new Dimension(this.ecriturePanel.getListe().getPreferredSize().width, 200));
        this.add((Component)this.ecriturePanel, c);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.fill = 1;
        c.gridwidth = 3;
        c.gridheight = 3;
        this.model = new LettrageModel(this.selCompte.getSelectedId());
        JTable table = new JTable(this.model);
        int i = 0;
        while (i < table.getColumnCount()) {
            table.getColumnModel().getColumn(i).setCellRenderer(new DeviseNiceTableCellRenderer());
            ++i;
        }
        JScrollPane sPane = new JScrollPane(table);
        Dimension d = new Dimension(table.getPreferredSize().width, table.getPreferredSize().height + table.getTableHeader().getPreferredSize().height + 4);
        sPane.setPreferredSize(d);
        this.add((Component)sPane, c);
        c.gridx = 4;
        c.gridwidth = 1;
        c.anchor = 13;
        c.fill = 0;
        c.weightx = 0.0;
        this.add((Component)this.createPanelLegende(), c);
        c.gridheight = 1;
        final JButton buttonDelettrer = new JButton("D\u00e9lettrer");
        this.buttonLettrer = new JButton("Lettrer");
        this.boxValidEcriture = new JCheckBox("Valider les \u00e9critures lettr\u00e9es");
        ++c.gridx;
        c.gridwidth = 0;
        this.add((Component)this.boxValidEcriture, c);
        JPanel panelButton = new JPanel();
        panelButton.add((Component)this.buttonLettrer, c);
        panelButton.add((Component)buttonDelettrer, c);
        ++c.gridy;
        c.gridx = 5;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.fill = 0;
        c.anchor = 13;
        this.add((Component)panelButton, c);
        ++c.gridy;
        c.anchor = 14;
        JButton buttonClose = new JButton("Fermer");
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Window)SwingUtilities.getRoot((Component)e.getSource())).dispose();
            }
        });
        this.add((Component)buttonClose, c);
        this.buttonLettrer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rowIndex = LettragePanel.this.ecriturePanel.getListe().getJTable().getSelectedRows();
                LettragePanel.this.actionLettrage(rowIndex);
            }
        });
        buttonDelettrer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rowIndex = LettragePanel.this.ecriturePanel.getListe().getJTable().getSelectedRows();
                LettragePanel.this.actionDelettrage(rowIndex);
            }
        });
        this.selCompte.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LettragePanel.this.changeListRequest();
            }
        });
        this.addActionMenuDroit();
        this.ecriturePanel.getListe().getJTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                System.err.println("Mouse released");
                int[] selectedRows = LettragePanel.this.ecriturePanel.getListe().getJTable().getSelectedRows();
                int[] idRows = new int[selectedRows.length];
                int i = 0;
                while (i < idRows.length) {
                    idRows[i] = LettragePanel.this.ecriturePanel.getListe().idFromIndex(selectedRows[i]);
                    ++i;
                }
                LettragePanel.this.model.updateSelection(idRows);
                LettragePanel.this.warningSolde.setVisible(LettragePanel.this.model.getSoldeSelection() != 0L);
                buttonDelettrer.setEnabled(LettragePanel.this.model.getSoldeSelection() == 0L);
                LettragePanel.this.buttonLettrer.setEnabled(LettragePanel.this.model.getSoldeSelection() == 0L);
            }
        });
        this.ecriturePanel.getListe().getJTable().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                System.err.println("Key released");
                int[] selectedRows = LettragePanel.this.ecriturePanel.getListe().getJTable().getSelectedRows();
                int[] idRows = new int[selectedRows.length];
                int i = 0;
                while (i < idRows.length) {
                    idRows[i] = LettragePanel.this.ecriturePanel.getListe().idFromIndex(selectedRows[i]);
                    ++i;
                }
                LettragePanel.this.model.updateSelection(idRows);
                LettragePanel.this.warningPanel.setVisible(LettragePanel.this.codeLettrage.getText().trim().length() == 0);
                LettragePanel.this.warningSolde.setVisible(LettragePanel.this.model.getSoldeSelection() != 0L);
            }
        });
        this.codeLettrage.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                LettragePanel.this.warningPanel.setVisible(LettragePanel.this.codeLettrage.getText().trim().length() == 0);
                LettragePanel.this.buttonLettrer.setEnabled(LettragePanel.this.codeLettrage.getText().trim().length() != 0);
            }
        });
        this.changeListRequest();
        this.warningPanel.setVisible(this.codeLettrage.getText().trim().length() == 0);
        this.buttonLettrer.setEnabled(this.codeLettrage.getText().trim().length() != 0);
    }

    private void addActionMenuDroit() {
        this.ecriturePanel.getListe().addRowAction(new AbstractAction("Voir la source"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow rowEcr = LettragePanel.this.ecriturePanel.getListe().getSelectedRow();
                MouvementSQLElement.showSource(rowEcr.getInt("ID_MOUVEMENT"));
            }
        });
        final AbstractAction abstractAction = new AbstractAction("Lettrer"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rowIndex = LettragePanel.this.ecriturePanel.getListe().getJTable().getSelectedRows();
                LettragePanel.this.actionLettrage(rowIndex);
            }
        };
        this.ecriturePanel.getListe().addRowAction(abstractAction);
        this.codeLettrage.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                abstractAction.setEnabled(LettragePanel.this.codeLettrage.getText().trim().length() > 0);
            }
        });
        this.ecriturePanel.getListe().addRowAction(new AbstractAction("D\u00e9lettrer"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rowIndex = LettragePanel.this.ecriturePanel.getListe().getJTable().getSelectedRows();
                LettragePanel.this.actionDelettrage(rowIndex);
            }
        });
    }

    private void createPanelWarning() {
        this.warningPanel = new JPanel();
        this.warningPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        JLabelWarning warningNoCodeImg = new JLabelWarning();
        warningNoCodeImg.setHorizontalAlignment(4);
        this.warningPanel.add((Component)warningNoCodeImg, c);
        JLabel warningNoCodeText = new JLabel("Impossible de lettrer tant que le code de lettrage n'est pas saisi!");
        ++c.gridx;
        this.warningPanel.add((Component)warningNoCodeText, c);
    }

    private void createPanelWarningSolde() {
        this.warningSolde = new JPanel();
        this.warningSolde.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        JLabelWarning warningNoCodeImg = new JLabelWarning();
        warningNoCodeImg.setHorizontalAlignment(4);
        this.warningSolde.add((Component)warningNoCodeImg, c);
        JLabel warningNoCodeText = new JLabel("Impossible de lettrer tant que le solde s\u00e9lectionn\u00e9 n'est pas nul!");
        ++c.gridx;
        this.warningSolde.add((Component)warningNoCodeText, c);
    }

    private void actionLettrage(int[] rowIndex) {
        String codeLettre = this.codeLettrage.getText().trim();
        ArrayList<SQLRow> rowsSelected = new ArrayList<SQLRow>(rowIndex.length);
        long solde = 0L;
        int i = 0;
        while (i < rowIndex.length) {
            int id = this.ecriturePanel.getListe().idFromIndex(rowIndex[i]);
            SQLRow row = this.tableEcr.getRow(id);
            rowsSelected.add(row);
            solde += ((Long)row.getObject("DEBIT")).longValue();
            solde -= ((Long)row.getObject("CREDIT")).longValue();
            ++i;
        }
        if (solde == 0L) {
            for (SQLRow row2 : rowsSelected) {
                SQLRowValues rowVals = new SQLRowValues(this.tableEcr);
                if (codeLettre.length() <= 0) continue;
                if (this.boxValidEcriture.isSelected() && !row2.getBoolean("VALIDE").booleanValue()) {
                    EcritureSQLElement.validationEcritures(row2.getInt("ID_MOUVEMENT"));
                }
                rowVals.put("LETTRAGE", codeLettre);
                rowVals.put("DATE_LETTRAGE", this.dateLettrage.getDate());
                try {
                    rowVals.update(row2.getID());
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
            SQLElement elt = Configuration.getInstance().getDirectory().getElement("NUMEROTATION_AUTO");
            SQLRowValues rowVals = elt.getTable().getRow(2).createEmptyUpdateRow();
            rowVals.put("CODE_LETTRAGE", codeLettre);
            try {
                rowVals.update();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.codeLettrage.setText(NumerotationAutoSQLElement.getNextCodeLettrage());
            this.model.updateTotauxCompte();
        }
    }

    protected MaskFormatter createFormatter() {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter("UUU");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return formatter;
    }

    private void actionDelettrage(int[] rowIndex) {
        ArrayList<SQLRow> rowsSelected = new ArrayList<SQLRow>(rowIndex.length);
        long solde = 0L;
        int i = 0;
        while (i < rowIndex.length) {
            int id = this.ecriturePanel.getListe().idFromIndex(rowIndex[i]);
            SQLRow row = this.tableEcr.getRow(id);
            rowsSelected.add(row);
            solde += ((Long)row.getObject("DEBIT")).longValue();
            solde -= ((Long)row.getObject("CREDIT")).longValue();
            ++i;
        }
        if (solde == 0L) {
            for (SQLRow row : rowsSelected) {
                SQLRowValues rowVals = new SQLRowValues(this.tableEcr);
                if (row.getString("LETTRAGE").trim().length() == 0) continue;
                rowVals.put("LETTRAGE", "");
                rowVals.put("DATE_LETTRAGE", null);
                try {
                    rowVals.update(row.getID());
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }
        this.model.updateTotauxCompte();
    }

    private void changeListRequest() {
        Integer idCpt = this.selCompte.getSelectedId();
        SQLRow row = this.tableComptePCE.getRow(Integer.valueOf(((Object)idCpt).toString()));
        Where w = new Where((FieldRef)this.tableEcr.getField("ID_COMPTE_PCE"), "=", this.tableComptePCE.getKey());
        if (!UserManager.getInstance().getCurrentUser().getRights().haveRight(ComptaUserRight.ACCES_NOT_RESCTRICTED_TO_411)) {
            w = w.and(new Where((FieldRef)this.tableEcr.getField("COMPTE_NUMERO"), "LIKE", (Object)"411%"));
        }
        if (row != null) {
            String num = row.getString("NUMERO");
            Where w2 = this.boxAddSousCompte.isSelected() ? new Where((FieldRef)this.tableComptePCE.getField("NUMERO"), "LIKE", (Object)(String.valueOf(num) + "%")) : new Where((FieldRef)this.tableComptePCE.getField("NUMERO"), "=", (Object)num);
            w = w.and(w2);
        } else {
            w = w.and(new Where((FieldRef)this.tableComptePCE.getKey(), "=", (Object)idCpt));
        }
        Date d1 = this.dateDeb.getValue();
        Date d2 = this.dateFin.getValue();
        if (d1 == null && d2 != null) {
            w = w.and(new Where((FieldRef)this.tableEcr.getField("DATE"), "<=", (Object)d2));
        } else if (d1 != null && d2 == null) {
            w = w.and(new Where((FieldRef)this.tableEcr.getField("DATE"), ">=", (Object)d1));
        } else if (d1 != null && d2 != null) {
            w = w.and(new Where((FieldRef)this.tableEcr.getField("DATE"), d1, (Object)d2));
        }
        if (this.modeSelect == 1) {
            w = w.and(new Where((FieldRef)this.tableEcr.getField("LETTRAGE"), "!=", (Object)""));
        } else if (this.modeSelect == 2) {
            Where wLettre = new Where((FieldRef)this.tableEcr.getField("LETTRAGE"), "=", (Object)"");
            Object s = null;
            wLettre = wLettre.or(new Where((FieldRef)this.tableEcr.getField("LETTRAGE"), "=", (Object)s));
            w = w.and(wLettre);
        }
        this.ecriturePanel.getListe().getRequest().setWhere(w);
        this.ecriturePanel.getListe().setSQLEditable(false);
        this.model.setIdCompte(Integer.parseInt(((Object)idCpt).toString()));
    }

    private JPanel createPanelSelectionEcritures() {
        JPanel panelSelectEcritures = new JPanel();
        GridBagConstraints cPanel = new GridBagConstraints();
        cPanel.anchor = 18;
        cPanel.fill = 2;
        cPanel.gridheight = 1;
        cPanel.gridwidth = 1;
        cPanel.gridx = 0;
        cPanel.gridy = 0;
        cPanel.weightx = 0.0;
        cPanel.weighty = 0.0;
        panelSelectEcritures.setLayout(new GridBagLayout());
        final JRadioButton buttonBoth = new JRadioButton("Toutes");
        panelSelectEcritures.add((Component)buttonBoth, cPanel);
        ++cPanel.gridx;
        final JRadioButton buttonNonLettre = new JRadioButton("Non lettr\u00e9es");
        panelSelectEcritures.add((Component)buttonNonLettre, cPanel);
        ++cPanel.gridx;
        final JRadioButton buttonLettre = new JRadioButton("Lettr\u00e9es");
        panelSelectEcritures.add((Component)buttonLettre, cPanel);
        ButtonGroup group = new ButtonGroup();
        group.add(buttonBoth);
        group.add(buttonNonLettre);
        group.add(buttonLettre);
        buttonBoth.setSelected(true);
        buttonLettre.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (buttonLettre.isSelected()) {
                    LettragePanel.this.modeSelect = 1;
                    LettragePanel.this.changeListRequest();
                }
            }
        });
        buttonNonLettre.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (buttonNonLettre.isSelected()) {
                    LettragePanel.this.modeSelect = 2;
                    LettragePanel.this.changeListRequest();
                }
            }
        });
        buttonBoth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (buttonBoth.isSelected()) {
                    LettragePanel.this.modeSelect = 0;
                    LettragePanel.this.changeListRequest();
                }
            }
        });
        return panelSelectEcritures;
    }

    private JPanel createPanelLegende() {
        JPanel panelLegende = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = -1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 0, 0, 0);
        GridBagConstraints cPanel = new GridBagConstraints();
        cPanel.anchor = 18;
        cPanel.fill = 2;
        cPanel.gridheight = 1;
        cPanel.gridwidth = 1;
        cPanel.gridx = 0;
        cPanel.gridy = -1;
        cPanel.weightx = 0.0;
        cPanel.weighty = 0.0;
        cPanel.insets = new Insets(0, 0, 0, 0);
        panelLegende.setLayout(new GridBagLayout());
        panelLegende.setBorder(BorderFactory.createTitledBorder("L\u00e9gendes"));
        JPanel ecritureValidPanel = new JPanel();
        ecritureValidPanel.setLayout(new GridBagLayout());
        ecritureValidPanel.setBackground(Color.WHITE);
        ecritureValidPanel.add((Component)new JLabel("Ecritures valid\u00e9es"), cPanel);
        panelLegende.add((Component)ecritureValidPanel, c);
        JPanel ecritureNonValidPanel = new JPanel();
        ecritureNonValidPanel.setLayout(new GridBagLayout());
        ecritureNonValidPanel.setBackground(PointageRenderer.getCouleurEcritureNonValide());
        ecritureNonValidPanel.add((Component)new JLabel("Ecritures non valid\u00e9es"), cPanel);
        panelLegende.add((Component)ecritureNonValidPanel, c);
        JPanel ecritureNonValidTodayPanel = new JPanel();
        ecritureNonValidTodayPanel.setLayout(new GridBagLayout());
        ecritureNonValidTodayPanel.setBackground(PointageRenderer.getCouleurEcritureToDay());
        ecritureNonValidTodayPanel.add((Component)new JLabel("Ecritures non valid\u00e9es du jour"), cPanel);
        panelLegende.add((Component)ecritureNonValidTodayPanel, c);
        JPanel ecriturePointePanel = new JPanel();
        ecriturePointePanel.setLayout(new GridBagLayout());
        ecriturePointePanel.setBackground(PointageRenderer.getCouleurEcriturePointee());
        ecriturePointePanel.add((Component)new JLabel("Ecritures lettr\u00e9es"), cPanel);
        panelLegende.add((Component)ecriturePointePanel, c);
        return panelLegende;
    }
}

