/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.openconcerto.erp.core.finance.accounting.model.EcrituresModel;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.TableSorter;

public class EcritureRenderer
extends DefaultTableCellRenderer {
    private EcrituresModel model;

    public EcritureRenderer(EcrituresModel model) {
        this.model = model;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (!isSelected) {
            int viewRow = ((TableSorter)table.getModel()).viewIndex(row);
            if (this.model.getEcritures().get(viewRow).getValide()) {
                cell.setForeground(Color.RED);
            } else {
                cell.setForeground(Color.BLACK);
            }
        }
        if (value.getClass() == Long.class) {
            this.setText(GestionDevise.currencyToString((Long)value));
        }
        return cell;
    }
}

