/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;

public class AnalytiqueFrame
extends JFrame {
    private SQLComponent component;
    private JScrollPane p;
    private boolean frameResize = false;

    public AnalytiqueFrame(SQLElement elt) {
        super("G\u00e9rer les " + elt.getPluralName());
        this.component = elt.createComponent();
        this.component.uiInit();
        this.uiInit();
        this.setLocation(0, 50);
        this.viewResized();
        if (Boolean.getBoolean("org.openconcerto.editframe.noborder")) {
            this.setInnerBorder(null);
        }
    }

    private final void uiInit() {
        this.fill();
    }

    private void fill() {
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 4;
        c.fill = 2;
        c.weighty = 1.0;
        c.weightx = 0.0;
        c.insets = new Insets(2, 2, 1, 2);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 1;
        this.p = new JScrollPane(this.component);
        this.p.setOpaque(false);
        container.add((Component)this.p, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
    }

    protected void viewResized() {
        if (!this.frameResize) {
            System.out.println("ViewResized");
            Dimension viewSize = this.component.getSize();
            int verticalHidden = viewSize.height - this.p.getVerticalScrollBar().getVisibleAmount();
            int horizontalHidden = viewSize.width - this.p.getHorizontalScrollBar().getVisibleAmount();
            Rectangle bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            int maxV = (int)bounds.getMaxY() - this.getY();
            int maxH = (int)bounds.getMaxX() - this.getX();
            Dimension frameSize = this.getSize();
            System.out.println("Avant: Frame: size:" + this.getSize());
            int vertical = Math.min(frameSize.height + verticalHidden, maxV);
            int horizontal = Math.min(frameSize.width + horizontalHidden, maxH);
            this.setSize(horizontal, vertical);
            System.out.println("Resultat: Frame: size:" + this.getSize());
        }
        this.setFrameResize(false);
    }

    protected void setFrameResize(boolean b) {
        this.frameResize = b;
    }

    public void setInnerBorder(Border b) {
        this.p.setBorder(b);
    }
}

