/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.model.PlanComptableGModel;
import org.openconcerto.erp.core.finance.accounting.ui.PlanComptableGPanel;
import org.openconcerto.erp.element.objet.Compte;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class AjouterComptePCGtoPCEFrame
extends JFrame {
    private JButton boutonAjout = new JButton("Ajout");
    private JButton boutonClose = new JButton("Fermer");
    private PlanComptableGPanel planPanel;

    public AjouterComptePCGtoPCEFrame() {
        super("Ajouter un compte du plan comptable g\u00e9n\u00e9ral");
        Container f = this.getContentPane();
        Vector<1> actionClickDroitTable = new Vector<1>();
        actionClickDroitTable.add(new AbstractAction("Ajouter au PCE"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AjouterComptePCGtoPCEFrame.this.ajoutCompteSelected();
            }
        });
        this.planPanel = new PlanComptableGPanel(actionClickDroitTable);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(12, 2, 12, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 1;
        c.anchor = 18;
        c.gridwidth = 2;
        c.gridheight = 1;
        JLabel label = new JLabel("Choississez le ou les comptes \u00e0 ajouter au Plan Comptable Entreprise");
        label.setHorizontalAlignment(0);
        f.add((Component)label, c);
        c.insets = new Insets(0, 0, 0, 0);
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        ++c.gridy;
        f.add((Component)this.planPanel, c);
        c.insets = new Insets(2, 2, 1, 2);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        ++c.gridy;
        c.gridx = 0;
        c.anchor = 14;
        f.add((Component)this.boutonAjout, c);
        this.boutonAjout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AjouterComptePCGtoPCEFrame.this.ajoutCompteSelected();
            }
        });
        ++c.gridx;
        f.add((Component)this.boutonClose, c);
        this.boutonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AjouterComptePCGtoPCEFrame.this.setVisible(false);
                AjouterComptePCGtoPCEFrame.this.dispose();
            }
        });
    }

    private void ajoutCompteSelected() {
        int i;
        HashMap<String, Integer> mCompte;
        SQLTable compteTable = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("COMPTE_PCE");
        JTable tabTmp = (JTable)this.planPanel.getTables().get(this.planPanel.getSelectedIndex());
        PlanComptableGModel modelTmp = (PlanComptableGModel)tabTmp.getModel();
        int[] selectRows = tabTmp.getSelectedRows();
        if (selectRows.length == 0) {
            return;
        }
        SQLSelect selCompte = new SQLSelect(compteTable.getBase());
        selCompte.addSelect(compteTable.getField("NUMERO"));
        Where w = new Where((FieldRef)compteTable.getField("NUMERO"), "=", tabTmp.getValueAt(selectRows[0], 0));
        int i2 = 1;
        while (i2 < selectRows.length) {
            w.or(new Where((FieldRef)compteTable.getField("NUMERO"), "=", tabTmp.getValueAt(selectRows[i2], 0)));
            ++i2;
        }
        String reqCompte = selCompte.asString();
        Object obRep = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getDataSource().execute(reqCompte, new ArrayListHandler());
        List tmpCpt = (List)obRep;
        if (tmpCpt.size() == 0) {
            mCompte = null;
        } else {
            mCompte = new HashMap<String, Integer>();
            i = 0;
            while (i < tmpCpt.size()) {
                Object[] tmp = (Object[])tmpCpt.get(i);
                mCompte.put(tmp[0].toString().trim(), new Integer(0));
                ++i;
            }
        }
        i = 0;
        while (i < selectRows.length) {
            if (mCompte != null && mCompte.get(tabTmp.getValueAt(selectRows[i], 0).toString().trim()) == null) {
                System.out.println("Ajout du compte" + tabTmp.getValueAt(selectRows[i], 0) + "  " + tabTmp.getValueAt(selectRows[i], 1));
                SQLRowValues val = new SQLRowValues(compteTable);
                val.put("NUMERO", tabTmp.getValueAt(selectRows[i], 0));
                val.put("NOM", tabTmp.getValueAt(selectRows[i], 1));
                val.put("INFOS", ((Compte)modelTmp.getComptes().get(selectRows[i])).getInfos());
                try {
                    val.insert();
                }
                catch (SQLException sqlE) {
                    System.err.println("Error insert row in table COMPTE_PCE");
                    sqlE.printStackTrace();
                }
            }
            ++i;
        }
    }
}

