/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.report;

import java.io.File;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.generationDoc.SheetInterface;
import org.openconcerto.erp.generationDoc.SheetXml;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.Tuple2;

public class BalanceSheet
extends SheetInterface {
    private static int debutFill;
    private static int endFill;
    private static final SQLTable tableEcriture;
    private static final SQLTable tableCompte;
    private boolean centralClient;
    private boolean centralFourn;
    private static final DateFormat dateFormat;
    private static final DateFormat dateFormatEcr;
    private Date dateDu;
    private Date dateAu;
    private String compteDeb;
    private String compteEnd;
    private static final Tuple2<String, String> tuple;

    static {
        tableEcriture = base.getTable("ECRITURE");
        tableCompte = base.getTable("COMPTE_PCE");
        dateFormat = DateFormat.getDateInstance(2);
        dateFormatEcr = DateFormat.getDateInstance(3);
        BalanceSheet.setSize(7, 69);
        tuple = Tuple2.create("LocationBalance", "Balance");
    }

    public static void setSize(int debut, int fin) {
        debutFill = debut;
        endFill = fin;
    }

    public static Tuple2<String, String> getTuple2Location() {
        return tuple;
    }

    public BalanceSheet(Date du, Date au, String compteDeb, String compteEnd, boolean centralClient, boolean centralFourn) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(au);
        this.nbRowsPerPage = 72;
        this.printer = PrinterNXProps.getInstance().getStringProperty("BalancePrinter");
        this.modele = "Balance.ods";
        String locationForTuple = SheetXml.getLocationForTuple(tuple, false);
        System.err.println("Emplacement balance :::: " + locationForTuple);
        this.locationOO = String.valueOf(locationForTuple) + File.separator + cal.get(1);
        this.locationPDF = String.valueOf(SheetXml.getLocationForTuple(tuple, true)) + File.separator + cal.get(1);
        this.dateAu = au;
        this.dateDu = du;
        this.compteDeb = compteDeb;
        this.compteEnd = compteEnd;
        this.centralClient = centralClient;
        this.centralFourn = centralFourn;
        this.createMap();
    }

    private void makeEntete(int rowDeb) {
        SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
        this.mCell.put("A" + rowDeb, rowSociete.getObject("NOM"));
        this.mCell.put("D" + rowDeb, "Edition du " + dateFormat.format(new Date()));
        System.err.println("MAKE ENTETE");
    }

    private void makePiedPage(int row) {
        this.mCell.put("C" + row, "P\u00e9riode du " + dateFormatEcr.format(this.dateDu) + " au " + dateFormatEcr.format(this.dateAu));
        this.mCell.put("B" + row, "Du compte " + this.compteDeb + " \u00e0 " + this.compteEnd);
    }

    private void makeSousTotalClasse(int row, long debit, long credit, String classe) {
        this.mCell.put("A" + row, "Total classe " + classe);
        this.mCell.put("B" + row, "");
        this.mCell.put("C" + row, new Double(GestionDevise.currencyToString(debit, false)));
        this.mCell.put("D" + row, new Double(GestionDevise.currencyToString(credit, false)));
        this.mCell.put("E" + row, new Double(GestionDevise.currencyToString(debit - credit, false)));
        this.mapStyleRow.put(new Integer(row), "Titre 1");
    }

    @Override
    protected void createMap() {
        this.mapReplace = new HashMap();
        this.mCell = new HashMap();
        this.mapStyleRow = new HashMap();
        SQLSelect sel = new SQLSelect(base);
        sel.addSelect(tableCompte.getField("ID"));
        sel.addSelect(tableEcriture.getField("DEBIT"), "SUM");
        sel.addSelect(tableEcriture.getField("CREDIT"), "SUM");
        Where w = new Where((FieldRef)tableEcriture.getField("DATE"), this.dateDu, (Object)this.dateAu);
        w = this.compteDeb.equals(this.compteEnd) ? w.and(new Where((FieldRef)tableCompte.getField("NUMERO"), "=", (Object)this.compteDeb)) : w.and(new Where((FieldRef)tableCompte.getField("NUMERO"), (Object)this.compteDeb, (Object)this.compteEnd));
        sel.setWhere(w);
        String req = String.valueOf(sel.asString()) + " AND \"ECRITURE\".\"ID_COMPTE_PCE\" = \"COMPTE_PCE\".\"ID\" GROUP BY  \"COMPTE_PCE\".\"NUMERO\", \"COMPTE_PCE\".\"ID\" ORDER BY \"COMPTE_PCE\".\"NUMERO\"";
        System.err.println(req);
        List l = (List)base.getDataSource().execute(req, new ArrayListHandler());
        int posLine = 1;
        int firstLine = 1;
        System.err.println("START CREATE Grand livre, NB ecritures  " + l.size());
        this.nbPage = 0;
        long totalDebit = 0L;
        long totalCredit = 0L;
        long sousTotalDebit = 0L;
        long sousTotalCredit = 0L;
        long totalDebitClient = 0L;
        long totalCreditClient = 0L;
        long totalDebitFourn = 0L;
        long totalCreditFourn = 0L;
        String numCptClient = "411";
        String nomCptClient = "Clients";
        String numCptFourn = "401";
        String nomCptFourn = "Fournisseurs";
        boolean addedLine = false;
        int j = 0;
        String classe = "";
        int i = 0;
        while (i < l.size()) {
            System.err.println("START NEW PAGE; POS : " + posLine);
            this.makeEntete(posLine);
            posLine += debutFill - 1;
            j = 0;
            while (j < endFill - debutFill + 1 && i < l.size()) {
                Object[] o = (Object[])l.get(i);
                int idCpt = Integer.parseInt(o[0].toString());
                SQLRow rowCpt = tableCompte.getRow(idCpt);
                String numeroCpt = rowCpt.getString("NUMERO");
                String nomCpt = rowCpt.getString("NOM");
                if (classe.trim().length() != 0 && numeroCpt.trim().length() > 0 && !classe.trim().equalsIgnoreCase(numeroCpt.substring(0, 1))) {
                    this.makeSousTotalClasse(posLine, sousTotalDebit, sousTotalCredit, classe);
                    sousTotalCredit = 0L;
                    sousTotalDebit = 0L;
                    classe = numeroCpt.substring(0, 1);
                } else {
                    if (classe.trim().length() == 0 && numeroCpt.trim().length() > 0) {
                        classe = numeroCpt.substring(0, 1);
                    }
                    long deb = new Double(o[1].toString()).longValue();
                    long cred = new Double(o[2].toString()).longValue();
                    totalCredit += cred;
                    sousTotalCredit += cred;
                    totalDebit += deb;
                    sousTotalDebit += deb;
                    if (this.centralClient && (numeroCpt.equalsIgnoreCase("411") || numeroCpt.startsWith("411"))) {
                        totalDebitClient += deb;
                        totalCreditClient += cred;
                        deb = totalDebitClient;
                        cred = totalCreditClient;
                    }
                    if (this.centralFourn && (numeroCpt.equalsIgnoreCase("401") || numeroCpt.startsWith("401"))) {
                        totalDebitFourn += deb;
                        totalCreditFourn += cred;
                        deb = totalDebitFourn;
                        cred = totalCreditFourn;
                    }
                    if (this.centralClient && !numeroCpt.equalsIgnoreCase("411") && numeroCpt.startsWith("411")) {
                        if (addedLine || !this.centralFourn) {
                            --posLine;
                            --j;
                        } else {
                            addedLine = true;
                        }
                        this.mCell.put("A" + posLine, numCptClient);
                        this.mCell.put("B" + posLine, nomCptClient);
                    } else if (this.centralFourn && !numeroCpt.equalsIgnoreCase("401") && numeroCpt.startsWith("401")) {
                        --j;
                        this.mCell.put("A" + --posLine, numCptFourn);
                        this.mCell.put("B" + posLine, nomCptFourn);
                    } else {
                        this.mCell.put("A" + posLine, numeroCpt);
                        this.mCell.put("B" + posLine, nomCpt);
                    }
                    this.mCell.put("C" + posLine, new Double(GestionDevise.currencyToString(deb, false)));
                    this.mCell.put("D" + posLine, new Double(GestionDevise.currencyToString(cred, false)));
                    this.mCell.put("E" + posLine, new Double(GestionDevise.currencyToString(deb - cred, false)));
                    this.mapStyleRow.put(new Integer(posLine), "Normal");
                    ++i;
                }
                ++posLine;
                ++j;
            }
            if (i >= l.size() && j < endFill - debutFill + 1) {
                this.makeSousTotalClasse(posLine, sousTotalDebit, sousTotalCredit, classe);
            }
            posLine = firstLine + endFill;
            this.mCell.put("C" + posLine, totalDebit == 0L ? new Double(0.0) : new Double(GestionDevise.currencyToString(totalDebit, false)));
            this.mCell.put("D" + posLine, totalCredit == 0L ? new Double(0.0) : new Double(GestionDevise.currencyToString(totalCredit, false)));
            this.mCell.put("E" + posLine, totalDebit - totalCredit == 0L ? new Double(0.0) : new Double(GestionDevise.currencyToString(totalDebit - totalCredit, false)));
            this.makePiedPage(posLine += 2);
            firstLine = ++posLine;
            ++this.nbPage;
            if (i < l.size() || j < endFill - debutFill + 1) continue;
            this.makeEntete(posLine);
            this.makeSousTotalClasse(posLine += debutFill - 1, sousTotalDebit, sousTotalCredit, classe);
            ++this.nbPage;
        }
        if (this.nbPage > 0) {
            --this.nbPage;
        }
    }
}

