/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.element;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.finance.accounting.ui.SaisieKmItemTable;
import org.openconcerto.erp.generationEcritures.GenerationMvtSaisieKm;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.warning.JLabelWarning;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class SaisieKmSQLElement
extends ComptaSQLConfElement {
    public SaisieKmSQLElement() {
        super("SAISIE_KM", "une saisie au kilom\u00e8tre", "saisies au kilom\u00e8tre");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("NOM");
        l.add("ID_JOURNAL");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("NOM");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new SaisieKmComponent();
    }

    @Override
    protected Set<String> getChildren() {
        HashSet<String> set = new HashSet<String>();
        set.add("SAISIE_KM_ELEMENT");
        return set;
    }

    public static int createSaisie(int idMvt) {
        System.err.println("CREATION D'UNE SAISIE AU KM");
        int idSaisie = 1;
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable ecrTable = base.getTable("ECRITURE");
        SQLTable compteTable = base.getTable("COMPTE_PCE");
        SQLTable saisieKmTable = base.getTable("SAISIE_KM_ELEMENT");
        SQLRowValues vals = new SQLRowValues(base.getTable("SAISIE_KM"));
        vals.put("ID_MOUVEMENT", new Integer(idMvt));
        try {
            SQLTable mouvementTable;
            SQLRow rowMvt;
            SQLRow rowSaisieKm = vals.insert();
            idSaisie = rowSaisieKm.getID();
            SQLSelect selEcriture = new SQLSelect(base);
            selEcriture.addSelect(ecrTable.getField("ID"));
            Where w = new Where((FieldRef)ecrTable.getField("ID_MOUVEMENT"), "=", idMvt);
            selEcriture.setWhere(w);
            String reqEcriture = selEcriture.asString();
            Object obEcriture = base.getDataSource().execute(reqEcriture, new ArrayListHandler());
            List myListEcriture = (List)obEcriture;
            if (myListEcriture.size() != 0) {
                int i = 0;
                while (i < myListEcriture.size()) {
                    Object[] objTmp = (Object[])myListEcriture.get(i);
                    SQLRow rowEcrTmp = ecrTable.getRow(Integer.parseInt(objTmp[0].toString()));
                    SQLRow rowCompteTmp = compteTable.getRow(rowEcrTmp.getInt("ID_COMPTE_PCE"));
                    SQLRowValues valsTmp = new SQLRowValues(saisieKmTable);
                    valsTmp.put("ID_SAISIE_KM", new Integer(rowSaisieKm.getID()));
                    valsTmp.put("NUMERO", rowCompteTmp.getString("NUMERO"));
                    valsTmp.put("NOM", rowCompteTmp.getString("NOM"));
                    valsTmp.put("NOM_ECRITURE", rowEcrTmp.getString("NOM"));
                    valsTmp.put("DEBIT", rowEcrTmp.getObject("DEBIT"));
                    valsTmp.put("CREDIT", rowEcrTmp.getObject("CREDIT"));
                    valsTmp.put("ID_ECRITURE", new Integer(rowEcrTmp.getID()));
                    valsTmp.insert();
                    ++i;
                }
                Object[] objTmp = (Object[])myListEcriture.get(0);
                SQLRow rowEcrTmp = ecrTable.getRow(Integer.parseInt(objTmp[0].toString()));
                vals.put("NOM", rowEcrTmp.getString("NOM"));
                vals.put("DATE", rowEcrTmp.getObject("DATE"));
                vals.put("ID_JOURNAL", rowEcrTmp.getObject("ID_JOURNAL"));
                vals.update(idSaisie);
            }
            if ((rowMvt = (mouvementTable = base.getTable("MOUVEMENT")).getRow(idMvt)).getString("SOURCE").trim().length() == 0 || rowMvt.getInt("IDSOURCE") == 1) {
                SQLRowValues valsMouvement = new SQLRowValues(mouvementTable);
                valsMouvement.put("SOURCE", "SAISIE_KM");
                valsMouvement.put("IDSOURCE", new Integer(rowSaisieKm.getID()));
                valsMouvement.update(idMvt);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return idSaisie;
    }

    public static void loadContrePassation(SQLComponent comp, int idMvt) {
        SaisieKmComponent compKm = (SaisieKmComponent)comp;
        compKm.loadContrepassation(idMvt);
    }

    class SaisieKmComponent
    extends BaseSQLComponent {
        private JTextField textNom;
        private JDate date;
        private RowValuesTableModel model;
        private ElementComboBox comboJrnl;
        private JLabel labelTotalDebit;
        private JLabel labelTotalCredit;
        private long totalCred;
        private long totalDeb;
        private int debitIndex;
        private int creditIndex;
        private JCheckBox checkCreateCompte;
        private boolean isCompteExist;
        private boolean allLineValid;
        private SaisieKmItemTable tableKm;
        private JLabel labelMotifWarning;
        final JLabel labelWarning;
        private SQLElement eltKmItem;
        private SQLRowValues defaultEcritureRowVals;
        private TableModelListener tableListener;
        private Date dTemp;

        public SaisieKmComponent() {
            super(SaisieKmSQLElement.this);
            this.isCompteExist = false;
            this.allLineValid = true;
            this.labelWarning = new JLabelWarning();
            this.eltKmItem = Configuration.getInstance().getDirectory().getElement("SAISIE_KM_ELEMENT");
            this.defaultEcritureRowVals = new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(this.eltKmItem.getTable()));
            this.tableListener = new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    SaisieKmComponent.this.totalCred = 0L;
                    SaisieKmComponent.this.totalDeb = 0L;
                    long totalCredWithNoValid = 0L;
                    long totalDebWithNoValid = 0L;
                    SaisieKmComponent.this.isCompteExist = true;
                    SaisieKmComponent.this.allLineValid = true;
                    int i = 0;
                    while (i < SaisieKmComponent.this.model.getRowCount()) {
                        long totalLine = 0L;
                        boolean b = SaisieKmComponent.this.model.isRowValid(i);
                        Long fTc = (Long)SaisieKmComponent.this.model.getValueAt(i, SaisieKmComponent.this.creditIndex);
                        Long fTd = (Long)SaisieKmComponent.this.model.getValueAt(i, SaisieKmComponent.this.debitIndex);
                        String numCpt = SaisieKmComponent.this.model.getValueAt(i, SaisieKmComponent.this.model.getColumnIndexForElement(SaisieKmComponent.this.tableKm.getNumeroCompteElement())).toString();
                        SaisieKmComponent.this.isCompteExist = SaisieKmComponent.this.isCompteExist && ComptePCESQLElement.isExist(numCpt);
                        if (fTc != 0L && fTd != 0L) {
                            return;
                        }
                        if (fTc != null) {
                            if (b) {
                                SaisieKmComponent saisieKmComponent = SaisieKmComponent.this;
                                saisieKmComponent.totalCred = saisieKmComponent.totalCred + fTc;
                            }
                            totalCredWithNoValid += fTc.longValue();
                            totalLine += fTc.longValue();
                        }
                        if (fTd != null) {
                            if (b) {
                                SaisieKmComponent saisieKmComponent = SaisieKmComponent.this;
                                saisieKmComponent.totalDeb = saisieKmComponent.totalDeb + fTd;
                            }
                            totalDebWithNoValid += fTd.longValue();
                            totalLine += fTd.longValue();
                        }
                        boolean d = totalLine != 0L;
                        SaisieKmComponent.this.tableKm.setRowDeviseValidAt(d, i);
                        if (!d) {
                            SaisieKmComponent.this.allLineValid = false;
                        }
                        ++i;
                    }
                    SaisieKmComponent.this.tableKm.revalidate();
                    SaisieKmComponent.this.tableKm.repaint();
                    SaisieKmComponent.this.labelTotalCredit.setText(GestionDevise.currencyToString(SaisieKmComponent.this.totalCred));
                    SaisieKmComponent.this.labelTotalDebit.setText(GestionDevise.currencyToString(SaisieKmComponent.this.totalDeb));
                    long diff = SaisieKmComponent.this.totalDeb - SaisieKmComponent.this.totalCred;
                    long diffWithNoValid = totalDebWithNoValid - totalCredWithNoValid;
                    if (diff == 0L) {
                        SaisieKmComponent.this.labelMotifWarning.setVisible(false);
                        SaisieKmComponent.this.labelWarning.setVisible(false);
                    } else {
                        if (diff > 0L) {
                            SaisieKmComponent.this.labelMotifWarning.setText("Le solde des \u00e9critures n'est pas nul! Il manque " + GestionDevise.currencyToString(diff) + " en cr\u00e9dit.");
                        } else {
                            SaisieKmComponent.this.labelMotifWarning.setText("Le solde des \u00e9critures n'est pas nul! Il manque " + GestionDevise.currencyToString(diff) + " en d\u00e9bit.");
                        }
                        SaisieKmComponent.this.labelMotifWarning.setVisible(true);
                        SaisieKmComponent.this.labelWarning.setVisible(true);
                    }
                    if (diffWithNoValid != 0L) {
                        if (diffWithNoValid > 0L) {
                            SaisieKmComponent.this.defaultEcritureRowVals.put("DEBIT", 0L);
                            SaisieKmComponent.this.defaultEcritureRowVals.put("CREDIT", diffWithNoValid);
                            if (SaisieKmComponent.this.model.isLastRowValid()) {
                                SaisieKmComponent.this.tableKm.getModel().addRow(new SQLRowValues(SaisieKmComponent.this.defaultEcritureRowVals));
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (SaisieKmComponent.this.model.getRowCount() > 0) {
                                            SaisieKmComponent.this.tableKm.editCellAt(SaisieKmComponent.this.model.getRowCount() - 1, 0);
                                        }
                                    }
                                });
                            }
                        } else {
                            SaisieKmComponent.this.defaultEcritureRowVals.put("DEBIT", -diffWithNoValid);
                            SaisieKmComponent.this.defaultEcritureRowVals.put("CREDIT", 0L);
                            if (SaisieKmComponent.this.model.isLastRowValid()) {
                                SaisieKmComponent.this.tableKm.getModel().addRow(new SQLRowValues(SaisieKmComponent.this.defaultEcritureRowVals));
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (SaisieKmComponent.this.model.getRowCount() > 0) {
                                            SaisieKmComponent.this.tableKm.editCellAt(SaisieKmComponent.this.model.getRowCount() - 1, 0);
                                        }
                                    }
                                });
                            } else {
                                System.err.println(e.getType());
                            }
                        }
                    } else {
                        SaisieKmComponent.this.defaultEcritureRowVals.put("DEBIT", 0L);
                        SaisieKmComponent.this.defaultEcritureRowVals.put("CREDIT", 0L);
                    }
                    SaisieKmComponent.this.fireValidChange();
                }
            };
            this.dTemp = null;
        }

        @Override
        public void addViews() {
            this.setLayout(new GridBagLayout());
            DefaultGridBagConstraints c = new DefaultGridBagConstraints();
            this.textNom = new JTextField();
            this.labelTotalCredit = new JLabel("0.00", 4);
            this.labelTotalDebit = new JLabel("0.00", 4);
            this.date = new JDate(true);
            this.comboJrnl = new ElementComboBox(false, 20);
            this.add((Component)new JLabel("Libell\u00e9", 4), c);
            ++c.gridx;
            c.weightx = 1.0;
            c.gridwidth = 1;
            this.add((Component)this.textNom, c);
            JLabel labelDate = new JLabel("Date");
            ++c.gridx;
            c.weightx = 0.0;
            c.gridwidth = 1;
            this.add((Component)labelDate, c);
            ++c.gridx;
            c.gridwidth = 1;
            this.add((Component)this.date, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            this.add((Component)new JLabel("Journal", 4), c);
            ++c.gridx;
            c.gridwidth = 3;
            c.fill = 0;
            c.weightx = 1.0;
            this.add((Component)this.comboJrnl, c);
            this.tableKm = new SaisieKmItemTable(this.defaultEcritureRowVals);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridwidth = 0;
            c.fill = 1;
            this.add((Component)this.tableKm, c);
            this.tableKm.getModel().clearRows();
            JPanel panelTotal = new JPanel();
            panelTotal.setLayout(new GridBagLayout());
            panelTotal.setBorder(BorderFactory.createTitledBorder("Totaux"));
            DefaultGridBagConstraints cc = new DefaultGridBagConstraints();
            cc.anchor = 13;
            cc.fill = 0;
            panelTotal.add((Component)new JLabel("D\u00e9bit"), cc);
            cc.fill = 2;
            ++cc.gridx;
            cc.weightx = 1.0;
            panelTotal.add((Component)this.labelTotalDebit, cc);
            ++cc.gridy;
            cc.gridx = 0;
            cc.weightx = 0.0;
            cc.fill = 0;
            panelTotal.add((Component)new JLabel("Cr\u00e9dit"), cc);
            cc.weightx = 1.0;
            ++cc.gridx;
            cc.fill = 2;
            panelTotal.add((Component)this.labelTotalCredit, cc);
            this.checkCreateCompte = new JCheckBox("Cr\u00e9ation automatique des comptes");
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 2;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.add((Component)this.checkCreateCompte, c);
            ++c.gridy;
            c.weightx = 0.0;
            c.gridwidth = 1;
            this.labelWarning.setHorizontalAlignment(4);
            this.labelWarning.setVisible(false);
            this.add((Component)this.labelWarning, c);
            this.labelMotifWarning = new JLabel("Le solde des \u00e9critures n'est pas nul!");
            DefaultGridBagConstraints.lockMinimumSize(this.labelMotifWarning);
            ++c.gridx;
            c.gridwidth = 1;
            c.weightx = 0.0;
            this.add((Component)this.labelMotifWarning, c);
            this.labelMotifWarning.setVisible(false);
            --c.gridy;
            c.gridx = 2;
            c.anchor = 13;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 0;
            c.gridwidth = 2;
            c.gridheight = 2;
            panelTotal.setPreferredSize(new Dimension(250, panelTotal.getPreferredSize().height));
            DefaultGridBagConstraints.lockMinimumSize(panelTotal);
            this.add((Component)panelTotal, c);
            this.model = this.tableKm.getModel();
            this.creditIndex = this.model.getColumnIndexForElement(this.tableKm.getCreditElement());
            this.debitIndex = this.model.getColumnIndexForElement(this.tableKm.getDebitElement());
            this.tableKm.getModel().addTableModelListener(this.tableListener);
            this.addSQLObject(this.textNom, "NOM");
            this.addRequiredSQLObject(this.date, "DATE");
            this.addRequiredSQLObject(this.comboJrnl, "ID_JOURNAL");
            this.comboJrnl.setButtonsVisible(false);
            this.textNom.getDocument().addDocumentListener(new SimpleDocumentListener(){

                @Override
                public void update(DocumentEvent e) {
                    SaisieKmComponent.this.defaultEcritureRowVals.put("NOM_ECRITURE", SaisieKmComponent.this.textNom.getText());
                }
            });
            this.checkCreateCompte.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SaisieKmComponent.this.tableKm.setCreateAutoActive(SaisieKmComponent.this.checkCreateCompte.isSelected());
                    SaisieKmComponent.this.fireValidChange();
                }
            });
            DefaultGridBagConstraints.lockMinimumSize(this.comboJrnl);
        }

        @Override
        public synchronized boolean isValidated() {
            return super.isValidated() && this.totalDeb - this.totalCred == 0L && (this.checkCreateCompte.isSelected() || !this.checkCreateCompte.isSelected() && this.isCompteExist) && this.allLineValid;
        }

        @Override
        public int insert(SQLRow order) {
            int id = super.insert(order);
            this.tableKm.updateField("ID_SAISIE_KM", id);
            GenerationMvtSaisieKm gen = new GenerationMvtSaisieKm(id);
            int idMvt = gen.genereMouvement();
            SQLRowValues valEcriture = new SQLRowValues(SaisieKmSQLElement.this.getTable());
            valEcriture.put("ID_MOUVEMENT", new Integer(idMvt));
            try {
                if (valEcriture.getInvalid() == null) {
                    valEcriture.update(id);
                }
            }
            catch (SQLException e) {
                System.err.println("Erreur \u00e0 l'insertion dans la table " + valEcriture.getTable().getName() + " : " + e);
                e.printStackTrace();
            }
            SQLElement eltMvt = Configuration.getInstance().getDirectory().getElement("MOUVEMENT");
            SQLRow rowMvt = eltMvt.getTable().getRow(idMvt);
            JOptionPane.showMessageDialog(this, "Num\u00e9ro de mouvement associ\u00e9 : " + rowMvt.getObject("NUMERO"));
            return id;
        }

        public void loadMouvement(int idMvt) {
            this.tableKm.loadMouvement(idMvt, false);
        }

        public void loadContrepassation(int idMvt) {
            this.tableKm.loadMouvement(idMvt, true);
        }

        @Override
        public void select(SQLRowAccessor r) {
            if (r == null) {
                this.dTemp = this.date.getDate();
            }
            super.select(r);
            if (r != null) {
                this.tableKm.insertFrom("ID_SAISIE_KM", r.getID());
            }
        }

        @Override
        public void update() {
            super.update();
            this.tableKm.updateField("ID_SAISIE_KM", this.getSelectedID());
            System.err.println("UPDATE ECRITURE");
            this.updateEcriture();
        }

        @Override
        protected SQLRowValues createDefaults() {
            SQLRowValues rowVals = new SQLRowValues(this.getTable());
            if (this.dTemp == null) {
                this.dTemp = new Date();
            }
            rowVals.put("DATE", this.dTemp);
            this.tableKm.getModel().clearRows();
            this.tableKm.revalidate();
            this.tableKm.repaint();
            return rowVals;
        }

        public void updateEcriture() {
            SQLTable ecritureTable = this.getTable().getBase().getTable("ECRITURE");
            SQLElement assocElt = Configuration.getInstance().getDirectory().getElement("ASSOCIATION_ANALYTIQUE");
            SQLRow rowSaisieKm = this.getElement().getTable().getRow(this.getSelectedID());
            Collection myListDevisItem = rowSaisieKm.getReferentRows(this.getTable().getBase().getTable("SAISIE_KM_ELEMENT"));
            Collection listEcr = rowSaisieKm.getForeignRow("ID_MOUVEMENT").getReferentRows(ecritureTable);
            if (myListDevisItem != null) {
                for (SQLRow rowElement : myListDevisItem) {
                    block23: {
                        int idCpt = ComptePCESQLElement.getId(rowElement.getString("NUMERO"), rowElement.getString("NOM"));
                        if (rowElement.getID() <= 1) continue;
                        SQLRowValues vals = new SQLRowValues(ecritureTable);
                        vals.put("ID_COMPTE_PCE", idCpt);
                        vals.put("COMPTE_NUMERO", rowElement.getString("NUMERO"));
                        vals.put("COMPTE_NOM", rowElement.getString("NOM"));
                        vals.put("DEBIT", rowElement.getObject("DEBIT"));
                        vals.put("CREDIT", rowElement.getObject("CREDIT"));
                        vals.put("DATE", rowSaisieKm.getObject("DATE"));
                        SQLRow rowJournal = rowSaisieKm.getForeignRow("ID_JOURNAL");
                        vals.put("ID_JOURNAL", rowJournal.getID());
                        vals.put("JOURNAL_NOM", rowJournal.getString("NOM"));
                        vals.put("JOURNAL_CODE", rowJournal.getString("CODE"));
                        vals.put("NOM", rowElement.getObject("NOM_ECRITURE"));
                        if (rowElement.getInt("ID_ECRITURE") > 1) {
                            SQLRow rowTmp = ecritureTable.getRow(rowElement.getInt("ID_ECRITURE"));
                            System.out.println("ID : " + rowElement.getInt("ID_ECRITURE"));
                            try {
                                if (!rowTmp.getBoolean("VALIDE").booleanValue()) {
                                    vals.update(rowElement.getInt("ID_ECRITURE"));
                                    break block23;
                                }
                                System.err.println("Impossible de modifier une ecriture valide");
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                        } else {
                            vals.put("ID_MOUVEMENT", rowSaisieKm.getObject("ID_MOUVEMENT"));
                            System.out.println("ID : " + rowElement.getInt("ID_ECRITURE"));
                            try {
                                if (MouvementSQLElement.isEditable(rowSaisieKm.getInt("ID_MOUVEMENT"))) {
                                    SQLRow rowEcr = vals.insert();
                                    SQLRowValues rowElementVals = rowElement.createEmptyUpdateRow();
                                    rowElementVals.put("ID_ECRITURE", rowEcr.getID());
                                    rowElement = rowElementVals.update();
                                }
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    Collection referentRowsAssocEcr = rowElement.getForeign("ID_ECRITURE").getReferentRows(assocElt.getTable());
                    for (SQLRow sqlRow : referentRowsAssocEcr) {
                        try {
                            assocElt.archive(sqlRow.getID());
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    for (SQLRow sqlRow : rowElement.getReferentRows(assocElt.getTable())) {
                        SQLRowValues rowVals = sqlRow.asRowValues();
                        rowVals.putEmptyLink("ID_SAISIE_KM_ELEMENT");
                        rowVals.put("ID_ECRITURE", rowElement.getInt("ID_ECRITURE"));
                        rowVals.setID(-1);
                        try {
                            rowVals.commit();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    ArrayList l = new ArrayList(listEcr);
                    for (SQLRow sqlRow : l) {
                        if (sqlRow.getID() != rowElement.getInt("ID_ECRITURE")) continue;
                        listEcr.remove(sqlRow);
                    }
                }
            }
            if (!listEcr.isEmpty()) {
                EcritureSQLElement e = (EcritureSQLElement)Configuration.getInstance().getDirectory().getElement(ecritureTable);
                for (SQLRow sqlRow : listEcr) {
                    try {
                        e.archiveEcriture(sqlRow);
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    }
}

