/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.SaisieKmSQLElement;
import org.openconcerto.erp.core.finance.accounting.ui.LettrageRenderer;
import org.openconcerto.erp.core.finance.accounting.ui.ListEcritureRenderer;
import org.openconcerto.erp.core.finance.accounting.ui.PointageRenderer;
import org.openconcerto.erp.core.finance.accounting.ui.SuppressionEcrituresPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.utils.ExceptionHandler;

public class EcritureSQLElement
extends ComptaSQLConfElement {
    private static EditFrame frameSaisieKm = null;

    public EcritureSQLElement() {
        super("ECRITURE", "une \u00e9criture", "\u00e9critures");
    }

    @Override
    public List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID");
        l.add("ID_MOUVEMENT");
        l.add("COMPTE_NUMERO");
        l.add("COMPTE_NOM");
        l.add("JOURNAL_NOM");
        l.add("NOM");
        l.add("DATE");
        l.add("DEBIT");
        l.add("CREDIT");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        l.add("DATE");
        l.add("DEBIT");
        l.add("CREDIT");
        l.add("ID_JOURNAL");
        l.add("ID_MOUVEMENT");
        return l;
    }

    @Override
    public synchronized ListSQLRequest createListRequest() {
        return this.createListRequest(this.getListFields());
    }

    public ListSQLRequest createListRequest(List<String> fields) {
        return new ListSQLRequest(this.getTable(), fields){

            @Override
            protected void customizeToFetch(SQLRowValues graphToFetch) {
                super.customizeToFetch(graphToFetch);
                graphToFetch.put("VALIDE", null);
            }
        };
    }

    @Override
    protected void _initTableSource(SQLTableModelSourceOnline res) {
        super._initTableSource(res);
        for (SQLTableModelColumn col : res.getColumns()) {
            col.setRenderer(ListEcritureRenderer.UTILS.getRenderer(col.getRenderer()));
        }
    }

    public final SQLTableModelSourceOnline createPointageTableSource() {
        ArrayList<String> listEcriture = new ArrayList<String>();
        listEcriture.add("POINTEE");
        listEcriture.add("DATE_POINTEE");
        listEcriture.add("ID_MOUVEMENT");
        listEcriture.add("NOM");
        listEcriture.add("DATE");
        listEcriture.add("DEBIT");
        listEcriture.add("CREDIT");
        SQLTableModelSourceOnline res = this.initTableSource(new SQLTableModelSourceOnline(this.createListRequest(listEcriture)));
        for (SQLTableModelColumn column : res.getColumns()) {
            column.setRenderer(PointageRenderer.UTILS.getRenderer(column.getRenderer()));
        }
        return res;
    }

    public final SQLTableModelSourceOnline createLettrageTableSource() {
        ArrayList<String> listEcriture = new ArrayList<String>();
        listEcriture.add("LETTRAGE");
        listEcriture.add("ID_COMPTE_PCE");
        listEcriture.add("ID_MOUVEMENT");
        listEcriture.add("NOM");
        listEcriture.add("DATE_LETTRAGE");
        listEcriture.add("DATE");
        listEcriture.add("DEBIT");
        listEcriture.add("CREDIT");
        SQLTableModelSourceOnline res = this.initTableSource(new SQLTableModelSourceOnline(this.createListRequest(listEcriture)));
        for (SQLTableModelColumn column : res.getColumns()) {
            column.setRenderer(LettrageRenderer.UTILS.getRenderer(column.getRenderer()));
        }
        return res;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            private JTextField nom;
            private DeviseField debit;
            private DeviseField credit;
            private JDate date;
            private ElementComboBox journal;

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                this.nom = new JTextField();
                this.debit = new DeviseField();
                this.credit = new DeviseField();
                this.date = new JDate();
                this.journal = new ElementComboBox();
                JLabel labelJournal = new JLabel("Journal");
                c.gridx = 0;
                this.add((Component)labelJournal, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.journal, c);
                JLabel labelDate = new JLabel("Date");
                ++c.gridx;
                this.add((Component)labelDate, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.date, c);
                JLabel labelNom = new JLabel("Libell\u00e9");
                ++c.gridy;
                c.gridx = 0;
                this.add((Component)labelNom, c);
                ++c.gridx;
                c.weightx = 1.0;
                c.gridwidth = 0;
                this.add((Component)this.nom, c);
                c.gridwidth = 1;
                JLabel labelDebit = new JLabel("Debit");
                ++c.gridy;
                c.gridx = 0;
                this.add((Component)labelDebit, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.debit, c);
                this.debit.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyReleased(KeyEvent e) {
                        if (credit.getText().trim().length() != 0 && debit.getText().trim().length() != 0) {
                            credit.setText("");
                        }
                    }
                });
                JLabel labelCredit = new JLabel("Credit");
                ++c.gridx;
                this.add((Component)labelCredit, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.credit, c);
                this.credit.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyReleased(KeyEvent e) {
                        if (debit.getText().trim().length() != 0 && credit.getText().trim().length() != 0) {
                            debit.setText("");
                        }
                    }
                });
                this.addSQLObject(this.nom, "NOM");
                this.addSQLObject(this.debit, "DEBIT");
                this.addSQLObject(this.credit, "CREDIT");
                this.addRequiredSQLObject(this.date, "DATE");
                this.addRequiredSQLObject(this.journal, "ID_JOURNAL");
            }

            @Override
            public void select(SQLRowAccessor r) {
                super.select(r);
                if (r != null && r.getBoolean("VALIDE").booleanValue()) {
                    this.nom.setEnabled(false);
                    this.debit.setEnabled(false);
                    this.credit.setEnabled(false);
                    this.date.setEnabled(false);
                    this.date.setEditable(false);
                    this.journal.setEnabled(false);
                }
            }

            @Override
            public void update() {
                SQLRow row = EcritureSQLElement.this.getTable().getRow(this.getSelectedID());
                if (row.getBoolean("VALIDE").booleanValue()) {
                    System.out.println("Impossible de modifier une ecriture valid\u00e9e");
                } else {
                    super.update();
                }
            }
        };
    }

    private static void validerMouvement(int idMvt) {
        if (idMvt == 1) {
            return;
        }
        SQLTable tableMvt = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("MOUVEMENT");
        SQLRow rowMvt = tableMvt.getRow(idMvt);
        if (rowMvt.getInt("ID_MOUVEMENT_PERE") > 1) {
            EcritureSQLElement.validerMouvement(rowMvt.getInt("ID_MOUVEMENT_PERE"));
        } else {
            EcritureSQLElement.validerMouvementProfondeur(idMvt);
        }
    }

    private static void validerMouvementProfondeur(int idMvtPere) {
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable tableMvt = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("MOUVEMENT");
        SQLSelect selectFils = new SQLSelect(base);
        selectFils.addSelect(tableMvt.getField("ID"));
        selectFils.setWhere("MOUVEMENT.ID_MOUVEMENT_PERE", "=", idMvtPere);
        List l = (List)base.getDataSource().execute(selectFils.asString(), new ArrayListHandler());
        int i = 0;
        while (i < l.size()) {
            Object[] tmp = (Object[])l.get(i);
            EcritureSQLElement.validerMouvementProfondeur(Integer.parseInt(tmp[0].toString()));
            ++i;
        }
        EcritureSQLElement.validationEcritures(idMvtPere);
    }

    public static final void validationEcritures(int idMvt) {
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable tableEcriture = base.getTable("ECRITURE");
        SQLSelect selEcriture = new SQLSelect(base);
        selEcriture.addSelect(tableEcriture.getField("ID"));
        Where w = new Where((FieldRef)tableEcriture.getField("ID_MOUVEMENT"), "=", idMvt);
        selEcriture.setWhere(w);
        String reqEcriture = selEcriture.asString();
        Object obEcriture = base.getDataSource().execute(reqEcriture, new ArrayListHandler());
        List myListEcriture = (List)obEcriture;
        if (myListEcriture.size() != 0) {
            int i = 0;
            while (i < myListEcriture.size()) {
                Object[] objTmp = (Object[])myListEcriture.get(i);
                EcritureSQLElement.valideEcriture(Integer.parseInt(objTmp[0].toString()));
                ++i;
            }
        }
    }

    public static final void validationEcrituresBefore(java.util.Date d, boolean cloture) {
        SQLRow rowSociete;
        SQLTable tableExercice;
        SQLRow rowExercice;
        java.util.Date dateCloture;
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable tableEcriture = base.getTable("ECRITURE");
        SQLSelect selEcriture = new SQLSelect(base);
        selEcriture.addSelect(tableEcriture.getField("ID_MOUVEMENT"));
        selEcriture.setDistinct(true);
        Where w1 = new Where((FieldRef)tableEcriture.getField("DATE"), "<=", (Object)d);
        Where w2 = new Where((FieldRef)tableEcriture.getField("VALIDE"), "=", (Object)Boolean.FALSE);
        selEcriture.setWhere(w1.and(w2));
        List l = (List)base.getDataSource().execute(selEcriture.asString(), new ArrayListHandler());
        int i = 0;
        while (i < l.size()) {
            Object[] tmp = (Object[])l.get(i);
            System.err.println("Validation du mouvement " + tmp[0]);
            EcritureSQLElement.validationEcritures(Integer.parseInt(tmp[0].toString()));
            ++i;
        }
        if (cloture && ((dateCloture = (java.util.Date)(rowExercice = (tableExercice = Configuration.getInstance().getBase().getTable("EXERCICE_COMMON")).getRow((rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete()).getInt("ID_EXERCICE_COMMON"))).getObject("DATE_CLOTURE")) == null || dateCloture.before(d))) {
            SQLRowValues rowVals = new SQLRowValues(tableExercice);
            rowVals.put("DATE_CLOTURE", new Date(d.getTime()));
            try {
                rowVals.update(rowExercice.getID());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private static final void valideEcriture(int id) {
        SQLTable tableEcriture = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("ECRITURE");
        SQLRowValues rowVals = new SQLRowValues(tableEcriture);
        rowVals.put("VALIDE", Boolean.TRUE);
        rowVals.put("DATE_VALIDE", new Date(new java.util.Date().getTime()));
        rowVals.put("IDUSER_VALIDE", UserManager.getInstance().getCurrentUser().getId());
        try {
            rowVals.update(id);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void archiveMouvement(int idMvt) {
        SQLTable tableMouvement = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("MOUVEMENT");
        SQLRow rowMvt = tableMouvement.getRow(idMvt);
        if (rowMvt.getInt("ID_MOUVEMENT_PERE") > 1) {
            this.archiveMouvement(rowMvt.getInt("ID_MOUVEMENT_PERE"));
        } else {
            this.archiveMouvementProfondeur(idMvt, true);
        }
    }

    public void archiveMouvementProfondeur(int idMvtPere, boolean dropPere) {
        if (idMvtPere > 1) {
            SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
            SQLTable tableMvt = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("MOUVEMENT");
            SQLSelect selectFils = new SQLSelect(base);
            selectFils.addSelect(tableMvt.getField("ID"));
            selectFils.setWhere("MOUVEMENT.ID_MOUVEMENT_PERE", "=", idMvtPere);
            List l = (List)base.getDataSource().execute(selectFils.asString(), new ArrayListHandler());
            int i = 0;
            while (i < l.size()) {
                Object[] tmp = (Object[])l.get(i);
                this.archiveMouvementProfondeur(Integer.parseInt(tmp[0].toString()), true);
                ++i;
            }
            this.archiveEcritures(idMvtPere, dropPere);
        } else {
            System.err.println("Suppression du mouvement d'id 1 impossible.");
        }
    }

    private synchronized void archiveEcritures(final int idMvt, boolean dropMvt) {
        final SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable tableMvt = base.getTable("MOUVEMENT");
        final SQLTable tableEcriture = base.getTable("ECRITURE");
        SQLRow rowMvt = tableMvt.getRow(idMvt);
        if (MouvementSQLElement.isEditable(idMvt)) {
            if (dropMvt) {
                SQLElement elt = Configuration.getInstance().getDirectory().getElement(tableMvt);
                try {
                    elt.archive(idMvt);
                }
                catch (SQLException e) {
                    ExceptionHandler.handle("Erreur lors de la suppression du mouvement d'id [" + idMvt + "]", e);
                    e.printStackTrace();
                }
            } else {
                SQLUtils.SQLFactory<Object> sqlFactory = new SQLUtils.SQLFactory<Object>(){

                    @Override
                    public Object create() throws SQLException {
                        SQLSelect selEcritures = new SQLSelect(base);
                        selEcritures.addSelect(tableEcriture.getField("ID"));
                        selEcritures.setWhere("ECRITURE.ID_MOUVEMENT", "=", idMvt);
                        List l = (List)base.getDataSource().execute(selEcritures.asString(), new ArrayListHandler());
                        int i = 0;
                        while (i < l.size()) {
                            Object[] tmp = (Object[])l.get(i);
                            try {
                                EcritureSQLElement.this.archiveEcriture(tableEcriture.getRow(Integer.parseInt(tmp[0].toString())));
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                                ExceptionHandler.handle("Une erreur est survenue lors de la suppression de l'\u00e9critures [" + tmp[0] + "].", e);
                            }
                            ++i;
                        }
                        return null;
                    }
                };
                try {
                    SQLUtils.executeAtomic(base.getDataSource(), sqlFactory);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        } else {
            ExceptionHandler.handle("Impossible de supprimer le mouvement n\u00b0" + rowMvt.getInt("NUMERO") + " car il est valid\u00e9.");
        }
    }

    @Override
    protected void archive(SQLRow row, boolean cutLinks) throws SQLException {
        System.err.println("Archivage des \u00e9critures");
        PanelFrame frame = new PanelFrame(new SuppressionEcrituresPanel(row.getInt("ID_MOUVEMENT")), "Suppression d'ecritures");
        frame.pack();
        frame.setResizable(false);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public void archiveEcriture(SQLRow row) throws SQLException {
        if (!row.getBoolean("VALIDE").booleanValue()) {
            SQLRowValues rowVals = new SQLRowValues(this.getTable());
            rowVals.put("IDUSER_DELETE", UserManager.getInstance().getCurrentUser().getId());
            rowVals.update(row.getID());
            super.archive(row, true);
        } else {
            System.err.println("Impossible de supprimer une ecriture valid\u00e9e");
            JOptionPane.showMessageDialog(null, "Impossible de supprimer une ecriture valid\u00e9e. \n" + row);
        }
    }

    public static void contrePassationPiece(int id) {
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable tableEcriture = base.getTable("ECRITURE");
        SQLRow rowEcr = tableEcriture.getRow(id);
        final int idMvt = rowEcr.getInt("ID_MOUVEMENT");
        System.err.println("ID MOUVEMENT --> " + idMvt);
        if (frameSaisieKm == null) {
            frameSaisieKm = new EditFrame(Configuration.getInstance().getDirectory().getElement("SAISIE_KM"));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SaisieKmSQLElement.loadContrePassation(frameSaisieKm.getSQLComponent(), idMvt);
            }
        });
        frameSaisieKm.setVisible(true);
    }
}

