/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.customer.action;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.customerrelationship.customer.report.FicheClientXmlSheet;
import org.openconcerto.erp.core.sales.invoice.ui.EcheanceRenderer;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.map.model.Ville;
import org.openconcerto.ql.LabelCreator;
import org.openconcerto.ql.QLPrinter;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;

public class ListeDesClientsAction
extends CreateFrameAbstractAction {
    private static SQLTable tableModeReglement = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT").getTable();

    public ListeDesClientsAction() {
        this.putValue("Name", "Liste des clients");
    }

    @Override
    public JFrame createFrame() {
        SQLTable tableClient = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("CLIENT");
        final ListeAddPanel panel = new ListeAddPanel(Configuration.getInstance().getDirectory().getElement(tableClient));
        IListFrame frame = new IListFrame(panel);
        EcheanceRenderer rend = EcheanceRenderer.getInstance();
        JTable jTable = frame.getPanel().getListe().getJTable();
        int i = 0;
        while (i < jTable.getColumnCount()) {
            int realColIndex = frame.getPanel().getListe().getJTable().getColumnModel().getColumn(i).getModelIndex();
            Set<SQLField> fields = frame.getPanel().getListe().getSource().getColumn(realColIndex).getFields();
            if (fields.contains(tableModeReglement.getField("AJOURS"))) {
                jTable.getColumnModel().getColumn(i).setCellRenderer(rend);
            }
            ++i;
        }
        final String property = PrinterNXProps.getInstance().getProperty("QLPrinter");
        panel.getListe().getJTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                final SQLRow row = panel.getListe().getSelectedRow();
                if (row != null && e.getButton() == 3) {
                    JPopupMenu menuDroit = new JPopupMenu();
                    if (property != null && property.trim().length() > 0) {
                        menuDroit.add(new AbstractAction("Imprimer l'\u00e9tiquette client"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                String[] s;
                                LabelCreator c = new LabelCreator(720);
                                c.setLeftMargin(10);
                                c.setTopMargin(10);
                                c.setDefaultFont(new Font("Verdana", 0, 50));
                                c.addLineBold(row.getString("NOM"));
                                SQLRow foreignRow = row.getForeignRow("ID_ADRESSE");
                                String string = foreignRow.getString("RUE");
                                String[] stringArray = s = string.split("\n");
                                int n = s.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String string2 = stringArray[n2];
                                    System.err.println(string2);
                                    c.addLineNormal(string2);
                                    ++n2;
                                }
                                Ville v = Ville.getVilleFromVilleEtCode(foreignRow.getString("VILLE"));
                                c.addLineNormal(String.valueOf(v.getCodepostal()) + " " + v.getName());
                                System.err.println("\"" + property + "\"");
                                QLPrinter prt = new QLPrinter(property);
                                try {
                                    prt.print(c.getImage());
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        });
                    }
                    menuDroit.add(new AbstractAction("Cr\u00e9er la fiche client"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            FicheClientXmlSheet sheet = new FicheClientXmlSheet(row);
                            sheet.genere(true, false);
                        }
                    });
                    menuDroit.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        panel.setSearchFullMode(true);
        panel.setSelectRowOnAdd(false);
        return frame;
    }
}

