/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.model.PrixHT;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.GestionDevise;

public class TotalPanel
extends JPanel
implements TableModelListener {
    private RowValuesTable table;
    private int columnIndexHT;
    private int columnIndexTTC;
    private int columnIndexService;
    private int columnIndexHA;
    private int columnIndexQte;
    private int columnIndexDevise;
    private int columnIndexPoids;
    private DeviseField textTotalHT;
    private DeviseField textTotalHTSel;
    private DeviseField textTotalTVA;
    private DeviseField textTotalTVASel;
    private DeviseField textTotalTTC;
    private DeviseField textTotalTTCSel;
    private DeviseField textPortHT;
    private DeviseField textRemiseHT;
    private JTextField textPoids;
    private DeviseField textTotalDevise;
    private DeviseField textTotalDeviseSel;
    private DeviseField textService;
    private DeviseField textServiceSel;
    private DeviseField textHA;
    private DeviseField textHASel;
    private JTextField marge;
    private JTextField margeSel;
    private boolean gestionHA = false;
    private PropertyChangeSupport supp = new PropertyChangeSupport(this);
    private int columnIndexEchHT = -1;
    private int columnIndexEchTTC = -1;

    public TotalPanel(RowValuesTable table, SQLTableElement ht, SQLTableElement ttc, SQLTableElement ha, SQLTableElement qte, DeviseField textTotalHT, DeviseField textTotalTVA, DeviseField textTotalTTC, DeviseField textPortHT, DeviseField textRemiseHT, DeviseField textService, SQLTableElement serv, DeviseField textTotalDevise, SQLTableElement devise, JTextField textTotalPoids, SQLTableElement poids) {
        this(table, ht, ttc, ha, qte, textTotalHT, textTotalTVA, textTotalTTC, textPortHT, textRemiseHT, textService, serv, null, null, textTotalDevise, devise, textTotalPoids, poids);
    }

    public TotalPanel(RowValuesTable table, SQLTableElement ht, SQLTableElement ttc, SQLTableElement ha, SQLTableElement qte, DeviseField textTotalHT, DeviseField textTotalTVA, DeviseField textTotalTTC, DeviseField textPortHT, DeviseField textRemiseHT, DeviseField textService, SQLTableElement serv, JPanel tableEchantillon, DeviseField textTotalHA, DeviseField textTotalDevise, SQLTableElement devise, JTextField textTotalPoids, SQLTableElement poids) {
        this.table = table;
        this.columnIndexHT = this.table.getRowValuesTableModel().getColumnIndexForElement(ht);
        this.columnIndexTTC = this.table.getRowValuesTableModel().getColumnIndexForElement(ttc);
        this.columnIndexDevise = devise == null ? -1 : this.table.getRowValuesTableModel().getColumnIndexForElement(devise);
        this.columnIndexService = this.table.getRowValuesTableModel().getColumnIndexForElement(serv);
        this.columnIndexPoids = this.table.getRowValuesTableModel().getColumnIndexForElement(poids);
        boolean bl = this.gestionHA = ha != null && qte != null;
        if (this.gestionHA) {
            this.columnIndexHA = this.table.getRowValuesTableModel().getColumnIndexForElement(ha);
            this.columnIndexQte = this.table.getRowValuesTableModel().getColumnIndexForElement(qte);
        }
        this.textPoids = textTotalPoids;
        this.textTotalHT = textTotalHT;
        this.textTotalHT.setBold();
        this.textTotalTVA = textTotalTVA;
        this.textTotalTTC = textTotalTTC;
        this.textPortHT = textPortHT;
        this.textRemiseHT = textRemiseHT;
        this.textService = textService;
        this.textHA = textTotalHA == null ? new DeviseField() : textTotalHA;
        this.textHASel = new DeviseField();
        this.textTotalHTSel = new DeviseField(true);
        this.textServiceSel = new DeviseField();
        this.textTotalTTCSel = new DeviseField();
        this.textTotalTVASel = new DeviseField();
        this.marge = new JTextField();
        this.margeSel = new JTextField();
        if (devise != null) {
            this.textTotalDevise = textTotalDevise;
            this.textTotalDeviseSel = new DeviseField();
            this.reconfigure(this.textTotalDevise);
            this.reconfigure(this.textTotalDeviseSel);
        }
        this.reconfigure(this.textTotalHT);
        this.reconfigure(this.textTotalTVA);
        this.reconfigure(this.textTotalTTC);
        this.reconfigure(this.textService);
        this.reconfigure(this.textHA);
        this.reconfigure(this.marge);
        this.reconfigure(this.textTotalHTSel);
        this.reconfigure(this.textTotalTVASel);
        this.reconfigure(this.textTotalTTCSel);
        this.reconfigure(this.textServiceSel);
        this.reconfigure(this.textHASel);
        this.reconfigure(this.margeSel);
        String val = DefaultNXProps.getInstance().getStringProperty("ArticleService");
        Boolean b = Boolean.valueOf(val);
        if (this.columnIndexHT < 0 || this.columnIndexTTC < 0 || b != null && b.booleanValue() && this.columnIndexService < 0) {
            throw new IllegalArgumentException("Impossible de trouver la colonne de " + ht + " / " + ttc + " / " + serv);
        }
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridheight = 1;
        c.weighty = 0.0;
        c.fill = 2;
        ++c.gridx;
        this.add((Component)new JLabelBold("S\u00e9lection"), c);
        ++c.gridy;
        c.gridx = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 1;
        this.add((Component)this.createSeparator(), c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 2;
        if (this.gestionHA) {
            ++c.gridy;
            this.add((Component)new JLabel("Total HA HT"), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.textHASel, c);
            ++c.gridy;
            c.gridx = 1;
            c.weightx = 0.0;
            this.add((Component)new JLabel("Marge"), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.margeSel, c);
            ++c.gridy;
            c.gridx = 1;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.fill = 1;
            this.add((Component)this.createSeparator(), c);
            c.gridwidth = 1;
            c.weightx = 0.0;
        }
        ++c.gridy;
        c.gridx = 1;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)TotalPanel.getLabelBoldFor(textTotalHT.getField()), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textTotalHTSel, c);
        c.gridx = 1;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Service HT inclus "), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textServiceSel, c);
        c.gridx = 1;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)TotalPanel.getLabelFor(textTotalTVA.getField()), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textTotalTVASel, c);
        c.gridx = 1;
        ++c.gridy;
        c.gridwidth = 2;
        c.fill = 1;
        this.add((Component)this.createSeparator(), c);
        if (devise != null) {
            c.gridwidth = 1;
            c.gridx = 1;
            ++c.gridy;
            c.weightx = 0.0;
            c.fill = 2;
            this.add((Component)TotalPanel.getLabelFor(textTotalDevise.getField()), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.textTotalDeviseSel, c);
        }
        c.gridwidth = 1;
        c.gridx = 1;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)TotalPanel.getLabelFor(textTotalTTC.getField()), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textTotalTTCSel, c);
        c.gridx = 3;
        c.gridy = 0;
        c.gridheight = 0;
        c.weighty = 1.0;
        c.fill = 3;
        c.weightx = 0.0;
        this.add((Component)this.createSeparator(), c);
        c.gridheight = 1;
        c.fill = 2;
        c.weighty = 0.0;
        ++c.gridx;
        this.add((Component)new JLabelBold("Global"), c);
        ++c.gridy;
        c.gridx = 4;
        c.gridwidth = 2;
        c.weightx = 1.0;
        this.add((Component)this.createSeparator(), c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        if (this.gestionHA) {
            ++c.gridy;
            this.add((Component)new JLabel("Total HA HT"), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.textHA, c);
            ++c.gridy;
            c.gridx = 4;
            c.weightx = 0.0;
            this.add((Component)new JLabel("Marge"), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.marge, c);
            ++c.gridy;
            c.gridx = 4;
            c.gridwidth = 2;
            c.weightx = 1.0;
            this.add((Component)this.createSeparator(), c);
            c.gridwidth = 1;
            c.weightx = 0.0;
        }
        ++c.gridy;
        c.gridx = 4;
        c.weightx = 0.0;
        this.add((Component)TotalPanel.getLabelBoldFor(textTotalHT.getField()), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)textTotalHT, c);
        c.gridx = 4;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)new JLabelBold("Service HT inclus "), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textService, c);
        c.gridx = 4;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)TotalPanel.getLabelBoldFor(textTotalTVA.getField()), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)textTotalTVA, c);
        c.gridwidth = 2;
        c.gridx = 4;
        ++c.gridy;
        c.weightx = 1.0;
        c.fill = 1;
        this.add((Component)this.createSeparator(), c);
        if (devise != null) {
            c.gridwidth = 1;
            c.gridx = 4;
            ++c.gridy;
            c.weightx = 0.0;
            c.fill = 2;
            this.add((Component)TotalPanel.getLabelBoldFor(textTotalDevise.getField()), c);
            ++c.gridx;
            c.weightx = 1.0;
            textTotalDevise.setFont(textTotalHT.getFont());
            this.add((Component)textTotalDevise, c);
        }
        c.gridwidth = 1;
        c.gridx = 4;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)TotalPanel.getLabelBoldFor(textTotalTTC.getField()), c);
        ++c.gridx;
        c.weightx = 1.0;
        textTotalTTC.setFont(textTotalHT.getFont());
        this.add((Component)textTotalTTC, c);
        this.updateTotal();
        this.table.getRowValuesTableModel().addTableModelListener(this);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TotalPanel.this.updateTotal();
            }
        });
    }

    private void reconfigure(JTextField field) {
        field.setEditable(false);
        field.setHorizontalAlignment(4);
        field.setBorder(null);
        field.setColumns(11);
        field.setOpaque(true);
        field.setMinimumSize(new Dimension(150, 20));
        field.setPreferredSize(new Dimension(150, 20));
        field.setBackground(UIManager.getColor("control"));
        field.setEditable(false);
        field.setEnabled(false);
        field.setDisabledTextColor(Color.BLACK);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getColumn() == -1 || e.getColumn() == this.columnIndexHT || e.getColumn() == this.columnIndexTTC || e.getColumn() == this.columnIndexEchHT || e.getColumn() == this.columnIndexEchTTC || e.getColumn() == this.columnIndexDevise) {
            this.updateTotal();
        }
    }

    public void updateTotal() {
        try {
            long totalHT = 0L;
            long totalHA = 0L;
            long totalTTC = 0L;
            long totalService = 0L;
            long totalHTSel = 0L;
            long totalHASel = 0L;
            long totalTTCSel = 0L;
            long totalServiceSel = 0L;
            long totalDeviseSel = 0L;
            long totalDevise = 0L;
            double totalPoids = 0.0;
            int[] selectedRows = this.table.getSelectedRows();
            int i = 0;
            while (i < this.table.getRowValuesTableModel().getRowCount()) {
                Boolean b;
                String val;
                Boolean bServiceActive;
                Number nHT = (Number)this.table.getRowValuesTableModel().getValueAt(i, this.columnIndexHT);
                totalHT += nHT.longValue();
                if (this.gestionHA) {
                    Number nHA = (Number)this.table.getRowValuesTableModel().getValueAt(i, this.columnIndexHA);
                    Number nQte = (Number)this.table.getRowValuesTableModel().getValueAt(i, this.columnIndexQte);
                    totalHA += nHA.longValue() * (long)nQte.intValue();
                }
                if ((bServiceActive = Boolean.valueOf(val = DefaultNXProps.getInstance().getStringProperty("ArticleService"))) != null && bServiceActive.booleanValue() && (b = (Boolean)this.table.getRowValuesTableModel().getValueAt(i, this.columnIndexService)) != null && b.booleanValue()) {
                    totalService += nHT.longValue();
                }
                Number nDevise = null;
                if (this.textTotalDevise != null) {
                    nDevise = (Number)this.table.getRowValuesTableModel().getValueAt(i, this.columnIndexDevise);
                    totalDevise += nDevise.longValue();
                }
                Number nTTC = (Number)this.table.getRowValuesTableModel().getValueAt(i, this.columnIndexTTC);
                totalTTC += nTTC.longValue();
                Number nPoids = (Number)this.table.getRowValuesTableModel().getValueAt(i, this.columnIndexPoids);
                totalPoids += nPoids.doubleValue();
                if (TotalPanel.containsInt(selectedRows, i)) {
                    Boolean b2;
                    totalHTSel += nHT.longValue();
                    if (this.gestionHA) {
                        Number nHA = (Number)this.table.getRowValuesTableModel().getValueAt(i, this.columnIndexHA);
                        Number nQte = (Number)this.table.getRowValuesTableModel().getValueAt(i, this.columnIndexQte);
                        totalHASel += nHA.longValue() * (long)nQte.intValue();
                    }
                    if (bServiceActive != null && bServiceActive.booleanValue() && (b2 = (Boolean)this.table.getRowValuesTableModel().getValueAt(i, this.columnIndexService)).booleanValue()) {
                        totalServiceSel += nHT.longValue();
                    }
                    totalTTCSel += nTTC.longValue();
                    if (this.textTotalDevise != null) {
                        totalDeviseSel += nDevise.longValue();
                    }
                }
                ++i;
            }
            long valPortHT = this.textPortHT.getText().trim().length() > 0 ? (!this.textPortHT.getText().trim().equals("-") ? GestionDevise.parseLongCurrency(this.textPortHT.getText().trim()) : 0L) : 0L;
            long valRemiseHT = this.textRemiseHT.getText().trim().length() > 0 ? (!this.textRemiseHT.getText().trim().equals("-") ? GestionDevise.parseLongCurrency(this.textRemiseHT.getText().trim()) : 0L) : 0L;
            long realTotalHT = totalHT + valPortHT - valRemiseHT;
            long portTTC = new PrixHT(valPortHT).calculLongTTC(0.196f);
            long remiseTTC = new PrixHT(valRemiseHT).calculLongTTC(0.196f);
            long realTotalTTC = totalTTC + portTTC - remiseTTC;
            if (this.textTotalDevise != null) {
                this.textTotalDevise.setText(GestionDevise.currencyToString(totalDevise));
                this.textTotalDeviseSel.setText(GestionDevise.currencyToString(totalDeviseSel));
            }
            this.textPoids.setText(String.valueOf(totalPoids));
            this.textTotalHT.setText(GestionDevise.currencyToString(realTotalHT));
            this.textService.setText(GestionDevise.currencyToString(totalService));
            this.textTotalTVA.setText(GestionDevise.currencyToString(realTotalTTC - realTotalHT));
            this.textTotalTTC.setText(GestionDevise.currencyToString(realTotalTTC));
            this.textTotalHTSel.setText(GestionDevise.currencyToString(totalHTSel));
            this.textServiceSel.setText(GestionDevise.currencyToString(totalServiceSel));
            this.textTotalTVASel.setText(GestionDevise.currencyToString(totalTTCSel - totalHTSel));
            this.textTotalTTCSel.setText(GestionDevise.currencyToString(totalTTCSel));
            if (this.gestionHA) {
                this.textHA.setText(GestionDevise.currencyToString(totalHA));
                double m = 0.0;
                long d = 0L;
                if (totalHA > 0L) {
                    d = totalHT - valRemiseHT - totalHA;
                    m = (double)Math.round((double)d / (double)totalHA * 10000.0) / 100.0;
                }
                this.marge.setText("(" + m + "%) " + GestionDevise.currencyToString(d));
                this.textHASel.setText(GestionDevise.currencyToString(totalHASel));
                double m2 = 0.0;
                long e = 0L;
                if (totalHASel > 0L) {
                    e = totalHTSel - totalHASel;
                    m2 = (double)Math.round((double)e / (double)totalHASel * 10000.0) / 100.0;
                }
                this.margeSel.setText("(" + m2 + "%) " + GestionDevise.currencyToString(e));
            }
            this.supp.firePropertyChange("value", null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean containsInt(int[] tab, int i) {
        if (tab == null) {
            return false;
        }
        int j = 0;
        while (j < tab.length) {
            if (tab[j] == i) {
                return true;
            }
            ++j;
        }
        return false;
    }

    private static final JLabel getLabelFor(SQLField field) {
        return new JLabel(Configuration.getInstance().getTranslator().getLabelFor(field));
    }

    private static final JLabel getLabelBoldFor(SQLField field) {
        return new JLabelBold(Configuration.getInstance().getTranslator().getLabelFor(field));
    }

    public void addValueListener(PropertyChangeListener listener) {
        this.supp.addPropertyChangeListener(listener);
    }

    public void removeValueListener(PropertyChangeListener listener) {
        this.supp.removePropertyChangeListener(listener);
    }

    private final JSeparator createSeparator() {
        JSeparator sep = new JSeparator(0);
        DefaultGridBagConstraints.lockMinimumSize(sep);
        return sep;
    }
}

