/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Window;
import java.io.File;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;

public abstract class RowValuesMultiLineEditTable
extends RowValuesTable {
    private RowValuesTable tableRoot;
    private SQLRowValues rowValsRoot;
    private int indexRowRoot;
    private String foreignField;
    private String field;

    public RowValuesMultiLineEditTable(RowValuesTableModel model, File f, String field) {
        super(model, f);
        this.field = field;
    }

    public void closeTable() {
        Window window = (Window)SwingUtilities.getRoot(this);
        TableCellEditor editor = this.tableRoot.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
        String string = this.getStringValue(this.tableRoot.getRowValuesTableModel().getRowValuesAt(this.indexRowRoot));
        this.tableRoot.getRowValuesTableModel().putValue(string, this.indexRowRoot, this.field);
        this.tableRoot.revalidate();
        this.tableRoot.repaint();
        if (window != null) {
            window.setVisible(false);
            window.dispose();
        }
    }

    public String getStringValue() {
        return this.getStringValue(this.rowValsRoot);
    }

    public abstract String getStringValue(SQLRowValues var1);

    public void setRoots(RowValuesTable tableRoot, int row, SQLRowValues rowVals) {
        this.rowValsRoot = rowVals;
        this.indexRowRoot = row;
        this.tableRoot = tableRoot;
        Set<SQLField> s = this.getRowValuesTableModel().getSQLElement().getTable().getForeignKeys(rowVals.getTable());
        if (s == null || s.size() <= 0) {
            throw new IllegalArgumentException("La table " + rowVals.getTable().getName() + " n'est pas r\u00e9f\u00e9renc\u00e9e par la table " + this.getRowValuesTableModel().getSQLElement().getTable());
        }
        this.foreignField = ((SQLField)s.toArray()[0]).getName();
        this.insertFrom(this.foreignField, rowVals);
    }

    public SQLRowValues getRowValuesRoot() {
        return this.rowValsRoot;
    }

    public String getForeignField() {
        return this.foreignField;
    }
}

