/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.sqlobject.ISQLElementWithCodeSelector;
import org.openconcerto.ui.JMultiLineToolTip;

public class ISQLElementInfosSelector
extends ISQLElementWithCodeSelector {
    private static String tooltipTextDefault = "Attention, infos compl\u00e9mentaires : ";
    private static String tooltipText = "";
    private Thread blink;

    public ISQLElementInfosSelector(SQLElement e, SQLField optField) {
        super(e, optField);
        this.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                SQLElement elt;
                SQLRow row;
                String infos;
                int id = ISQLElementInfosSelector.this.getValue();
                if (id > 1 && (infos = (row = (elt = ISQLElementInfosSelector.this.getSQLElement()).getTable().getRow(id)).getString("INFOS")).trim().length() > 0) {
                    tooltipText = String.valueOf(tooltipTextDefault) + infos;
                    ISQLElementInfosSelector.this.runBlink();
                    return;
                }
                ISQLElementInfosSelector.this.stopBlink();
            }
        });
    }

    private void stopBlink() {
        if (this.blink != null && this.blink.isAlive()) {
            this.blink.interrupt();
        }
        this.getViewButton().setToolTipText(null);
        this.setViewButtonDefaultIcon();
    }

    private void runBlink() {
        if (this.blink == null || !this.blink.isAlive()) {
            this.blink = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(700L);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (ISQLElementInfosSelector.this.getViewButton().getIcon() == null) {
                                    ISQLElementInfosSelector.this.setViewButtonDefaultIcon();
                                } else {
                                    ISQLElementInfosSelector.this.getViewButton().setIcon(null);
                                }
                            }
                        });
                    }
                }
            };
            this.blink.start();
        }
        this.getViewButton().setToolTipText(tooltipText);
        if (this.isShowing()) {
            JMultiLineToolTip toolTipMultiLine = new JMultiLineToolTip();
            toolTipMultiLine.setTipText(tooltipText);
            final Popup tooltip1 = PopupFactory.getSharedInstance().getPopup(this.getViewButton(), toolTipMultiLine, this.getViewButton().getLocationOnScreen().x, this.getViewButton().getLocationOnScreen().y + 7);
            tooltip1.show();
            new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    tooltip1.hide();
                    ISQLElementInfosSelector.this.getViewButton().setToolTipText(tooltipText);
                }
            }.start();
        }
    }
}

