/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.Tuple2;

public class IListTotalPanel
extends JPanel {
    EventListenerList loadingListener = new EventListenerList();
    private final IListe list;
    private final Map<SQLField, JLabel> map = new HashMap<SQLField, JLabel>();

    public IListTotalPanel(IListe l, List<SQLField> listField) {
        this(l, listField, null, null);
    }

    public IListTotalPanel(IListe l, final List<SQLField> listField, final List<Tuple2<SQLField, ?>> filters, String title) {
        super(new GridBagLayout());
        this.list = l;
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = -1;
        c.weightx = 0.0;
        if (title != null && title.trim().length() > 0) {
            TitledSeparator sep = new TitledSeparator(title);
            c.weightx = 1.0;
            c.gridwidth = 0;
            this.add((Component)sep, c);
            ++c.gridy;
            c.gridwidth = 1;
        }
        for (SQLField field2 : listField) {
            c.weightx = 0.0;
            this.add((Component)new JLabelBold(Configuration.getTranslator(field2.getTable()).getDescFor(field2.getTable(), field2.getName()).getLabel()), c);
            JLabelBold textField = new JLabelBold("0");
            this.map.put(field2, textField);
            c.weightx = 1.0;
            this.add((Component)textField, c);
            this.add((Component)new JLabelBold("\u20ac"), c);
            ++c.gridy;
        }
        this.list.addListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                HashMap<SQLField, Long> mapTotal = new HashMap<SQLField, Long>();
                int i = 0;
                while (i < IListTotalPanel.this.list.getRowCount()) {
                    SQLRowValues rowAt = ITableModel.getLine(IListTotalPanel.this.list.getModel(), i).getRow();
                    for (SQLField field : listField) {
                        Long n = (Long)mapTotal.get(field);
                        Long n2 = (Long)rowAt.getObject(field.getName());
                        boolean in = true;
                        if (filters != null) {
                            for (Tuple2 tuple2 : filters) {
                                boolean bl = in = in && rowAt.getObject(((SQLField)tuple2.get0()).getName()).equals(tuple2.get1());
                            }
                        }
                        if (!in) continue;
                        if (n == null) {
                            mapTotal.put(field, n2);
                            continue;
                        }
                        mapTotal.put(field, n + n2);
                    }
                    ++i;
                }
                for (SQLField field : listField) {
                    Long l = (Long)mapTotal.get(field);
                    if (l != null) {
                        ((JLabel)IListTotalPanel.this.map.get(field)).setText(GestionDevise.currencyToString(l));
                        continue;
                    }
                    ((JLabel)IListTotalPanel.this.map.get(field)).setText(GestionDevise.currencyToString(0L));
                }
                IListTotalPanel.this.fireUpdated();
            }
        });
    }

    public void fireUpdated() {
        PropertyChangeListener[] propertyChangeListenerArray = (PropertyChangeListener[])this.loadingListener.getListeners(PropertyChangeListener.class);
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener l = propertyChangeListenerArray[n2];
            l.propertyChange(null);
            ++n2;
        }
    }

    public void addListener(PropertyChangeListener l) {
        this.loadingListener.add(PropertyChangeListener.class, l);
    }

    public JLabel getTotal(SQLField field) {
        return this.map.get(field);
    }
}

