/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.apache.commons.collections.Predicate;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.MutableRowItemView;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.checks.EmptyListener;
import org.openconcerto.utils.checks.EmptyObject;
import org.openconcerto.utils.checks.EmptyObjectHelper;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.doc.Documented;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class DeviseField
extends JTextField
implements EmptyObject,
MutableRowItemView,
Documented {
    private boolean completing = false;
    private final boolean autoCompletion;
    private SQLField field;
    private String sqlName;
    private String label;
    private List<String> items;
    private EmptyObjectHelper helper;
    private final PropertyChangeSupport supp;
    private boolean gained;
    private boolean mousePressed;
    private String initialText;

    public DeviseField() {
        this(15, false, false);
    }

    public DeviseField(boolean bold) {
        this(15, false, bold);
    }

    public DeviseField(int columns) {
        this(columns, false);
    }

    private DeviseField(int columns, boolean autoCompletion) {
        this(columns, autoCompletion, false);
    }

    private DeviseField(int columns, boolean autoCompletion, boolean bold) {
        super(columns);
        if (bold) {
            this.setFont(this.getFont().deriveFont(1));
        }
        this.supp = new PropertyChangeSupport(this);
        this.gained = false;
        this.autoCompletion = autoCompletion;
        this.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                DeviseField.this.textModified();
            }
        });
    }

    protected void textModified() {
        if (this.autoCompletion) {
            this.complete();
        }
        this.supp.firePropertyChange("value", null, this.getUncheckedValue());
    }

    @Override
    public void init(String sqlName, Set<SQLField> fields) {
        this.field = CollectionUtils.getSole(fields);
        this.sqlName = sqlName;
        this.helper = new EmptyObjectHelper(this, new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                return object == null;
            }
        });
        DeviseField.addFilteringKeyListener(this);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DeviseField.this.gained = true;
                DeviseField.this.initialText = DeviseField.this.getText();
                if (!DeviseField.this.mousePressed) {
                    DeviseField.this.selectAll();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DeviseField.this.mousePressed = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (DeviseField.this.gained && DeviseField.this.getSelectedText() == null) {
                    DeviseField.this.selectAll();
                }
                DeviseField.this.gained = false;
                DeviseField.this.mousePressed = false;
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u001b') {
                    DeviseField.this.setValue(DeviseField.this.initialText);
                    DeviseField.this.selectAll();
                }
            }
        });
    }

    public static void addFilteringKeyListener(final JTextField textField) {
        textField.addKeyListener(new KeyAdapter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void keyTyped(KeyEvent keyEvent) {
                char keychar = keyEvent.getKeyChar();
                if (keychar == '\b') {
                    return;
                }
                int pointPosition = textField.getText().indexOf(46);
                if (Character.isDigit(keychar)) {
                    if (pointPosition <= -1) return;
                    if (textField.getSelectedText() != null) return;
                    if (textField.getCaretPosition() <= pointPosition) {
                        return;
                    }
                    if (textField.getText().substring(pointPosition).length() <= 2) {
                        return;
                    }
                }
                if (keychar == '.' && textField.getText().indexOf(46) < 0) {
                    return;
                }
                keyEvent.consume();
            }
        });
    }

    @Override
    public String getDescription() {
        return this.label;
    }

    @Override
    public void setDescription(String s) {
        this.label = s;
    }

    @Override
    public final void resetValue() {
        this.setValue("");
    }

    public final void setValue(String val) {
        if (!this.getText().equals(val)) {
            this.setText(val);
        }
    }

    public void setBold() {
        this.setFont(this.getFont().deriveFont(1));
    }

    @Override
    public Object getUncheckedValue() {
        if (this.getText().trim().length() == 0) {
            return null;
        }
        return new Long(GestionDevise.parseLongCurrency(this.getText()));
    }

    public final SQLTable getTable() {
        return this.field.getTable();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " on " + this.field;
    }

    private String getCompletion(String string) {
        int c = 0;
        if (string.length() < 1) {
            return null;
        }
        String result = null;
        int i = 0;
        while (i < this.items.size()) {
            String obj = this.items.get(i);
            if (obj.startsWith(string)) {
                ++c;
                result = obj;
            }
            ++i;
        }
        if (c == 1) {
            return result;
        }
        return null;
    }

    private final void addItem(String string) {
        if (!this.items.contains(string) && string.length() > 1) {
            this.items.add(string);
            this.writeToCache(string);
        }
    }

    private final void checkCache() {
        if (this.items == null) {
            this.items = new Vector<String>(20);
            this.readCache();
        }
    }

    final synchronized void complete() {
        this.checkCache();
        if (!this.completing) {
            String completion;
            this.completing = true;
            String originalText = this.getText();
            if (originalText.length() > 2 && !originalText.matches("^\\d*$") && (completion = this.getCompletion(originalText)) != null && !this.getText().trim().equalsIgnoreCase(completion.trim())) {
                this.setText(completion);
                this.setSelectionStart(originalText.length());
                this.setSelectionEnd(completion.length());
            }
            this.completing = false;
        }
    }

    protected final void addToCache(String s) {
        if (s != null && s.length() > 0 && !this.items.contains(s)) {
            this.items.add(s);
        }
    }

    protected void readCache() {
        String req = "SELECT * FROM COMPLETION WHERE CHAMP=\"" + this.field.getFullName() + "\"";
        ResultSet rs = this.getTable().getBase().execute(req);
        try {
            while (rs.next()) {
                this.addToCache(rs.getString("LABEL"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected void writeToCache(String string) {
        String req = "INSERT INTO COMPLETION (CHAMP,LABEL) VALUES (\"" + this.field.getFullName() + "\",\"" + string + "\")";
        this.getField().getTable().getBase().execute(req);
    }

    @Override
    public Object getValue() {
        return this.helper.getValue();
    }

    @Override
    public boolean isEmpty() {
        return this.helper.isEmpty();
    }

    @Override
    public void addEmptyListener(EmptyListener l) {
        this.helper.addListener(l);
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(l);
    }

    @Override
    public SQLField getField() {
        return this.field;
    }

    @Override
    public boolean isValidated() {
        return true;
    }

    @Override
    public void addValidListener(ValidListener l) {
    }

    @Override
    public void removeValidListener(ValidListener l) {
    }

    @Override
    public void show(SQLRowAccessor r) {
        if (r.getFields().contains(this.getField().getName())) {
            Object o = r.getObject(this.getField().getName());
            this.setValue(GestionDevise.currencyToString((Long)o));
        }
    }

    @Override
    public void insert(SQLRowValues vals) {
        this.update(vals);
    }

    @Override
    public void update(SQLRowValues vals) {
        vals.put(this.getField().getName(), this.isEmpty() ? SQLRowValues.SQL_DEFAULT : this.getUncheckedValue());
    }

    @Override
    public String getSQLName() {
        return this.sqlName;
    }

    @Override
    public Component getComp() {
        return this;
    }

    @Override
    public String getDocId() {
        return "DEVISE";
    }

    @Override
    public String getGenericDoc() {
        return "";
    }

    @Override
    public boolean onScreen() {
        return true;
    }

    @Override
    public boolean isDocTransversable() {
        return false;
    }

    @Override
    public String getValidationText() {
        return "Le montant saisi n'est pas correct";
    }
}

