/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.util.Vector;
import javax.swing.ToolTipManager;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.AbstractArticleItemTable;
import org.openconcerto.erp.core.common.ui.DeviseCellEditor;
import org.openconcerto.erp.core.common.ui.DeviseNiceTableCellRenderer;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.model.PrixHT;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.AutoCompletionManager;
import org.openconcerto.sql.view.list.CellDynamicModifier;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.ui.table.XTableColumnModel;

public abstract class AbstractAchatArticleItemTable
extends AbstractArticleItemTable {
    SQLRowAccessor rowDevise;

    @Override
    protected void init() {
        SQLElement e = this.getSQLElement();
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        list.add(new SQLTableElement(e.getTable().getField("ID_STYLE")));
        SQLTableElement tableElementCode = new SQLTableElement(e.getTable().getField("CODE"));
        list.add(tableElementCode);
        SQLTableElement tableElementNom = new SQLTableElement(e.getTable().getField("NOM"));
        list.add(tableElementNom);
        SQLTableElement tableElement_ValeurMetrique2 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_2"), Float.class);
        list.add(tableElement_ValeurMetrique2);
        SQLTableElement tableElement_ValeurMetrique3 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_3"), Float.class);
        list.add(tableElement_ValeurMetrique3);
        SQLTableElement tableElement_ValeurMetrique1 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_1"), Float.class);
        list.add(tableElement_ValeurMetrique1);
        SQLTableElement tableElement_PrixMetrique1_AchatHT = new SQLTableElement(e.getTable().getField("PRIX_METRIQUE_HA_1"), Long.class, new DeviseCellEditor());
        tableElement_PrixMetrique1_AchatHT.setRenderer(new DeviseNiceTableCellRenderer());
        list.add(tableElement_PrixMetrique1_AchatHT);
        SQLTableElement tableElement_Devise = new SQLTableElement(e.getTable().getField("ID_DEVISE"));
        list.add(tableElement_Devise);
        SQLTableElement tableElement_PA_Devise = new SQLTableElement(e.getTable().getField("PA_DEVISE"), Long.class, new DeviseCellEditor());
        tableElement_PA_Devise.setRenderer(new DeviseNiceTableCellRenderer());
        list.add(tableElement_PA_Devise);
        SQLTableElement tableElement_ModeVente = new SQLTableElement(e.getTable().getField("ID_MODE_VENTE_ARTICLE"));
        list.add(tableElement_ModeVente);
        this.ha = new SQLTableElement(e.getTable().getField("PA_HT"), Long.class, new DeviseCellEditor());
        this.ha.setRenderer(new DeviseNiceTableCellRenderer());
        list.add(this.ha);
        SQLTableElement qteElement = new SQLTableElement(e.getTable().getField("QTE"), Integer.class){

            @Override
            protected Object getDefaultNullValue() {
                return 0;
            }
        };
        list.add(qteElement);
        SQLTableElement tableElement_Taxe = new SQLTableElement(e.getTable().getField("ID_TAXE"));
        list.add(tableElement_Taxe);
        SQLTableElement tableElementPoids = new SQLTableElement(e.getTable().getField("POIDS"), Float.class);
        list.add(tableElementPoids);
        this.tableElementPoidsTotal = new SQLTableElement(e.getTable().getField("T_POIDS"), Float.class);
        list.add(this.tableElementPoidsTotal);
        String val = DefaultNXProps.getInstance().getStringProperty("ArticleService");
        Boolean b = Boolean.valueOf(val);
        if (b != null && b.booleanValue()) {
            this.service = new SQLTableElement(e.getTable().getField("SERVICE"), Boolean.class);
            list.add(this.service);
        }
        this.tableElementTotalDevise = new SQLTableElement(e.getTable().getField("PA_DEVISE_T"), Long.class, new DeviseCellEditor());
        this.tableElementTotalDevise.setRenderer(new DeviseNiceTableCellRenderer());
        list.add(this.tableElementTotalDevise);
        this.totalHT = new SQLTableElement(e.getTable().getField("T_PA_HT"), Long.class, new DeviseCellEditor());
        this.totalHT.setRenderer(new DeviseNiceTableCellRenderer());
        list.add(this.totalHT);
        this.tableElementTotalTTC = new SQLTableElement(e.getTable().getField("T_PA_TTC"), Long.class, new DeviseCellEditor());
        this.tableElementTotalTTC.setRenderer(new DeviseNiceTableCellRenderer());
        list.add(this.tableElementTotalTTC);
        this.model = new RowValuesTableModel(e, list, e.getTable().getField("NOM"));
        this.table = new RowValuesTable(this.model, this.getConfigurationFile());
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
        AutoCompletionManager m = new AutoCompletionManager(tableElementCode, ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getField("ARTICLE.CODE"), this.table, this.table.getRowValuesTableModel()){

            @Override
            protected Object getValueFrom(SQLRow row, String field) {
                Object res = AbstractAchatArticleItemTable.this.tarifCompletion(row, field);
                if (res == null) {
                    return super.getValueFrom(row, field);
                }
                return res;
            }
        };
        m.fill("NOM", "NOM");
        m.fill("PA_HT", "PA_HT");
        m.fill("PV_HT", "PV_HT");
        m.fill("POIDS", "POIDS");
        m.fill("ID_TAXE", "ID_TAXE");
        m.fill("PRIX_METRIQUE_HA_1", "PRIX_METRIQUE_HA_1");
        m.fill("PRIX_METRIQUE_HA_2", "PRIX_METRIQUE_HA_2");
        m.fill("PRIX_METRIQUE_HA_3", "PRIX_METRIQUE_HA_3");
        m.fill("VALEUR_METRIQUE_1", "VALEUR_METRIQUE_1");
        m.fill("VALEUR_METRIQUE_2", "VALEUR_METRIQUE_2");
        m.fill("VALEUR_METRIQUE_3", "VALEUR_METRIQUE_3");
        m.fill("ID_MODE_VENTE_ARTICLE", "ID_MODE_VENTE_ARTICLE");
        m.fill("PRIX_METRIQUE_VT_1", "PRIX_METRIQUE_VT_1");
        m.fill("PRIX_METRIQUE_VT_2", "PRIX_METRIQUE_VT_2");
        m.fill("PRIX_METRIQUE_VT_3", "PRIX_METRIQUE_VT_3");
        m.fill("SERVICE", "SERVICE");
        m.fill("ID_DEVISE_HA", "ID_DEVISE");
        m.fill("PA_DEVISE", "PA_DEVISE");
        AutoCompletionManager m2 = new AutoCompletionManager(tableElementNom, ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getField("ARTICLE.NOM"), this.table, this.table.getRowValuesTableModel()){

            @Override
            protected Object getValueFrom(SQLRow row, String field) {
                Object res = AbstractAchatArticleItemTable.this.tarifCompletion(row, field);
                if (res == null) {
                    return super.getValueFrom(row, field);
                }
                return res;
            }
        };
        m2.fill("CODE", "CODE");
        m2.fill("PA_HT", "PA_HT");
        m2.fill("PV_HT", "PV_HT");
        m2.fill("POIDS", "POIDS");
        m2.fill("ID_TAXE", "ID_TAXE");
        m2.fill("PRIX_METRIQUE_HA_1", "PRIX_METRIQUE_HA_1");
        m2.fill("PRIX_METRIQUE_HA_2", "PRIX_METRIQUE_HA_2");
        m2.fill("PRIX_METRIQUE_HA_3", "PRIX_METRIQUE_HA_3");
        m2.fill("ID_MODE_VENTE_ARTICLE", "ID_MODE_VENTE_ARTICLE");
        m2.fill("VALEUR_METRIQUE_1", "VALEUR_METRIQUE_1");
        m2.fill("VALEUR_METRIQUE_2", "VALEUR_METRIQUE_2");
        m2.fill("VALEUR_METRIQUE_3", "VALEUR_METRIQUE_3");
        m2.fill("PRIX_METRIQUE_VT_1", "PRIX_METRIQUE_VT_1");
        m2.fill("PRIX_METRIQUE_VT_2", "PRIX_METRIQUE_VT_2");
        m2.fill("PRIX_METRIQUE_VT_3", "PRIX_METRIQUE_VT_3");
        m2.fill("SERVICE", "SERVICE");
        m2.fill("ID_DEVISE_HA", "ID_DEVISE");
        m2.fill("PA_DEVISE", "PA_DEVISE");
        qteElement.addModificationListener(this.totalHT);
        this.ha.addModificationListener(this.totalHT);
        this.totalHT.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                int qte = Integer.parseInt(row.getObject("QTE").toString());
                Number f = (Number)row.getObject("PA_HT");
                System.err.println("Qte:" + qte + " et PA_HT:" + f);
                long r = f.longValue() * (long)qte;
                return new Long(r);
            }
        });
        qteElement.addModificationListener(this.tableElementTotalDevise);
        tableElement_PA_Devise.addModificationListener(this.tableElementTotalDevise);
        this.tableElementTotalDevise.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                int qte = Integer.parseInt(row.getObject("QTE").toString());
                Number f = (Number)row.getObject("PA_DEVISE");
                long r = f.longValue() * (long)qte;
                return new Long(r);
            }
        });
        qteElement.addModificationListener(this.tableElementTotalTTC);
        this.ha.addModificationListener(this.tableElementTotalTTC);
        tableElement_Taxe.addModificationListener(this.tableElementTotalTTC);
        this.tableElementTotalTTC.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                int qte = Integer.parseInt(row.getObject("QTE").toString());
                Number f = (Number)row.getObject("PA_HT");
                int idTaux = Integer.parseInt(row.getObject("ID_TAXE").toString());
                if (idTaux < 0) {
                    System.out.println(row);
                }
                Float resultTaux = TaxeCache.getCache().getTauxFromId(idTaux);
                PrixHT pHT = new PrixHT(f.longValue() * (long)qte);
                float taux = resultTaux == null ? 0.0f : resultTaux.floatValue();
                Long r = new Long(pHT.calculLongTTC(taux / 100.0f));
                return r;
            }
        });
        this.table.readState();
        String valModeAvanceVt = DefaultNXProps.getInstance().getStringProperty("ArticleModeVenteAvance");
        Boolean bModeAvance = Boolean.valueOf(valModeAvanceVt);
        if (bModeAvance != null && !bModeAvance.booleanValue()) {
            this.hideColumn(this.model.getColumnForField("VALEUR_METRIQUE_1"));
            this.hideColumn(this.model.getColumnForField("VALEUR_METRIQUE_2"));
            this.hideColumn(this.model.getColumnForField("VALEUR_METRIQUE_3"));
            this.hideColumn(this.model.getColumnForField("PRIX_METRIQUE_VT_1"));
            this.hideColumn(this.model.getColumnForField("ID_MODE_VENTE_ARTICLE"));
            this.hideColumn(this.model.getColumnForField("PA_HT"));
        }
        tableElement_ValeurMetrique1.addModificationListener(tableElementPoids);
        tableElement_ValeurMetrique2.addModificationListener(tableElementPoids);
        tableElement_ValeurMetrique3.addModificationListener(tableElementPoids);
        tableElementPoids.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                return new Float(ReferenceArticleSQLElement.getPoidsFromDetails(row));
            }
        });
        tableElementPoids.addModificationListener(this.tableElementPoidsTotal);
        qteElement.addModificationListener(this.tableElementPoidsTotal);
        this.tableElementPoidsTotal.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                System.err.println("Calcul du poids total ");
                Number f = (Number)row.getObject("POIDS");
                int qte = Integer.parseInt(row.getObject("QTE").toString());
                return new Float(f.floatValue() * (float)qte);
            }
        });
        tableElement_ValeurMetrique1.addModificationListener(this.ha);
        tableElement_ValeurMetrique2.addModificationListener(this.ha);
        tableElement_ValeurMetrique3.addModificationListener(this.ha);
        tableElement_PrixMetrique1_AchatHT.addModificationListener(this.ha);
        this.ha.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                if (row.getInt("ID_MODE_VENTE_ARTICLE") == 5) {
                    return ((Number)row.getObject("PRIX_METRIQUE_HA_1")).longValue();
                }
                long prixHAFromDetails = ReferenceArticleSQLElement.getPrixHAFromDetails(row);
                return prixHAFromDetails;
            }
        });
        this.table.writeState();
    }

    private Object tarifCompletion(SQLRow row, String field) {
        if (this.getDevise() != null && !this.getDevise().isUndefined()) {
            if (field.equalsIgnoreCase("ID_DEVISE") || field.equalsIgnoreCase("ID_DEVISE_HA")) {
                return this.getDevise().getID();
            }
            if (field.equalsIgnoreCase("PA_DEVISE")) {
                return row.getObject("PA_DEVISE");
            }
        } else {
            if (field.equalsIgnoreCase("ID_DEVISE") || field.equalsIgnoreCase("ID_DEVISE_HA")) {
                return Configuration.getInstance().getDirectory().getElement("DEVISE").getTable().getUndefinedID();
            }
            if (field.equalsIgnoreCase("PA_DEVISE")) {
                return 0L;
            }
        }
        return null;
    }

    public SQLRowAccessor getDevise() {
        return this.rowDevise;
    }

    public void setDevise(SQLRowAccessor deviseRow) {
        this.rowDevise = deviseRow;
    }

    private void hideColumn(int col) {
        if (col >= 0) {
            XTableColumnModel columnModel = this.table.getColumnModel();
            columnModel.setColumnVisible(columnModel.getColumnByModelIndex(col), false);
        }
    }
}

