/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.image.ImageIconWarning;
import org.openconcerto.erp.core.customerrelationship.customer.element.CourrierClientSQLElement;
import org.openconcerto.erp.core.customerrelationship.customer.element.RelanceSQLElement;
import org.openconcerto.erp.core.humanresources.payroll.element.SalarieSQLElement;
import org.openconcerto.erp.core.sales.credit.element.AvoirClientSQLElement;
import org.openconcerto.erp.core.sales.invoice.element.SaisieVenteFactureSQLElement;
import org.openconcerto.erp.core.sales.order.element.CommandeClientSQLElement;
import org.openconcerto.erp.core.sales.quote.element.DevisSQLElement;
import org.openconcerto.erp.core.sales.shipment.element.BonDeLivraisonSQLElement;
import org.openconcerto.erp.core.supplychain.order.element.CommandeSQLElement;
import org.openconcerto.erp.core.supplychain.receipt.element.BonReceptionSQLElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.model.Where;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class NumerotationAutoSQLElement
extends ComptaSQLConfElement {
    private static final String FORMAT = "_FORMAT";
    private static final String START = "_START";
    protected static final SQLTable TABLE_NUM = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("NUMEROTATION_AUTO");
    private static Map<Class<? extends SQLElement>, String> map = new HashMap<Class<? extends SQLElement>, String>();

    static {
        map.put(AvoirClientSQLElement.class, "AVOIR");
        map.put(SaisieVenteFactureSQLElement.class, "FACT");
        map.put(AvoirClientSQLElement.class, "AVOIR");
        map.put(DevisSQLElement.class, "DEVIS");
        map.put(BonDeLivraisonSQLElement.class, "BON_L");
        map.put(BonReceptionSQLElement.class, "BON_R");
        map.put(CommandeClientSQLElement.class, "COMMANDE_CLIENT");
        map.put(CommandeSQLElement.class, "COMMANDE");
        map.put(CourrierClientSQLElement.class, "COURRIER");
        map.put(RelanceSQLElement.class, "RELANCE");
        map.put(SalarieSQLElement.class, "SALARIE");
    }

    public NumerotationAutoSQLElement() {
        super("NUMEROTATION_AUTO", "une num\u00e9rotation automatique", "num\u00e9rotations automatiques");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> list = new ArrayList<String>(2);
        list.add("DEVIS_FORMAT");
        list.add("DEVIS_START");
        return list;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> list = new ArrayList<String>(2);
        list.add("DEVIS_FORMAT");
        list.add("DEVIS_START");
        return list;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            private JTextField textDevisFormat;
            private JTextField textDevisStart;
            private JTextField textFactStart;
            private JTextField textFactFormat;
            private JTextField textBonFormat;
            private JTextField textBonStart;
            private JTextField textBonRFormat;
            private JTextField textBonRStart;
            private JTextField textSalarieFormat;
            private JTextField textSalarieStart;
            private JTextField textPropositionFormat;
            private JTextField textPropositionStart;
            private JTextField textRelanceFormat;
            private JTextField textRelanceStart;
            private JTextField textCmdCliFormat;
            private JTextField textCmdCliStart;
            private JTextField textCmdFormat;
            private JTextField textCmdStart;
            private JTextField textAffaireFormat;
            private JTextField textAffaireStart;
            private JTextField textAvoirFormat;
            private JTextField textAvoirStart;
            private JTextField textCourrierFormat;
            private JTextField textCourrierStart;
            private Icon iconWarning;
            private JLabel labelNumDevis;
            private JLabel labelNumFact;
            private JLabel labelNumBon;
            private JLabel labelNumSalarie;
            private JLabel labelNumRelance;
            private JLabel labelNumProposition;
            private JLabel labelNumCmdCli;
            private JLabel labelNumCmd;
            private JLabel labelNumBonR;
            private JLabel labelNumAffaire;
            private JLabel labelNumAvoir;
            private JLabel labelNumCourrier;
            private DocumentListener listenText;
            {
                this.textDevisFormat = new JTextField(16);
                this.textDevisStart = new JTextField(6);
                this.textFactStart = new JTextField(6);
                this.textFactFormat = new JTextField(16);
                this.textBonFormat = new JTextField(16);
                this.textBonStart = new JTextField(6);
                this.textBonRFormat = new JTextField(16);
                this.textBonRStart = new JTextField(6);
                this.textSalarieFormat = new JTextField(16);
                this.textSalarieStart = new JTextField(6);
                this.textPropositionFormat = new JTextField(16);
                this.textPropositionStart = new JTextField(6);
                this.textRelanceFormat = new JTextField(16);
                this.textRelanceStart = new JTextField(6);
                this.textCmdCliFormat = new JTextField(16);
                this.textCmdCliStart = new JTextField(6);
                this.textCmdFormat = new JTextField(16);
                this.textCmdStart = new JTextField(6);
                this.textAffaireFormat = new JTextField(16);
                this.textAffaireStart = new JTextField(6);
                this.textAvoirFormat = new JTextField(16);
                this.textAvoirStart = new JTextField(6);
                this.textCourrierFormat = new JTextField(16);
                this.textCourrierStart = new JTextField(6);
                this.iconWarning = ImageIconWarning.getInstance();
                this.listenText = new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.updateLabels();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.updateLabels();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        this.updateLabels();
                    }
                };
            }

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                JLabel labelAvoirFormat = new JLabel("Avoir " + this.getLabelFor("AVOIR_FORMAT"));
                this.add((Component)labelAvoirFormat, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textAvoirFormat, c);
                JLabel labelAvoirStart = new JLabel(this.getLabelFor("AVOIR_START"));
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)labelAvoirStart, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textAvoirStart, c);
                this.labelNumAvoir = new JLabel();
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)this.labelNumAvoir, c);
                JLabel labelDevisFormat = new JLabel("Devis " + this.getLabelFor("DEVIS_FORMAT"));
                ++c.gridy;
                c.gridx = 0;
                this.add((Component)labelDevisFormat, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textDevisFormat, c);
                JLabel labelDevisStart = new JLabel(this.getLabelFor("DEVIS_START"));
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)labelDevisStart, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textDevisStart, c);
                this.labelNumDevis = new JLabel();
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)this.labelNumDevis, c);
                JLabel labelCmdCliFormat = new JLabel("Commande client " + this.getLabelFor("COMMANDE_CLIENT_FORMAT"));
                ++c.gridy;
                c.gridx = 0;
                this.add((Component)labelCmdCliFormat, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textCmdCliFormat, c);
                JLabel labelCmdCliStart = new JLabel(this.getLabelFor("COMMANDE_CLIENT_START"));
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)labelCmdCliStart, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textCmdCliStart, c);
                this.labelNumCmdCli = new JLabel();
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)this.labelNumCmdCli, c);
                JLabel labelCmdFormat = new JLabel("Commande " + this.getLabelFor("COMMANDE_FORMAT"));
                ++c.gridy;
                c.gridx = 0;
                this.add((Component)labelCmdFormat, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textCmdFormat, c);
                JLabel labelCmdStart = new JLabel(this.getLabelFor("COMMANDE_START"));
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)labelCmdStart, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textCmdStart, c);
                this.labelNumCmd = new JLabel();
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)this.labelNumCmd, c);
                JLabel labelBonFormat = new JLabel("Bon de livraison" + this.getLabelFor("BON_L_FORMAT"));
                ++c.gridy;
                c.gridx = 0;
                this.add((Component)labelBonFormat, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textBonFormat, c);
                JLabel labelBonStart = new JLabel(this.getLabelFor("BON_L_START"));
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)labelBonStart, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textBonStart, c);
                this.labelNumBon = new JLabel();
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)this.labelNumBon, c);
                JLabel labelBonRFormat = new JLabel("Bon de r\u00e9ception" + this.getLabelFor("BON_R_FORMAT"));
                ++c.gridy;
                c.gridx = 0;
                this.add((Component)labelBonRFormat, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textBonRFormat, c);
                JLabel labelBonRStart = new JLabel(this.getLabelFor("BON_R_START"));
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)labelBonRStart, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textBonRStart, c);
                this.labelNumBonR = new JLabel();
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)this.labelNumBonR, c);
                JLabel labelFactFormat = new JLabel("Facture " + this.getLabelFor("FACT_FORMAT"));
                ++c.gridy;
                c.gridx = 0;
                this.add((Component)labelFactFormat, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textFactFormat, c);
                JLabel labelFactStart = new JLabel(this.getLabelFor("FACT_START"));
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)labelFactStart, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textFactStart, c);
                this.labelNumFact = new JLabel();
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)this.labelNumFact, c);
                JLabel labelSalarieFormat = new JLabel("Salari\u00e9 " + this.getLabelFor("SALARIE_FORMAT"));
                ++c.gridy;
                c.gridx = 0;
                this.add((Component)labelSalarieFormat, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textSalarieFormat, c);
                JLabel labelSalarieStart = new JLabel(this.getLabelFor("SALARIE_START"));
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)labelSalarieStart, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textSalarieStart, c);
                this.labelNumSalarie = new JLabel();
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)this.labelNumSalarie, c);
                JLabel labelAffaireFormat = new JLabel("Affaire " + this.getLabelFor("AFFAIRE_FORMAT"));
                ++c.gridy;
                c.gridx = 0;
                this.add((Component)labelAffaireFormat, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textAffaireFormat, c);
                JLabel labelAffaireStart = new JLabel(this.getLabelFor("AFFAIRE_START"));
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)labelAffaireStart, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textAffaireStart, c);
                this.labelNumAffaire = new JLabel();
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)this.labelNumAffaire, c);
                JLabel labelPropositionFormat = new JLabel("Proposition " + this.getLabelFor("PROPOSITION_FORMAT"));
                ++c.gridy;
                c.gridx = 0;
                this.add((Component)labelPropositionFormat, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textPropositionFormat, c);
                JLabel labelPropositionStart = new JLabel(this.getLabelFor("PROPOSITION_START"));
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)labelPropositionStart, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textPropositionStart, c);
                this.labelNumProposition = new JLabel();
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)this.labelNumProposition, c);
                JLabel labelCourrierFormat = new JLabel("Courrier " + this.getLabelFor("COURRIER_FORMAT"));
                ++c.gridy;
                c.gridx = 0;
                this.add((Component)labelCourrierFormat, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textCourrierFormat, c);
                JLabel labelCourrierStart = new JLabel(this.getLabelFor("COURRIER_START"));
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)labelCourrierStart, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textCourrierStart, c);
                this.labelNumCourrier = new JLabel();
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)this.labelNumCourrier, c);
                JLabel labelRelanceFormat = new JLabel("Relance " + this.getLabelFor("RELANCE_FORMAT"));
                ++c.gridy;
                c.gridx = 0;
                this.add((Component)labelRelanceFormat, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textRelanceFormat, c);
                JLabel labelRelanceStart = new JLabel(this.getLabelFor("RELANCE_START"));
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)labelRelanceStart, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textRelanceStart, c);
                this.labelNumRelance = new JLabel();
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)this.labelNumRelance, c);
                JLabel labelExemple = new JLabel("Exemple de format : 'Fact'yyyy0000");
                ++c.gridy;
                c.gridx = 0;
                c.gridwidth = 0;
                c.weighty = 1.0;
                c.anchor = 18;
                this.add((Component)labelExemple, c);
                this.textBonFormat.getDocument().addDocumentListener(this.listenText);
                this.textBonStart.getDocument().addDocumentListener(this.listenText);
                this.textDevisFormat.getDocument().addDocumentListener(this.listenText);
                this.textDevisStart.getDocument().addDocumentListener(this.listenText);
                this.textFactFormat.getDocument().addDocumentListener(this.listenText);
                this.textFactStart.getDocument().addDocumentListener(this.listenText);
                this.textSalarieFormat.getDocument().addDocumentListener(this.listenText);
                this.textSalarieStart.getDocument().addDocumentListener(this.listenText);
                this.textPropositionFormat.getDocument().addDocumentListener(this.listenText);
                this.textPropositionStart.getDocument().addDocumentListener(this.listenText);
                this.textRelanceFormat.getDocument().addDocumentListener(this.listenText);
                this.textRelanceStart.getDocument().addDocumentListener(this.listenText);
                this.textCmdCliFormat.getDocument().addDocumentListener(this.listenText);
                this.textCmdCliStart.getDocument().addDocumentListener(this.listenText);
                this.textCmdFormat.getDocument().addDocumentListener(this.listenText);
                this.textCmdStart.getDocument().addDocumentListener(this.listenText);
                this.textBonRFormat.getDocument().addDocumentListener(this.listenText);
                this.textBonRStart.getDocument().addDocumentListener(this.listenText);
                this.textAffaireFormat.getDocument().addDocumentListener(this.listenText);
                this.textAffaireStart.getDocument().addDocumentListener(this.listenText);
                this.textAvoirFormat.getDocument().addDocumentListener(this.listenText);
                this.textAvoirStart.getDocument().addDocumentListener(this.listenText);
                this.textCourrierFormat.getDocument().addDocumentListener(this.listenText);
                this.textCourrierStart.getDocument().addDocumentListener(this.listenText);
                this.addRequiredSQLObject(this.textBonFormat, "BON_L_FORMAT");
                this.addRequiredSQLObject(this.textBonStart, "BON_L_START");
                this.addRequiredSQLObject(this.textDevisFormat, "DEVIS_FORMAT");
                this.addRequiredSQLObject(this.textDevisStart, "DEVIS_START");
                this.addRequiredSQLObject(this.textFactFormat, "FACT_FORMAT");
                this.addRequiredSQLObject(this.textFactStart, "FACT_START");
                this.addRequiredSQLObject(this.textSalarieFormat, "SALARIE_FORMAT");
                this.addRequiredSQLObject(this.textSalarieStart, "SALARIE_START");
                this.addRequiredSQLObject(this.textPropositionFormat, "PROPOSITION_FORMAT");
                this.addRequiredSQLObject(this.textPropositionStart, "PROPOSITION_START");
                this.addRequiredSQLObject(this.textRelanceFormat, "RELANCE_FORMAT");
                this.addRequiredSQLObject(this.textRelanceStart, "RELANCE_START");
                this.addRequiredSQLObject(this.textCmdCliFormat, "COMMANDE_CLIENT_FORMAT");
                this.addRequiredSQLObject(this.textCmdCliStart, "COMMANDE_CLIENT_START");
                this.addRequiredSQLObject(this.textCmdFormat, "COMMANDE_FORMAT");
                this.addRequiredSQLObject(this.textCmdStart, "COMMANDE_START");
                this.addRequiredSQLObject(this.textBonRFormat, "BON_R_FORMAT");
                this.addRequiredSQLObject(this.textBonRStart, "BON_R_START");
                this.addRequiredSQLObject(this.textAffaireFormat, "AFFAIRE_FORMAT");
                this.addRequiredSQLObject(this.textAffaireStart, "AFFAIRE_START");
                this.addRequiredSQLObject(this.textAvoirFormat, "AVOIR_FORMAT");
                this.addRequiredSQLObject(this.textAvoirStart, "AVOIR_START");
                this.addRequiredSQLObject(this.textCourrierFormat, "COURRIER_FORMAT");
                this.addRequiredSQLObject(this.textCourrierStart, "COURRIER_START");
                this.updateLabels();
            }

            private void updateLabels() {
                this.updateLabel(this.textDevisStart, this.textDevisFormat, this.labelNumDevis);
                this.updateLabel(this.textBonStart, this.textBonFormat, this.labelNumBon);
                this.updateLabel(this.textBonRStart, this.textBonRFormat, this.labelNumBonR);
                this.updateLabel(this.textFactStart, this.textFactFormat, this.labelNumFact);
                this.updateLabel(this.textSalarieStart, this.textSalarieFormat, this.labelNumSalarie);
                this.updateLabel(this.textPropositionStart, this.textPropositionFormat, this.labelNumProposition);
                this.updateLabel(this.textRelanceStart, this.textRelanceFormat, this.labelNumRelance);
                this.updateLabel(this.textCmdCliStart, this.textCmdCliFormat, this.labelNumCmdCli);
                this.updateLabel(this.textCmdStart, this.textCmdFormat, this.labelNumCmd);
                this.updateLabel(this.textAffaireStart, this.textAffaireFormat, this.labelNumAffaire);
                this.updateLabel(this.textAvoirStart, this.textAvoirFormat, this.labelNumAvoir);
                this.updateLabel(this.textCourrierStart, this.textCourrierFormat, this.labelNumCourrier);
            }

            private void updateLabel(JTextField textStart, JTextField textFormat, JLabel label) {
                if (textStart.getText().trim().length() > 0) {
                    String numProposition = NumerotationAutoSQLElement.getNextNumero(textFormat.getText(), Integer.parseInt(textStart.getText()));
                    if (numProposition != null) {
                        label.setText(" --> " + numProposition);
                        label.setIcon(null);
                    } else {
                        label.setIcon(this.iconWarning);
                        label.setText("");
                    }
                } else {
                    label.setIcon(this.iconWarning);
                    label.setText("");
                }
            }
        };
    }

    public static final String getNextNumero(Class<? extends SQLElement> clazz) {
        SQLRow rowNum = TABLE_NUM.getRow(2);
        String s = map.get(clazz);
        String format = rowNum.getString(String.valueOf(s) + FORMAT);
        int start = rowNum.getInt(String.valueOf(s) + START);
        return NumerotationAutoSQLElement.getNextNumero(format, start);
    }

    protected static final String getNextNumero(String format, int start) {
        if (start < 0) {
            return null;
        }
        int c = format.indexOf(48);
        if (format.trim().length() > 0) {
            if (c >= 0) {
                String prefix = format.substring(0, c);
                String suffix = format.substring(c, format.length());
                String d = prefix;
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(prefix);
                    d = dateFormat.format(new Date());
                }
                catch (IllegalArgumentException e) {
                    System.err.println("pattern incorrect");
                }
                DecimalFormat numberFormat = new DecimalFormat(suffix);
                String n = numberFormat.format(start);
                return String.valueOf(d) + n;
            }
            String d = format;
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                d = dateFormat.format(new Date());
            }
            catch (IllegalArgumentException e) {
                System.err.println("pattern incorrect");
            }
            return String.valueOf(d) + String.valueOf(start);
        }
        return String.valueOf(start);
    }

    public static final String getNextCodeLettrage() {
        SQLRow rowNum = TABLE_NUM.getRow(2);
        String string = rowNum.getString("CODE_LETTRAGE");
        String s = string == null ? "" : string.trim().toUpperCase();
        return NumerotationAutoSQLElement.getNextCodeLetrrage(s);
    }

    public static final String getNextCodeLetrrage(String code) {
        if ((code = code.trim()) == null || code.length() == 0) {
            return "AAA";
        }
        char[] charArray = code.toCharArray();
        int c = 65;
        int i = charArray.length - 1;
        while (i >= 0 && (c = charArray[i]) == 90) {
            --i;
        }
        if (i >= 0) {
            charArray[i] = c = (int)((char)(c + 1));
            int j = i + 1;
            while (j < charArray.length) {
                charArray[j] = 65;
                ++j;
            }
            code = String.valueOf(charArray);
        } else {
            StringBuffer buf = new StringBuffer(code.length() + 1);
            int nb = code.length() + 1;
            int j = 0;
            while (j < nb) {
                buf.append('A');
                ++j;
            }
            code = buf.toString();
        }
        return code;
    }

    private static boolean isNumeroExist(SQLElement elt, int num) {
        if (num < 0) {
            return true;
        }
        SQLSelect sel = new SQLSelect(elt.getTable().getBase());
        sel.addSelect(elt.getTable().getKey());
        sel.setWhere(new Where((FieldRef)elt.getTable().getField("NUMERO"), "LIKE", (Object)NumerotationAutoSQLElement.getPattern(elt, num)));
        System.err.println("NumerotationAutoSQLElement.isNumeroExist() " + sel.asString());
        List liste = (List)Configuration.getInstance().getBase().getDataSource().execute(sel.asString(), new SQLRowListRSH(elt.getTable(), true));
        return liste.size() > 0;
    }

    private static String getPattern(SQLElement elt, int num) {
        SQLRow rowNum = TABLE_NUM.getRow(2);
        String s = map.get(elt.getClass());
        String format = rowNum.getString(String.valueOf(s) + FORMAT);
        format = format.replaceAll("y|d|M", "_");
        format = format.replaceAll("'", "");
        int c = format.indexOf(48);
        String numero = "";
        if (format.trim().length() > 0) {
            if (c >= 0) {
                String prefix = format.substring(0, c);
                String suffix = format.substring(c, format.length());
                String d = prefix;
                DecimalFormat numberFormat = new DecimalFormat(suffix);
                String n = numberFormat.format(num);
                numero = String.valueOf(d) + n;
            } else {
                String d = format;
                numero = String.valueOf(d) + String.valueOf(num);
            }
        } else {
            numero = String.valueOf(num);
        }
        return numero;
    }

    public static void fixNumerotation(SQLElement elt) {
        String s;
        SQLRow rowNum = TABLE_NUM.getRow(2);
        int start = rowNum.getInt(String.valueOf(s = map.get(elt.getClass())) + START);
        if (!NumerotationAutoSQLElement.isNumeroExist(elt, start - 1)) {
            int i = 2;
            while (!NumerotationAutoSQLElement.isNumeroExist(elt, start - i)) {
                ++i;
            }
            if (start - i >= 0) {
                SQLRowValues rowVals = rowNum.createEmptyUpdateRow();
                rowVals.put(String.valueOf(s) + START, start - i + 1);
                try {
                    rowVals.update();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void addListeners() {
        for (Class<? extends SQLElement> clazz : map.keySet()) {
            final SQLElement elt = Configuration.getInstance().getDirectory().getElement(clazz);
            if (elt != null) {
                elt.getTable().addTableModifiedListener(new SQLTableModifiedListener(){

                    @Override
                    public void tableModified(SQLTableEvent evt) {
                        SQLRow row;
                        if (evt.getMode() == SQLTableEvent.Mode.ROW_UPDATED && (row = evt.getRow()).isArchived()) {
                            NumerotationAutoSQLElement.fixNumerotation(elt);
                        }
                    }
                });
                continue;
            }
            System.err.println(clazz);
            Thread.dumpStack();
        }
    }
}

