/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.io.File;
import java.io.IOException;
import javax.jnlp.ExtensionInstallerService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.swing.JOptionPane;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.sql.Configuration;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.StreamUtils;
import org.openconcerto.utils.Unzip;

public class GestionJNLPInstaller {
    public static final String DB_CACHE_PATH = "webstart/DBCache.zip";

    public static void main(String[] args) {
        if (args.length == 0) {
            return;
        }
        String arg0 = args[0].trim().toLowerCase();
        try {
            ExtensionInstallerService installer = (ExtensionInstallerService)ServiceManager.lookup((String)ExtensionInstallerService.class.getName());
            try {
                ComptaPropsConfiguration conf = ComptaPropsConfiguration.create();
                Configuration.setInstance(conf);
                if (arg0.equals("install")) {
                    if (conf.isServerless()) {
                        conf.getSystemRoot();
                    } else {
                        try {
                            File dir = GestionJNLPInstaller.getDBCacheDir(conf);
                            if (!dir.exists() || dir.listFiles().length == 0) {
                                FileUtils.mkdir_p(dir);
                                File tmp = File.createTempFile(GestionJNLPInstaller.class.getName(), "DBCache.zip");
                                tmp.deleteOnExit();
                                StreamUtils.copy(GestionJNLPInstaller.class.getResourceAsStream("/webstart/DBCache.zip"), tmp);
                                Unzip.toDir(tmp, dir);
                                tmp.delete();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    conf.destroy();
                } else if (arg0.equals("uninstall")) {
                    File toRm = conf.getConfDir();
                    conf.destroy();
                    if (!FileUtils.rmR(toRm)) {
                        throw new IOException("Couldn't delete " + toRm);
                    }
                    assert (!toRm.exists() && !conf.getDataDir().exists());
                } else {
                    throw new IllegalArgumentException("Unknown argument " + arg0);
                }
                installer.setStatus("OK");
                installer.installSucceeded(false);
            }
            catch (Throwable e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "Install failed : " + ExceptionUtils.getStackTrace(e));
                installer.setStatus("Install failed : " + e);
                installer.installFailed();
            }
        }
        catch (UnavailableServiceException e) {
            throw new IllegalStateException(e);
        }
    }

    private static File getDBCacheDir(ComptaPropsConfiguration conf) {
        assert (Configuration.getInstance() == conf);
        return conf.getServer().getFileCache().getServerCache().getDir();
    }

    public static String getDBCacheDir(String confFile) {
        ComptaPropsConfiguration conf = ComptaPropsConfiguration.create(false, new File(confFile));
        Configuration.setInstance(conf);
        String res = GestionJNLPInstaller.getDBCacheDir(conf).getAbsolutePath();
        conf.destroy();
        return res;
    }
}

