/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.openconcerto.erp.action.NouvelleConnexionAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.MainFrame;
import org.openconcerto.erp.config.ServerFinderPanel;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.core.sales.quote.element.DevisSQLElement;
import org.openconcerto.erp.core.sales.quote.ui.DevisItemTable;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.erp.panel.PostgreSQLFrame;
import org.openconcerto.erp.panel.UserExitPanel;
import org.openconcerto.ftp.updater.UpdateManager;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.model.SQLRequestLog;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.view.ListeModifyPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.component.WaitIndeterminatePanel;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.protocol.Helper;

public class Gestion {
    private static List<Image> frameIcon;
    static final boolean MAC_OS_X;
    public static PostgreSQLFrame pgFrameStart;
    private static JDialog frameExit;

    static {
        MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
        pgFrameStart = null;
        frameExit = null;
    }

    private static String getNimbusClassName() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n = lookAndFeelInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
            if ("Nimbus".equals(info.getName())) {
                return info.getClassName();
            }
            ++n2;
        }
        return null;
    }

    static boolean inWebStart() {
        try {
            return Class.forName("javax.jnlp.ServiceManager").getMethod("getServiceNames", new Class[0]).invoke(null, new Object[0]) != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static void openPDF(File f) {
        try {
            FileUtils.openFile(f);
        }
        catch (IOException e) {
            ExceptionHandler.handle("Impossible d'ouvrir le fichier " + f + ".\nV\u00e9rifiez qu'un logiciel pour lire les fichiers PDF est install\u00e9 sur votre ordinateur (http://get.adobe.com/fr/reader).");
        }
    }

    public static void main(String[] args) {
        File f;
        System.out.println(String.valueOf(System.getProperty("java.vendor", "??")) + " - " + System.getProperty("java.version", "??"));
        System.out.println(String.valueOf(System.getProperty("java.runtime.version", "??")) + " - " + System.getProperty("os.name", "??"));
        ExceptionHandler.setForceUI(true);
        ExceptionHandler.setForumURL("http://www.openconcerto.org/forum");
        final boolean logRequests = Boolean.getBoolean("org.openconcerto.sql.logRequests");
        if (logRequests) {
            SQLRequestLog.setEnabled(true);
        }
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        ToolTipManager.sharedInstance().setInitialDelay(0);
        System.setProperty("sun.java2d.pmoffscreen", "false");
        System.setProperty("org.openconcerto.editpanel.noborder", "true");
        System.setProperty("org.openconcerto.editpanel.separator", "true");
        System.setProperty("org.openconcerto.sql.listPanel.deafEditPanel", "true");
        System.setProperty("org.openconcerto.ui.addComboButton", "true");
        System.setProperty("org.openconcerto.sql.structure.useXML", "true");
        System.setProperty("org.openconcerto.sql.requiredSuffix", "");
        System.setProperty("org.openconcerto.sql.comboCanModify", "true");
        System.setProperty("org.openconcerto.ui.removeSwapSearchCheckBox", "true");
        if (System.getProperty("org.openconcerto.oo.useODSViewer") == null) {
            System.setProperty("org.openconcerto.oo.useODSViewer", "true");
        }
        if (System.getProperty("org.openconcerto.sql.deafState") == null) {
            System.setProperty("org.openconcerto.sql.deafState", "true");
        }
        IListe.setForceAlternateCellRenderer(true);
        ITableModel.setDefaultEditable(false);
        SplashScreen.getSplashScreen();
        try {
            String nimbusClassName = Gestion.getNimbusClassName();
            if (nimbusClassName == null || !System.getProperty("os.name", "??").toLowerCase().contains("linux")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(nimbusClassName);
                UIManager.put("control", new Color(240, 240, 240));
                UIManager.put("Table.showGrid", Boolean.TRUE);
                UIManager.put("FormattedTextField.background", new Color(240, 240, 240));
                UIManager.put("Table.alternateRowColor", Color.WHITE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        UpdateManager.start();
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        ComboSQLRequest.setDefaultFieldSeparator(" ");
        long t1 = System.currentTimeMillis();
        ComptaPropsConfiguration conf = ComptaPropsConfiguration.create(true);
        if (conf == null) {
            ServerFinderPanel.main(new String[0]);
            return;
        }
        if (Gestion.inWebStart()) {
            Helper.setURLStreamHandlerFactory();
            System.setSecurityManager(null);
        }
        Configuration.setInstance(conf);
        long t4 = System.currentTimeMillis();
        System.out.println("Ip:" + conf.getServerIp());
        if (conf.getServerIp().startsWith("127.0.0.1:6543") && !(f = new File("PostgreSQL/data/postmaster.pid")).exists()) {
            Gestion.startDB(conf);
        }
        try {
            conf.getBase();
            SQLPreferences.getPrefTable(conf.getRoot());
        }
        catch (Exception e) {
            System.out.println("Init phase 1 error:" + (System.currentTimeMillis() - t4) + "ms");
            ExceptionHandler.die("Erreur de connexion \u00e0 la base de donn\u00e9es", e);
            return;
        }
        try {
            File moduleDir = new File("Modules");
            moduleDir.mkdir();
            ModuleManager.getInstance().addFactories(moduleDir);
        }
        catch (Throwable e) {
            ExceptionHandler.handle("Erreur d'acc\u00e8s aux modules", e);
        }
        System.out.println("Init phase 1:" + (System.currentTimeMillis() - t1) + "ms");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                long t1 = System.currentTimeMillis();
                AWTEventListener awtListener = new AWTEventListener(){

                    @Override
                    public final void eventDispatched(AWTEvent event) {
                        HierarchyEvent hevent;
                        Component changed;
                        if (!$assertionsDisabled && event == null) {
                            throw new AssertionError();
                        }
                        if (event instanceof HierarchyEvent && event.getID() == 1400 && (changed = (hevent = (HierarchyEvent)event).getChanged()) instanceof JFrame && (hevent.getChangeFlags() & 2L) != 0L && changed.isDisplayable()) {
                            JFrame frame = (JFrame)changed;
                            frame.setIconImages(Gestion.getFrameIcon());
                        }
                    }
                };
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                if (!$assertionsDisabled && toolkit == null) {
                    throw new AssertionError();
                }
                toolkit.addAWTEventListener(awtListener, 32768L);
                if (logRequests) {
                    SQLRequestLog.showFrame();
                }
                JFrame f = null;
                try {
                    try {
                        f = new NouvelleConnexionAction().createFrame();
                        if (f != null) {
                            f.pack();
                            f.setResizable(false);
                            f.addWindowListener(new WindowAdapter(){

                                @Override
                                public void windowClosing(WindowEvent e) {
                                    Gestion.askForExit();
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        Thread.dumpStack();
                        e.printStackTrace();
                        ExceptionHandler.handle("Erreur lors de la tentative de connexion \u00e0 la base.", e);
                        if (f != null) {
                            FrameUtil.show(f);
                        }
                        System.out.println("Init phase 2:" + (System.currentTimeMillis() - t1) + "ms");
                    }
                }
                finally {
                    if (f != null) {
                        FrameUtil.show(f);
                    }
                    System.out.println("Init phase 2:" + (System.currentTimeMillis() - t1) + "ms");
                }
            }
        });
        System.setProperty("org.openconcerto.sql.identifier.allowRemoval", "true");
        ModuleManager.getInstance().invoke(new IClosure<ModuleManager>(){

            @Override
            public void executeChecked(ModuleManager mngr) {
                try {
                    Exception exn = mngr.setup();
                    if (exn != null) {
                        ExceptionHandler.handle(MainFrame.getInstance(), "Impossible de d\u00e9marrer les modules", exn);
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.die("Impossible de d\u00e9marrer les modules requis", e);
                }
            }
        });
    }

    private static void startDB(PropsConfiguration conf) {
        ArrayList<String> l = new ArrayList<String>();
        l.add("Lancement de la base de donn\u00e9es");
        PostgreSQLFrame pgFrame = null;
        try {
            pgFrame = new PostgreSQLFrame("D\u00e9marrage en cours");
            pgFrame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.err.println("start DB");
        WaitIndeterminatePanel panel = new WaitIndeterminatePanel(l);
        PanelFrame f = new PanelFrame(panel, "Gestion NX");
        f.setResizable(false);
        f.setLocationRelativeTo(null);
        f.setVisible(true);
        String serverAdr = conf.getProperty("server.ip");
        if (serverAdr.startsWith("127.0.0.1") || serverAdr.startsWith("localhost")) {
            Runtime runtime = Runtime.getRuntime();
            try {
                File file = new File(".\\PostgreSQL\\bin\\");
                if (!file.canWrite()) {
                    ExceptionHandler.die("Vous n'avez pas le droit en \u00e9criture sur la base de donn\u00e9es.\nImpossible de lancer le logiciel!");
                }
                final Process p = runtime.exec(new String[]{"cmd.exe", "/C", "launchPostGres.bat"}, null, file);
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                            String line = "";
                            try {
                                while ((line = reader.readLine()) != null) {
                                    System.out.println(line);
                                }
                            }
                            finally {
                                reader.close();
                            }
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }.start();
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                            String line = "";
                            try {
                                while ((line = reader.readLine()) != null) {
                                    System.err.println(line);
                                }
                            }
                            finally {
                                reader.close();
                            }
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }.start();
                try {
                    p.waitFor();
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        } else {
            System.err.println("L'adresse du serveur n'est pas en local (" + serverAdr + ").");
        }
        panel.taskEnded(0);
        if (pgFrame != null) {
            pgFrame.dispose();
        }
        f.dispose();
        String realIp = "127.0.0.1";
        realIp = Gestion.getIp();
        try {
            pgFrameStart = new PostgreSQLFrame(String.valueOf(realIp) + " port " + "6543");
            pgFrameStart.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getIp() {
        String realIp = "127.0.0.1";
        try {
            InetAddress Ip = InetAddress.getLocalHost();
            realIp = Ip.getHostAddress();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                Enumeration<InetAddress> e2 = ni.getInetAddresses();
                while (e2.hasMoreElements()) {
                    InetAddress ip = e2.nextElement();
                    String iip = ip.toString().replace('/', ' ').trim();
                    if (!iip.startsWith("192")) continue;
                    return iip;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return realIp;
    }

    private static void testModifyRowValuesTable() {
        JFrame f = new JFrame();
        f.getContentPane().setLayout(new GridLayout(1, 1));
        f.getContentPane().add(new ListeModifyPanel(new DevisSQLElement()));
        f.pack();
        f.setSize(800, 600);
        f.setVisible(true);
        f.setDefaultCloseOperation(2);
    }

    private static void testRowValuesTable() {
        JFrame f = new JFrame();
        f.getContentPane().setLayout(new GridLayout(1, 1));
        f.getContentPane().add(new DevisItemTable());
        f.pack();
        f.setSize(800, 600);
        f.setVisible(true);
        f.setDefaultCloseOperation(2);
    }

    static void askForExit() {
        JDialog exitDialog = new JDialog();
        exitDialog.setModal(true);
        if (frameExit == null) {
            frameExit = new JDialog();
            frameExit.setContentPane(new UserExitPanel());
            frameExit.setTitle("Quitter");
            frameExit.setModal(true);
            frameExit.setIconImages(Gestion.getFrameIcon());
            frameExit.setDefaultCloseOperation(1);
        }
        frameExit.pack();
        frameExit.setResizable(false);
        frameExit.setLocationRelativeTo(null);
        frameExit.setAlwaysOnTop(true);
        frameExit.setVisible(true);
    }

    public static List<Image> getFrameIcon() {
        if (frameIcon == null) {
            frameIcon = new ArrayList<Image>();
            int[] sizes = new int[]{16, 32, 48, 96};
            int i = 0;
            while (i < sizes.length) {
                int v = sizes[i];
                try {
                    frameIcon.add(new ImageIcon(Gestion.class.getResource(String.valueOf(v) + ".png")).getImage());
                }
                catch (Exception e) {
                    ExceptionHandler.die("Impossible de charger l'icone de fenetre " + v + ".png");
                }
                ++i;
            }
        }
        return frameIcon;
    }
}

